/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlStartTransactionMode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlStartTransaction
extends SqlCall {
    private final Operator operator;

    public IgniteSqlStartTransaction(SqlParserPos pos, IgniteSqlStartTransactionMode mode) {
        super(pos);
        this.operator = new Operator(mode);
    }

    public IgniteSqlStartTransactionMode getMode() {
        return this.operator.mode;
    }

    public SqlOperator getOperator() {
        return this.operator;
    }

    public List<SqlNode> getOperandList() {
        return List.of();
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        switch (this.operator.mode) {
            case READ_ONLY: {
                writer.keyword("READ ONLY");
                break;
            }
            case READ_WRITE: {
                writer.keyword("READ WRITE");
                break;
            }
            case IMPLICIT_READ_WRITE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected start transaction mode: " + this.operator.mode);
            }
        }
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        private final IgniteSqlStartTransactionMode mode;

        protected Operator(IgniteSqlStartTransactionMode mode) {
            super("START TRANSACTION", SqlKind.OTHER);
            this.mode = mode;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlStartTransaction(pos, this.mode);
        }
    }
}

