/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.jetbrains.annotations.Nullable;

public class IgniteTableScanWithAggregate
extends TableScan
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "TableScanWithAggregate";
    private final long sourceId;
    private final List<AggregateCall> aggCalls;
    @Nullable
    private final ImmutableBitSet groupSet;

    public IgniteTableScanWithAggregate(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelOptTable table, List<AggregateCall> aggCalls, @Nullable ImmutableBitSet groupSet) {
        this(-1L, cluster, traits, hints, table, aggCalls, groupSet);
    }

    private IgniteTableScanWithAggregate(long sourceId, RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelOptTable table, List<AggregateCall> aggCalls, @Nullable ImmutableBitSet groupSet) {
        super(cluster, traits, hints, table);
        this.sourceId = sourceId;
        this.groupSet = groupSet;
        this.aggCalls = aggCalls;
    }

    public IgniteTableScanWithAggregate(RelInput input) {
        super(input);
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
        this.aggCalls = input.getAggregateCalls("aggs");
        this.groupSet = input.getBitSet("group");
    }

    public List<AggregateCall> getAggregates() {
        return this.aggCalls;
    }

    @Nullable
    public ImmutableBitSet getGroups() {
        return this.groupSet;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    public RelDataType deriveRowType() {
        RelDataType derType = ((IgniteTable)this.getTable().unwrap(IgniteTable.class)).getRowType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()));
        return Aggregate.deriveRowType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()), (RelDataType)derType, (boolean)false, (ImmutableBitSet)this.groupSet, null, this.aggCalls);
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L).item("table", (Object)this.getTable().getQualifiedName()).itemIf("tableId", (Object)((IgniteTable)this.getTable().unwrap(IgniteTable.class)).id(), pw.getDetailLevel() == SqlExplainLevel.ALL_ATTRIBUTES).itemIf("tableVer", (Object)((IgniteTable)this.getTable().unwrap(IgniteTable.class)).version(), pw.getDetailLevel() == SqlExplainLevel.ALL_ATTRIBUTES).item("group", (Object)this.groupSet).itemIf("aggs", this.aggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord ord : Ord.zip(this.aggCalls)) {
                pw.item((String)Util.first((Object)((AggregateCall)ord.e).name, (Object)("agg#" + ord.i)), ord.e);
            }
        }
        return pw;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeTinyCost();
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTableScanWithAggregate(this.sourceId, cluster, this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.aggCalls, this.groupSet);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteTableScanWithAggregate(sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.aggCalls, this.groupSet);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.useSecondaryStorage(true).addTable(this.table).addGroup(this.groupSet == null ? ImmutableBitSet.of() : this.groupSet, this.table.getRowType()).addAggregation(this.aggCalls, this.table.getRowType());
    }
}

