/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite.internal.storage.operation.AggregatedScan;
import org.apache.ignite.internal.storage.operation.StorageOptimizedOperation;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.subscription.TransformingPublisher;
import org.jetbrains.annotations.Nullable;

public class SecondaryStorageScannableTableImpl
implements ScannableTable {
    private final TableRowConverterFactory replicaConverterFactory;
    private final InternalTable internalTable;

    public SecondaryStorageScannableTableImpl(InternalTable internalTable, TableRowConverterFactory replicaConverterFactory) {
        this.internalTable = internalTable;
        this.replicaConverterFactory = replicaConverterFactory;
    }

    @Override
    public <RowT> Flow.Publisher<RowT> scan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithTerm, RowHandler.RowFactory<RowT> rowFactory, int @Nullable [] requiredColumns) {
        TxAttributes txAttributes = ctx.txAttributes();
        assert (txAttributes.readOnly()) : "Secondary storage doesn't support RW transactions";
        HybridTimestamp readTime = txAttributes.time();
        assert (readTime != null);
        int partId = partWithTerm.partId();
        Flow.Publisher pub = this.internalTable.scan(partId, txAttributes.id(), readTime, ctx.localNode(), txAttributes.coordinatorId(), false, requiredColumns == null ? null : ImmutableBitSet.of((int[])requiredColumns).toBitSet());
        TableRowConverter rowConverter = this.replicaConverterFactory.create(requiredColumns, partId);
        return new TransformingPublisher(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> executeStorageOperation(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithTerm, StorageOptimizedOperation storageOptimizedOperation, RowHandler.RowFactory<RowT> rowFactory) {
        TxAttributes txAttributes = ctx.txAttributes();
        HybridTimestamp readTimestamp = txAttributes.time();
        assert (readTimestamp != null) : "Expected read-only transaction";
        assert (this.internalTable.hasSecondaryStorage()) : "Underlying table does not have secondary storage";
        Flow.Publisher pub = this.internalTable.performSecondaryStorageOperation(partWithTerm.partId(), txAttributes.id(), txAttributes.coordinatorId(), readTimestamp, ctx.localNode(), storageOptimizedOperation);
        if (!(storageOptimizedOperation instanceof AggregatedScan)) {
            throw new IllegalStateException("Unexpected storage operation: " + storageOptimizedOperation);
        }
        int numElements = ((AggregatedScan)storageOptimizedOperation).aggregates().size();
        return new TransformingPublisher(pub, row -> rowFactory.create((InternalTuple)new BinaryTuple(numElements, row.tupleSlice())));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexRangeScan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithTerm, RowHandler.RowFactory<RowT> rowFactory, int indexId, List<String> columns, @Nullable RangeCondition<RowT> cond, int @Nullable [] requiredColumns) {
        throw new UnsupportedOperationException("Index scan operation is not supported");
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexLookup(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithTerm, RowHandler.RowFactory<RowT> rowFactory, int indexId, List<String> columns, RowT key, int @Nullable [] requiredColumns) {
        throw new UnsupportedOperationException("Index lookup operation is not supported");
    }

    @Override
    public <RowT> CompletableFuture<@Nullable RowT> primaryKeyLookup(ExecutionContext<RowT> ctx, InternalTransaction tx, RowHandler.RowFactory<RowT> rowFactory, RowT key, int[] requiredColumns) {
        throw new UnsupportedOperationException("Primary index lookup operation is not supported");
    }

    @Override
    public CompletableFuture<Long> estimatedSize() {
        throw new UnsupportedOperationException("Estimated size operation is not supported");
    }
}

