/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.ignite.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScanWithAggregate;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteUnionAll;
import org.apache.ignite.internal.sql.engine.rel.IgniteValues;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;

class PrivilegesCollector {
    PrivilegesCollector() {
    }

    static Set<Privilege> getPrivileges(IgniteRel rel) {
        final HashSet<Privilege> res = new HashSet<Privilege>();
        RexVisitorImpl<Void> rexVisitor = new RexVisitorImpl<Void>(true){

            public Void visitCall(RexCall call) {
                SqlOperator op = call.getOperator();
                if (GridgainSqlOperatorTable.NEXTVAL.equals((Object)op) || GridgainSqlOperatorTable.CURRVAL.equals((Object)op) || GridgainSqlOperatorTable.SETVAL.equals((Object)op)) {
                    String name = (String)((RexLiteral)call.getOperands().get(0)).getValueAs(String.class);
                    res.add(Privilege.builder().action(Action.USE_SEQUENCE).selector(Selector.sequence((String)name)).build());
                }
                return (Void)super.visitCall(call);
            }
        };
        IgniteRelVisitor<IgniteRel> relVisitor = new IgniteRelVisitor<IgniteRel>((RexVisitor)rexVisitor){
            final /* synthetic */ RexVisitor val$rexVisitor;
            {
                this.val$rexVisitor = rexVisitor;
            }

            @Override
            public IgniteRel visit(IgniteSender rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteFilter rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteTrimExchange rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteProject rel) {
                this.visitRex(rel.expressions());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteNestedLoopJoin rel) {
                this.visitRex(rel.getCondition());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteHashJoin rel) {
                this.visitRex(rel.getCondition());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteCorrelatedNestedLoopJoin rel) {
                this.visitRex(rel.getCondition());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteMergeJoin rel) {
                this.visitRex(rel.getCondition());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteIndexScan rel) {
                res.add(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, rel.getTable().getQualifiedName()));
                this.visitRex(rel.condition());
                this.visitRex(rel.projects());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableScan rel) {
                res.add(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, rel.getTable().getQualifiedName()));
                this.visitRex(rel.condition());
                this.visitRex(rel.projects());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableScanWithAggregate rel) {
                res.add(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, rel.getTable().getQualifiedName()));
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteSystemViewScan rel) {
                res.add(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, rel.getTable().getQualifiedName()));
                this.visitRex(rel.condition());
                this.visitRex(rel.projects());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteReceiver rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteExchange rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteColocatedHashAggregate rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteMapHashAggregate rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteReduceHashAggregate rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteColocatedSortAggregate rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteMapSortAggregate rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteReduceSortAggregate rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableModify rel) {
                res.addAll(PrivilegesCollector.getPrivileges(rel.getOperation(), rel.getTable().getQualifiedName()));
                this.visitRex(rel.getSourceExpressionList());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteValues rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteUnionAll rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteSort rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableSpool rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteSortedIndexSpool rel) {
                this.visitRex(rel.condition());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteLimit rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteHashIndexSpool rel) {
                this.visitRex(rel.condition());
                this.visitRex(rel.searchRow());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteSetOp rel) {
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteTableFunctionScan rel) {
                this.visitRex(rel.getCall());
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteKeyValueGet rel) {
                this.visitRex(rel.projects());
                this.visitRex(rel.keyExpressions());
                this.visitRex(rel.condition());
                this.visitRex(rel.pushUpPredicate());
                res.add(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, rel.getTable().getQualifiedName()));
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteKeyValueModify rel) {
                this.visitRex(rel.expressions());
                res.addAll(PrivilegesCollector.getPrivileges(rel.operation().op, rel.getTable().getQualifiedName()));
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteSelectCount rel) {
                res.add(PrivilegesCollector.buildPrivilege(Action.INSERT_INTO_TABLE, rel.getTable().getQualifiedName()));
                return this.processNode(rel);
            }

            @Override
            public IgniteRel visit(IgniteRel rel) {
                return rel.accept(this);
            }

            private IgniteRel processNode(IgniteRel rel) {
                List inputs = Commons.cast(rel.getInputs());
                for (int i = 0; i < inputs.size(); ++i) {
                    this.visitChild(rel, i, (IgniteRel)inputs.get(i));
                }
                return rel;
            }

            private void visitChild(IgniteRel parent, int i, IgniteRel child) {
                IgniteRel newChild = this.visit(child);
                if (newChild != child) {
                    parent.replaceInput(i, (RelNode)newChild);
                }
            }

            private void visitRex(RexNode node) {
                if (node != null) {
                    node.accept(this.val$rexVisitor);
                }
            }

            private void visitRex(List<RexNode> nodes) {
                if (nodes != null) {
                    this.val$rexVisitor.visitEach(nodes);
                }
            }
        };
        relVisitor.visit(rel);
        return res;
    }

    private static Set<Privilege> getPrivileges(TableModify.Operation operation, List<String> qualifiedName) {
        switch (operation) {
            case INSERT: {
                return Set.of(PrivilegesCollector.buildPrivilege(Action.INSERT_INTO_TABLE, qualifiedName));
            }
            case UPDATE: {
                return Set.of(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, qualifiedName), PrivilegesCollector.buildPrivilege(Action.UPDATE_TABLE, qualifiedName));
            }
            case MERGE: {
                return Set.of(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, qualifiedName), PrivilegesCollector.buildPrivilege(Action.INSERT_INTO_TABLE, qualifiedName), PrivilegesCollector.buildPrivilege(Action.UPDATE_TABLE, qualifiedName));
            }
            case DELETE: {
                return Set.of(PrivilegesCollector.buildPrivilege(Action.SELECT_FROM_TABLE, qualifiedName), PrivilegesCollector.buildPrivilege(Action.DELETE_FROM_TABLE, qualifiedName));
            }
        }
        throw new IllegalArgumentException("Unknown operation " + operation);
    }

    private static Privilege buildPrivilege(Action action, List<String> qualifiedName) {
        return Privilege.builder().action(action).selector(Selector.table((String)qualifiedName.get(0), (String)qualifiedName.get(1))).build();
    }
}

