/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum SqlQueryType {
    QUERY,
    DML,
    DDL,
    EXPLAIN,
    TX_CONTROL,
    KILL,
    SHOW,
    COPY,
    RBAC_DDL;

    public static final Set<SqlQueryType> SINGLE_STMT_TYPES;
    public static final Set<SqlQueryType> ALL;

    public boolean supportsParseResultCaching() {
        switch (this) {
            case QUERY: 
            case DML: {
                return true;
            }
            case DDL: 
            case RBAC_DDL: 
            case EXPLAIN: 
            case TX_CONTROL: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsExplain() {
        switch (this) {
            case QUERY: 
            case DML: {
                return true;
            }
            case DDL: 
            case RBAC_DDL: 
            case EXPLAIN: 
            case TX_CONTROL: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsIndependentExecution() {
        switch (this) {
            case QUERY: 
            case DML: 
            case DDL: 
            case RBAC_DDL: 
            case EXPLAIN: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return true;
            }
            case TX_CONTROL: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsTransactions() {
        switch (this) {
            case QUERY: 
            case DML: {
                return true;
            }
            case DDL: 
            case RBAC_DDL: 
            case EXPLAIN: 
            case TX_CONTROL: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsExplicitTransactions() {
        switch (this) {
            case QUERY: 
            case DML: 
            case EXPLAIN: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return true;
            }
            case DDL: 
            case RBAC_DDL: 
            case TX_CONTROL: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean implicitTransactionReadOnlyMode() {
        switch (this) {
            case QUERY: 
            case EXPLAIN: {
                return true;
            }
            case DML: {
                return false;
            }
            case DDL: 
            case RBAC_DDL: 
            case TX_CONTROL: 
            case KILL: 
            case SHOW: 
            case COPY: {
                throw new UnsupportedOperationException(this + " does not support requesting transaction mode.");
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean hasRowSet() {
        switch (this) {
            case QUERY: 
            case EXPLAIN: 
            case SHOW: 
            case COPY: {
                return true;
            }
            case DML: 
            case DDL: 
            case RBAC_DDL: 
            case TX_CONTROL: 
            case KILL: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean returnsAffectedRows() {
        switch (this) {
            case QUERY: 
            case DDL: 
            case RBAC_DDL: 
            case EXPLAIN: 
            case TX_CONTROL: 
            case KILL: 
            case SHOW: 
            case COPY: {
                return false;
            }
            case DML: {
                return true;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsWasApplied() {
        switch (this) {
            case QUERY: 
            case DML: 
            case EXPLAIN: 
            case TX_CONTROL: 
            case SHOW: 
            case COPY: {
                return false;
            }
            case DDL: 
            case RBAC_DDL: 
            case KILL: {
                return true;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public String displayName() {
        switch (this) {
            case QUERY: {
                return "Query";
            }
            case DML: {
                return "DML";
            }
            case DDL: 
            case RBAC_DDL: {
                return "DDL";
            }
            case EXPLAIN: {
                return "Explain";
            }
            case TX_CONTROL: {
                return "Transaction control statement";
            }
            case KILL: {
                return "Kill";
            }
            case SHOW: {
                return "Show";
            }
            case COPY: {
                return "Copy";
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public String toString() {
        if (this == RBAC_DDL) {
            return "DDL";
        }
        return super.toString();
    }

    private static IllegalStateException unexpectedSqlQueryType(SqlQueryType type) {
        return new IllegalStateException("Unexpected query type:" + type);
    }

    static {
        SINGLE_STMT_TYPES = EnumSet.copyOf(Arrays.stream(SqlQueryType.values()).filter(SqlQueryType::supportsIndependentExecution).collect(Collectors.toList()));
        ALL = EnumSet.allOf(SqlQueryType.class);
    }
}

