/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.cache.spring.SpringCacheManager;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

class SpringCache
implements Cache {
    private static final Object NULL = new NullValue();
    private final IgniteCache<Object, Object> cache;
    private final SpringCacheManager mgr;

    SpringCache(IgniteCache<Object, Object> cache, SpringCacheManager mgr) {
        assert (cache != null);
        this.cache = cache;
        this.mgr = mgr;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        Object val = this.cache.get(key);
        return val != null ? SpringCache.fromValue(val) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object val = this.cache.get(key);
        if (NULL.equals(val)) {
            val = null;
        }
        if (val != null && type != null && !type.isInstance(val)) {
            throw new IllegalStateException("Cached value is not of required type [cacheName=" + this.cache.getName() + ", key=" + key + ", val=" + val + ", requiredType=" + type + "]");
        }
        return (T)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valLdr) {
        Object val;
        block6: {
            val = this.cache.get(key);
            if (val == null) {
                IgniteLock lock = this.mgr.getSyncLock(this.cache.getName(), key);
                lock.lock();
                try {
                    val = this.cache.get(key);
                    if (val != null) break block6;
                    try {
                        T retVal = valLdr.call();
                        val = this.wrapNull(retVal);
                        this.cache.put(key, val);
                    }
                    catch (Exception e) {
                        throw new Cache.ValueRetrievalException(key, valLdr, (Throwable)e);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return (T)SpringCache.unwrapNull(val);
    }

    public void put(Object key, Object val) {
        if (val == null) {
            this.cache.withSkipStore().put(key, NULL);
        } else {
            this.cache.put(key, val);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object val) {
        Object old = val == null ? this.cache.withSkipStore().getAndPutIfAbsent(key, NULL) : this.cache.getAndPutIfAbsent(key, val);
        return old != null ? SpringCache.fromValue(old) : null;
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }

    private static Cache.ValueWrapper fromValue(Object val) {
        assert (val != null);
        return new SimpleValueWrapper(SpringCache.unwrapNull(val));
    }

    private static Object unwrapNull(Object val) {
        return NULL.equals(val) ? null : val;
    }

    private <T> Object wrapNull(T val) {
        return val == null ? NULL : val;
    }

    private static class NullValue
    implements Serializable {
        private NullValue() {
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }
    }
}

