/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.eventlog.api.IgniteEventType;
import org.apache.ignite.internal.eventlog.event.EventUser;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.security.authentication.AuthenticationManager;
import org.apache.ignite.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite.internal.security.authentication.AuthenticationUtils;
import org.apache.ignite.internal.security.authentication.Authenticator;
import org.apache.ignite.internal.security.authentication.AuthenticatorFactory;
import org.apache.ignite.internal.security.authentication.UserDetails;
import org.apache.ignite.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticationProviderConfiguration;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationProviderView;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationView;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEvent;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite.internal.security.authentication.event.AuthenticationProviderEventFactory;
import org.apache.ignite.internal.security.authentication.event.SecurityEnabledDisabledEventFactory;
import org.apache.ignite.internal.security.authentication.event.UserEventFactory;
import org.apache.ignite.internal.security.configuration.SecurityConfiguration;
import org.apache.ignite.internal.security.configuration.SecurityView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.security.exception.InvalidCredentialsException;
import org.apache.ignite.security.exception.UnsupportedAuthenticationTypeException;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AuthenticationManagerImpl
extends AbstractEventProducer<AuthenticationEvent, AuthenticationEventParameters>
implements AuthenticationManager {
    private static final IgniteLogger LOG = Loggers.forClass(AuthenticationManagerImpl.class);
    private final SecurityConfiguration securityConfiguration;
    private final ConfigurationListener<SecurityView> securityConfigurationListener;
    private final SecurityEnabledDisabledEventFactory securityEnabledDisabledEventFactory;
    private final UserEventFactory userEventFactory;
    private final AuthenticationProviderEventFactory providerEventFactory;
    private final Executor executor;
    @Nullable
    private volatile List<Authenticator> authenticators;
    private final EventLog eventLog;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private volatile boolean basicAuthLicenseFeatureEnabled = false;

    public AuthenticationManagerImpl(Executor authenticationExecutor, SecurityConfiguration securityConfiguration, LicenseFeatureChecker licenseFeatureChecker, EventLog eventLog) {
        this.securityConfiguration = securityConfiguration;
        this.eventLog = eventLog;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.securityConfigurationListener = ctx -> {
            this.refreshProviders((SecurityView)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        };
        this.securityEnabledDisabledEventFactory = new SecurityEnabledDisabledEventFactory(this::fireEvent);
        this.userEventFactory = new UserEventFactory(this::fireEvent);
        this.providerEventFactory = new AuthenticationProviderEventFactory(securityConfiguration, this.userEventFactory, this::fireEvent);
        this.executor = authenticationExecutor;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.securityConfiguration.listen(this.securityConfigurationListener);
        this.securityConfiguration.enabled().listen((ConfigurationListener)this.securityEnabledDisabledEventFactory);
        this.securityConfiguration.authentication().providers().listenElements((ConfigurationNamedListListener)this.providerEventFactory);
        String basicAuthenticationProviderName = AuthenticationUtils.findBasicProviderName((NamedListView<? extends AuthenticationProviderView>)((NamedListView)this.securityConfiguration.authentication().providers().value()));
        BasicAuthenticationProviderConfiguration basicAuthenticationProviderConfiguration = (BasicAuthenticationProviderConfiguration)this.securityConfiguration.authentication().providers().get(basicAuthenticationProviderName);
        basicAuthenticationProviderConfiguration.users().listenElements((ConfigurationNamedListListener)this.userEventFactory);
        this.refreshProviders((SecurityView)this.securityConfiguration.value());
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.securityConfiguration.stopListen(this.securityConfigurationListener);
        this.securityConfiguration.enabled().stopListen((ConfigurationListener)this.securityEnabledDisabledEventFactory);
        this.securityConfiguration.authentication().providers().stopListenElements((ConfigurationNamedListListener)this.providerEventFactory);
        String basicAuthenticationProviderName = AuthenticationUtils.findBasicProviderName((NamedListView<? extends AuthenticationProviderView>)((NamedListView)this.securityConfiguration.authentication().providers().value()));
        BasicAuthenticationProviderConfiguration basicAuthenticationProviderConfiguration = (BasicAuthenticationProviderConfiguration)this.securityConfiguration.authentication().providers().get(basicAuthenticationProviderName);
        basicAuthenticationProviderConfiguration.users().stopListenElements((ConfigurationNamedListListener)this.userEventFactory);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<UserDetails> authenticateAsync(AuthenticationRequest<?, ?> authenticationRequest) {
        List<Authenticator> providers = this.authenticators;
        if (this.authenticationEnabled(providers)) {
            return this.authenticate(providers.iterator(), authenticationRequest);
        }
        return CompletableFuture.completedFuture(UserDetails.UNKNOWN);
    }

    private CompletableFuture<UserDetails> authenticate(Iterator<Authenticator> iter, AuthenticationRequest<?, ?> authenticationRequest) {
        if (!iter.hasNext()) {
            return CompletableFuture.failedFuture((Throwable)new InvalidCredentialsException("Authentication failed"));
        }
        return this.authenticate(iter.next(), authenticationRequest).thenCompose(userDetails -> {
            if (userDetails != null) {
                return CompletableFuture.completedFuture(userDetails);
            }
            return this.authenticate(iter, authenticationRequest);
        });
    }

    private CompletableFuture<UserDetails> authenticate(Authenticator authenticator, AuthenticationRequest<?, ?> authenticationRequest) {
        try {
            return authenticator.authenticateAsync(authenticationRequest).handle((userDetails, throwable) -> {
                if (throwable != null) {
                    if (!(throwable instanceof InvalidCredentialsException) && !(throwable instanceof UnsupportedAuthenticationTypeException)) {
                        LOG.error("Unexpected exception during authentication", throwable);
                    }
                    this.logAuthenticationFailure(authenticationRequest);
                    return null;
                }
                if (userDetails != null) {
                    this.logUserAuthenticated((UserDetails)userDetails);
                }
                return userDetails;
            });
        }
        catch (Exception e) {
            this.logAuthenticationFailure(authenticationRequest);
            LOG.error("Unexpected exception during authentication", (Throwable)e);
            return CompletableFutures.nullCompletedFuture();
        }
    }

    private void logAuthenticationFailure(AuthenticationRequest<?, ?> authenticationRequest) {
        this.eventLog.log(IgniteEventType.USER_AUTHENTICATION_FAILURE.name(), () -> IgniteEventType.USER_AUTHENTICATION_FAILURE.builder().user(EventUser.system()).timestamp(System.currentTimeMillis()).fields(Map.of("identity", AuthenticationManagerImpl.tryGetUsernameOrUnknown(authenticationRequest))).build());
    }

    private static String tryGetUsernameOrUnknown(AuthenticationRequest<?, ?> authenticationRequest) {
        if (authenticationRequest instanceof UsernamePasswordRequest) {
            return ((UsernamePasswordRequest)authenticationRequest).getIdentity();
        }
        return "UNKNOWN_AUTHENTICATION_TYPE";
    }

    private void logUserAuthenticated(UserDetails userDetails) {
        this.eventLog.log(IgniteEventType.USER_AUTHENTICATION_SUCCESS.name(), () -> IgniteEventType.USER_AUTHENTICATION_SUCCESS.create(EventUser.of((String)userDetails.username(), (String)userDetails.providerName())));
    }

    private void refreshProviders(@Nullable SecurityView view) {
        try {
            this.authenticators = view == null || !view.enabled() ? null : this.providersFromAuthView(view.authentication());
        }
        catch (Exception exception) {
            LOG.error("Couldn't refresh authentication providers. Leaving the old settings", (Throwable)exception);
        }
    }

    private List<Authenticator> providersFromAuthView(AuthenticationView view) {
        NamedListView providers = view.providers();
        return providers.stream().sorted(Comparator.comparing(o -> o.name())).map(providerView -> AuthenticatorFactory.create(providerView, this.licenseFeatureChecker, this.executor)).collect(Collectors.toList());
    }

    private CompletableFuture<Void> fireEvent(AuthenticationEventParameters parameters) {
        return this.fireEvent((Event)parameters.type(), (EventParameters)parameters);
    }

    public boolean authenticationEnabled() {
        return this.authenticationEnabled(this.authenticators);
    }

    private boolean authenticationEnabled(@Nullable List<Authenticator> authenticators) {
        return authenticators != null && this.basicAuthLicenseFeatureEnabled;
    }

    @TestOnly
    public void authenticators(List<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public void enableSecurityFeature(boolean basicAuthEnabled) {
        this.basicAuthLicenseFeatureEnabled = basicAuthEnabled;
    }
}

