/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.basic;

import java.util.Objects;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite.internal.security.authentication.configuration.validator.UserWithSystemRoleValidator;

public class UserWithSystemRoleValidatorImpl
implements Validator<UserWithSystemRoleValidator, NamedListView<? extends BasicUserView>> {
    public static final UserWithSystemRoleValidatorImpl INSTANCE = new UserWithSystemRoleValidatorImpl();

    public void validate(UserWithSystemRoleValidator annotation, ValidationContext<NamedListView<? extends BasicUserView>> ctx) {
        NamedListView newValue = (NamedListView)ctx.getNewValue();
        boolean hasUserWithSystemRole = false;
        for (BasicUserView basicUserView : newValue) {
            String[] roles = basicUserView.roles();
            if (!UserWithSystemRoleValidatorImpl.checkRoles(roles)) continue;
            hasUserWithSystemRole = true;
            break;
        }
        if (!hasUserWithSystemRole) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Removing the last user with a system role `system` is not supported."));
        }
    }

    private static boolean checkRoles(String[] roles) {
        for (String role : roles) {
            if (!Objects.equals(role, "system")) continue;
            return true;
        }
        return false;
    }
}

