/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.basic;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite.internal.security.authentication.basic.UserPasswordEncodingValidator;
import org.gridgain.internal.rbac.password.PasswordEncoder;
import org.gridgain.internal.rbac.password.PasswordEncoderRegistry;
import org.gridgain.internal.rbac.password.PasswordEncoding;
import org.jetbrains.annotations.Nullable;

public class UserPasswordEncodingValidatorImpl
implements Validator<UserPasswordEncodingValidator, NamedListView<? extends BasicUserView>> {
    public static final UserPasswordEncodingValidatorImpl INSTANCE = new UserPasswordEncodingValidatorImpl();
    private static final PasswordEncoderRegistry PASSWORD_ENCODER_REGISTRY = PasswordEncoderRegistry.createDefaultRegistry((Executor)ForkJoinPool.commonPool());

    public void validate(UserPasswordEncodingValidator annotation, ValidationContext<NamedListView<? extends BasicUserView>> ctx) {
        Map newValues = UserPasswordEncodingValidatorImpl.toMap((NamedListView)ctx.getNewValue());
        Map oldValues = UserPasswordEncodingValidatorImpl.toMap((NamedListView)ctx.getOldValue());
        for (Map.Entry entry : newValues.entrySet()) {
            BasicUserView newUserConfiguration = (BasicUserView)entry.getValue();
            BasicUserView oldUserConfiguration = (BasicUserView)oldValues.get(entry.getKey());
            UserPasswordEncodingValidatorImpl.validateUserConfiguration(ctx, newUserConfiguration, oldUserConfiguration);
        }
    }

    private static void validateUserConfiguration(ValidationContext<NamedListView<? extends BasicUserView>> ctx, BasicUserView newUserConfiguration, @Nullable BasicUserView oldUserConfiguration) {
        if (oldUserConfiguration != null) {
            boolean isSameEncoding = Objects.equals(newUserConfiguration.passwordEncoding(), oldUserConfiguration.passwordEncoding());
            boolean isSamePassword = Objects.equals(newUserConfiguration.password(), oldUserConfiguration.password());
            if (isSameEncoding && isSamePassword) {
                return;
            }
            if (isSamePassword) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Changing password encoding without changing the password is not supported."));
            }
        }
        if (!UserPasswordEncodingValidatorImpl.isPasswordLooksLikeEncodedWithSpecificEncoding(newUserConfiguration.password(), newUserConfiguration.passwordEncoding())) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Specified user password is not encoded correctly."));
        }
    }

    private static boolean isPasswordLooksLikeEncodedWithSpecificEncoding(String password, String passwordEncoding) {
        PasswordEncoding encoding = PasswordEncoding.valueOf((String)passwordEncoding.toUpperCase());
        PasswordEncoder passwordEncoder = PASSWORD_ENCODER_REGISTRY.passwordEncoder(encoding);
        return passwordEncoder.isValidFormat(password);
    }

    private static <T> Map<String, T> toMap(@Nullable NamedListView<? extends T> namedListView) {
        if (namedListView == null) {
            return Collections.emptyMap();
        }
        List keys = namedListView.namedListKeys();
        return keys.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> namedListView.get(arg_0)));
    }
}

