/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.basic;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite.internal.security.authentication.Authenticator;
import org.apache.ignite.internal.security.authentication.UserDetails;
import org.apache.ignite.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite.internal.security.authentication.basic.BasicUser;
import org.apache.ignite.security.exception.InvalidCredentialsException;
import org.apache.ignite.security.exception.UnsupportedAuthenticationTypeException;
import org.gridgain.internal.rbac.password.PasswordEncoder;
import org.gridgain.internal.rbac.password.PasswordEncoderRegistry;

public class BasicAuthenticator
implements Authenticator {
    private final PasswordEncoderRegistry passwordEncoderRegistry;
    private final String providerName;
    private final Map<String, BasicUser> users;

    public BasicAuthenticator(String providerName, List<BasicUser> users, Executor executor) {
        this.providerName = providerName;
        this.users = users.stream().collect(Collectors.toMap(user -> user.name().toLowerCase(Locale.US), Function.identity()));
        this.passwordEncoderRegistry = PasswordEncoderRegistry.createDefaultRegistry((Executor)executor);
    }

    public CompletableFuture<UserDetails> authenticateAsync(AuthenticationRequest<?, ?> authenticationRequest) {
        if (!(authenticationRequest instanceof UsernamePasswordRequest)) {
            return CompletableFuture.failedFuture((Throwable)new UnsupportedAuthenticationTypeException("Unsupported authentication type: " + authenticationRequest.getClass().getName()));
        }
        String requestUsername = (String)authenticationRequest.getIdentity();
        String requestPassword = (String)authenticationRequest.getSecret();
        BasicUser basicUser = this.users.get(requestUsername.toLowerCase());
        if (basicUser != null) {
            PasswordEncoder passwordEncoder = this.passwordEncoderRegistry.passwordEncoder(basicUser.passwordEncoding());
            return passwordEncoder.matchAsync(requestPassword, basicUser.password()).thenApply(match -> {
                if (match.booleanValue()) {
                    return new UserDetails(basicUser.displayName(), this.providerName, Set.of(basicUser.roles()));
                }
                throw new InvalidCredentialsException("Invalid credentials");
            });
        }
        return CompletableFuture.failedFuture((Throwable)new InvalidCredentialsException("Invalid credentials"));
    }
}

