/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.security.authentication.Authenticator;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticationProviderView;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticator;
import org.apache.ignite.internal.security.authentication.basic.BasicUser;
import org.apache.ignite.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationProviderView;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.ldap.LdapAuthenticator;
import org.gridgain.internal.security.ldap.client.LdapClient;
import org.gridgain.internal.security.ldap.client.LdapClientImpl;
import org.gridgain.internal.security.ldap.configuration.LdapAuthenticationProviderView;

class AuthenticatorFactory {
    AuthenticatorFactory() {
    }

    static Authenticator create(AuthenticationProviderView view, LicenseFeatureChecker licenseFeatureChecker, Executor executor) {
        if (view instanceof BasicAuthenticationProviderView) {
            BasicAuthenticationProviderView basicAuthProviderView = (BasicAuthenticationProviderView)view;
            List<BasicUser> users = basicAuthProviderView.users().stream().map(AuthenticatorFactory::toBasicUser).collect(Collectors.toList());
            return new BasicAuthenticator(view.name(), users, executor);
        }
        if (view instanceof LdapAuthenticationProviderView) {
            LdapAuthenticationProviderView ldapAuthenticationProviderView = (LdapAuthenticationProviderView)view;
            return new LdapAuthenticator((LdapClient)new LdapClientImpl(ldapAuthenticationProviderView), ldapAuthenticationProviderView, licenseFeatureChecker, executor);
        }
        throw new IllegalArgumentException("Unexpected authentication provider view: " + view);
    }

    private static BasicUser toBasicUser(BasicUserView basicUserView) {
        return new BasicUser(basicUserView.username(), basicUserView.displayName(), basicUserView.password(), basicUserView.passwordEncoding(), basicUserView.roles());
    }
}

