/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.configuration.validator;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.security.authentication.configuration.validator.AuthenticationRolesValidator;
import org.apache.ignite.internal.security.configuration.SecurityExtensionConfiguration;
import org.apache.ignite.internal.security.configuration.SecurityExtensionView;
import org.apache.ignite.internal.security.configuration.SecurityView;
import org.gridgain.internal.rbac.configuration.RoleView;

public class AuthenticationRolesValidatorImpl
implements Validator<AuthenticationRolesValidator, String[]> {
    public static final AuthenticationRolesValidatorImpl INSTANCE = new AuthenticationRolesValidatorImpl();

    public void validate(AuthenticationRolesValidator annotation, ValidationContext<String[]> ctx) {
        SecurityView securityView = ((SecurityExtensionView)ctx.getNewRoot(SecurityExtensionConfiguration.KEY)).security();
        Set authorizationRoles = securityView.authorization().roles().stream().map(RoleView::name).collect(Collectors.toSet());
        for (String role : (String[])ctx.getNewValue()) {
            if (authorizationRoles.contains(role.toLowerCase())) continue;
            String message = "Role \"" + role + "\" is not present in the authorization configuration";
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
    }
}

