/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.events.TableEventParameters;
import org.apache.ignite.internal.causality.IncrementalVersionedValue;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.SchemaUtils;
import org.apache.ignite.internal.schema.catalog.CatalogToSchemaDescriptorConverter;
import org.apache.ignite.internal.schema.registry.SchemaRegistryImpl;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class SchemaManager
implements IgniteComponent {
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final CatalogService catalogService;
    private final IncrementalVersionedValue<Void> registriesVv;
    private final Map<Integer, SchemaRegistryImpl> registriesById = new ConcurrentHashMap<Integer, SchemaRegistryImpl>();

    public SchemaManager(RevisionListenerRegistry registry, CatalogService catalogService) {
        this.registriesVv = new IncrementalVersionedValue("SchemaManager#registries", registry);
        this.catalogService = catalogService;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.catalogService.listen((Event)CatalogEvent.TABLE_CREATE, this::onTableCreated);
        this.catalogService.listen((Event)CatalogEvent.TABLE_ALTER, this::onTableAltered);
        this.registerExistingTables();
        return CompletableFutures.nullCompletedFuture();
    }

    private void registerExistingTables() {
        for (int catalogVer = this.catalogService.latestCatalogVersion(); catalogVer >= this.catalogService.earliestCatalogVersion(); --catalogVer) {
            Collection tables = this.catalogService.catalog(catalogVer).tables();
            for (CatalogTableDescriptor tableDescriptor : tables) {
                int tableId = tableDescriptor.id();
                if (this.registriesById.containsKey(tableId)) continue;
                this.registerVersions(tableDescriptor, null);
            }
        }
    }

    private void registerVersions(CatalogTableDescriptor tableDescriptor, @Nullable SchemaDescriptor lastKnownSchema) {
        int versionToStart;
        SchemaDescriptor prevSchema = lastKnownSchema;
        CatalogTableSchemaVersions schemaVersions = tableDescriptor.schemaVersions();
        for (int tableVer = versionToStart = lastKnownSchema != null ? lastKnownSchema.version() + 1 : schemaVersions.earliestVersion(); tableVer <= schemaVersions.latestVersion(); ++tableVer) {
            SchemaDescriptor newSchema = CatalogToSchemaDescriptorConverter.convert(tableDescriptor, tableVer);
            if (prevSchema != null) {
                newSchema.columnMapping(SchemaUtils.columnMapper(prevSchema, newSchema));
            }
            prevSchema = newSchema;
            this.registerSchema(tableDescriptor.id(), newSchema);
        }
    }

    private CompletableFuture<Boolean> onTableCreated(CatalogEventParameters event) {
        CreateTableEventParameters creationEvent = (CreateTableEventParameters)event;
        return this.onTableCreatedOrAltered(creationEvent.tableDescriptor(), creationEvent.causalityToken());
    }

    private CompletableFuture<Boolean> onTableAltered(CatalogEventParameters event) {
        assert (event instanceof TableEventParameters);
        TableEventParameters tableEvent = (TableEventParameters)event;
        CatalogTableDescriptor tableDescriptor = this.catalogService.catalog(tableEvent.catalogVersion()).table(tableEvent.tableId());
        assert (tableDescriptor != null);
        return this.onTableCreatedOrAltered(tableDescriptor, event.causalityToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> onTableCreatedOrAltered(CatalogTableDescriptor tableDescriptor, long causalityToken) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            int tableId = tableDescriptor.id();
            int newSchemaVersion = tableDescriptor.latestSchemaVersion();
            if (this.searchSchemaByVersion(tableId, newSchemaVersion) != null) {
                CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
                return completableFuture;
            }
            this.registerVersions(tableDescriptor, this.lastKnownSchemaVersion(tableId));
            CompletionStage completionStage = this.registriesVv.update(causalityToken, (registries, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(IgniteStringFormatter.format((String)"Cannot create a schema for the table [tblId={}, ver={}]", (Object[])new Object[]{tableId, newSchemaVersion}), e));
                }
                return CompletableFutures.nullCompletedFuture();
            })).thenApply(ignored -> false);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Nullable
    private SchemaDescriptor loadOptionalSchemaDescriptor(int tblId, int ver) {
        for (int catalogVersion = this.catalogService.latestCatalogVersion(); catalogVersion >= this.catalogService.earliestCatalogVersion(); --catalogVersion) {
            CatalogTableDescriptor tableDescriptor = this.catalogService.catalog(catalogVersion).table(tblId);
            if (tableDescriptor == null) {
                continue;
            }
            return CatalogToSchemaDescriptorConverter.convertIfExists(tableDescriptor, ver);
        }
        throw new AssertionError((Object)IgniteStringFormatter.format((String)"Schema descriptor is not found [tableId={}, schemaId={}]", (Object[])new Object[]{tblId, ver}));
    }

    private void registerSchema(int tableId, SchemaDescriptor schema) {
        this.registriesById.compute(tableId, (tableId0, reg) -> {
            if (reg == null) {
                return this.createSchemaRegistry((int)tableId0, schema);
            }
            reg.onSchemaRegistered(schema);
            return reg;
        });
    }

    private SchemaRegistryImpl createSchemaRegistry(int tableId, SchemaDescriptor initialSchema) {
        return new SchemaRegistryImpl(ver -> (SchemaDescriptor)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.loadOptionalSchemaDescriptor(tableId, ver)), initialSchema);
    }

    @Nullable
    private SchemaDescriptor searchSchemaByVersion(int tblId, int schemaVer) {
        SchemaRegistry registry = this.registriesById.get(tblId);
        if (registry != null && schemaVer <= registry.lastKnownSchemaVersion()) {
            return registry.schema(schemaVer);
        }
        return null;
    }

    @Nullable
    private SchemaDescriptor lastKnownSchemaVersion(int tblId) {
        SchemaRegistry registry = this.registriesById.get(tblId);
        if (registry != null) {
            return registry.lastKnownSchema();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SchemaRegistry> schemaRegistry(long causalityToken, int tableId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.registriesVv.get(causalityToken).thenApply(unused -> (SchemaRegistry)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.registriesById.get(tableId)));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public SchemaRegistry schemaRegistry(int tableId) {
        return this.registriesById.get(tableId);
    }

    public void dropRegistry(int tableId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            SchemaRegistryImpl removedRegistry = this.registriesById.remove(tableId);
            removedRegistry.close();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAllManually(this.registriesById.values());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

