/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.asm;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.marshaller.BinaryMode;

public class ColumnAccessCodeGenerator {
    private final String readMethodName;
    private final String writeMethodName;
    private final Class<?> mappedType;
    private final int colIdx;
    private final String filedName;

    public static ColumnAccessCodeGenerator createAccessor(BinaryMode mode, String fieldName, int colIdx) {
        switch (mode) {
            case P_BOOLEAN: {
                return new ColumnAccessCodeGenerator("booleanValue", "appendBoolean", Boolean.TYPE, fieldName, colIdx);
            }
            case P_BYTE: {
                return new ColumnAccessCodeGenerator("byteValue", "appendByte", Byte.TYPE, fieldName, colIdx);
            }
            case P_SHORT: {
                return new ColumnAccessCodeGenerator("shortValue", "appendShort", Short.TYPE, fieldName, colIdx);
            }
            case P_INT: {
                return new ColumnAccessCodeGenerator("intValue", "appendInt", Integer.TYPE, fieldName, colIdx);
            }
            case P_LONG: {
                return new ColumnAccessCodeGenerator("longValue", "appendLong", Long.TYPE, fieldName, colIdx);
            }
            case P_FLOAT: {
                return new ColumnAccessCodeGenerator("floatValue", "appendFloat", Float.TYPE, fieldName, colIdx);
            }
            case P_DOUBLE: {
                return new ColumnAccessCodeGenerator("doubleValue", "appendDouble", Double.TYPE, fieldName, colIdx);
            }
            case BOOLEAN: {
                return new ColumnAccessCodeGenerator("booleanValueBoxed", "appendBoolean", Boolean.class, fieldName, colIdx);
            }
            case BYTE: {
                return new ColumnAccessCodeGenerator("byteValueBoxed", "appendByte", Byte.class, fieldName, colIdx);
            }
            case SHORT: {
                return new ColumnAccessCodeGenerator("shortValueBoxed", "appendShort", Short.class, fieldName, colIdx);
            }
            case INT: {
                return new ColumnAccessCodeGenerator("intValueBoxed", "appendInt", Integer.class, fieldName, colIdx);
            }
            case LONG: {
                return new ColumnAccessCodeGenerator("longValueBoxed", "appendLong", Long.class, fieldName, colIdx);
            }
            case FLOAT: {
                return new ColumnAccessCodeGenerator("floatValueBoxed", "appendFloat", Float.class, fieldName, colIdx);
            }
            case DOUBLE: {
                return new ColumnAccessCodeGenerator("doubleValueBoxed", "appendDouble", Double.class, fieldName, colIdx);
            }
            case STRING: {
                return new ColumnAccessCodeGenerator("stringValue", "appendString", String.class, fieldName, colIdx);
            }
            case UUID: {
                return new ColumnAccessCodeGenerator("uuidValue", "appendUuid", UUID.class, fieldName, colIdx);
            }
            case BYTE_ARR: {
                return new ColumnAccessCodeGenerator("bytesValue", "appendBytes", byte[].class, fieldName, colIdx);
            }
            case DECIMAL: {
                return new ColumnAccessCodeGenerator("decimalValue", "appendDecimal", BigDecimal.class, fieldName, colIdx);
            }
            case DATE: {
                return new ColumnAccessCodeGenerator("dateValue", "appendDate", LocalDate.class, fieldName, colIdx);
            }
            case TIME: {
                return new ColumnAccessCodeGenerator("timeValue", "appendTime", LocalTime.class, fieldName, colIdx);
            }
            case DATETIME: {
                return new ColumnAccessCodeGenerator("dateTimeValue", "appendDateTime", LocalDateTime.class, fieldName, colIdx);
            }
            case TIMESTAMP: {
                return new ColumnAccessCodeGenerator("timestampValue", "appendTimestamp", Instant.class, fieldName, colIdx);
            }
        }
        throw new IgniteInternalException("Unsupported binary mode: " + mode);
    }

    ColumnAccessCodeGenerator(String readMethodName, String writeMethodName, Class<?> mappedType, String fieldName, int colIdx) {
        this.readMethodName = readMethodName;
        this.writeMethodName = writeMethodName;
        this.colIdx = colIdx;
        this.mappedType = mappedType;
        this.filedName = fieldName;
    }

    public int columnIdx() {
        return this.colIdx;
    }

    public String readMethodName() {
        return this.readMethodName;
    }

    public String writeMethodName() {
        return this.writeMethodName;
    }

    public Class<?> mappedType() {
        return this.mappedType;
    }

    public String fieldName() {
        return this.filedName;
    }
}

