/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.schema.DefaultValueGenerator;
import org.jetbrains.annotations.Nullable;

public interface DefaultValueProvider {
    public static final DefaultValueProvider NULL_PROVIDER = new ConstantValueProvider(null);

    public static DefaultValueProvider forValueGenerator(DefaultValueGenerator gen) {
        return new FunctionalValueProvider(gen, Collections.emptyList());
    }

    public static DefaultValueProvider forValueGenerator(DefaultValueGenerator gen, List<Object> parameters) {
        return new FunctionalValueProvider(gen, parameters);
    }

    public static DefaultValueProvider constantProvider(@Nullable Object val) {
        if (val == null) {
            return NULL_PROVIDER;
        }
        return new ConstantValueProvider(val);
    }

    public Type type();

    public Object get();

    public static class FunctionalValueProvider
    implements DefaultValueProvider {
        private final DefaultValueGenerator gen;
        private final List<Object> parameters;

        private FunctionalValueProvider(DefaultValueGenerator gen, List<Object> parameters) {
            this.gen = gen;
            this.parameters = parameters;
        }

        @Override
        public Type type() {
            return Type.FUNCTIONAL;
        }

        public String name() {
            return this.gen.name();
        }

        @Override
        public Object get() {
            return this.gen.next(this.parameters);
        }

        public List<Object> parameters() {
            return this.parameters;
        }
    }

    public static class ConstantValueProvider
    implements DefaultValueProvider {
        @Nullable
        private final Object value;

        private ConstantValueProvider(@Nullable Object value) {
            this.value = value;
        }

        @Override
        public Type type() {
            return Type.CONSTANT;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    public static enum Type {
        CONSTANT(0),
        FUNCTIONAL(1);

        private final byte id;
        private static final Map<Byte, Type> byId;

        @Nullable
        public static Type byId(byte id) {
            return byId.get(id);
        }

        private Type(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        static {
            byId = Map.of(CONSTANT.id(), CONSTANT, FUNCTIONAL.id(), FUNCTIONAL);
        }
    }
}

