/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.SchemaUtils;
import org.apache.ignite.internal.schema.ValueOutOfBoundsException;

public enum DefaultValueGenerator {
    RAND_UUID("randUuid", UUID.class),
    CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL("currentTimestampWithLocalTimeZonePlusInterval", Instant.class, Long.TYPE, Long.TYPE),
    NEXTVAL("sequenceNextValue", Long.TYPE, String.class, Integer.TYPE);

    private final MethodHandle methodHandle;

    private DefaultValueGenerator(String methodName, MethodType methodType) {
        try {
            this.methodHandle = MethodHandles.lookup().findStatic(DefaultValueGenerator.class, methodName, methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private DefaultValueGenerator(String methodName, Class<?> resultCls) {
        this(methodName, MethodType.methodType(resultCls));
    }

    private DefaultValueGenerator(String methodName, Class<?> resultCls, Class<?> arg1, Class<?> ... args) {
        this(methodName, MethodType.methodType(resultCls, arg1, args));
    }

    public Object next(List<Object> parameters) {
        try {
            if (this.methodHandle.type().parameterCount() == parameters.size()) {
                return this.methodHandle.invokeWithArguments(parameters);
            }
            return this.methodHandle.invoke();
        }
        catch (ValueOutOfBoundsException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static UUID randUuid() {
        return UUID.randomUUID();
    }

    public static Instant currentTimestampWithLocalTimeZonePlusInterval(long timestamp, long intervalMillis) {
        Instant value = Instant.ofEpochMilli(timestamp + intervalMillis);
        DefaultValueGenerator.checkTimestampBounds(value);
        return value;
    }

    private static void checkTimestampBounds(Instant value) {
        Instant min = SchemaUtils.TIMESTAMP_MIN;
        Instant max = SchemaUtils.TIMESTAMP_MAX;
        if (min.compareTo(value) > 0 || max.compareTo(value) < 0) {
            throw new ValueOutOfBoundsException(IgniteStringFormatter.format((String)"Default value is out of allowed range (value='{}', min='{}', max='{}').", (Object[])new Object[]{value, min, max}));
        }
    }

    static long sequenceNextValue(String name, int sequenceId) {
        throw new IllegalStateException("shouldn't be thrown");
    }
}

