/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.mapping;

import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapperImpl;

public class ColumnMapping {
    private static final IdentityMapper IDENTITY_MAPPER = new IdentityMapper();

    public static ColumnMapper identityMapping() {
        return IDENTITY_MAPPER;
    }

    public static ColumnMapper createMapper(SchemaDescriptor schema) {
        return new ColumnMapperImpl(schema);
    }

    public static ColumnMapper mergeMapping(ColumnMapper mapping, SchemaDescriptor schema) {
        ColumnMapperImpl newMapper = new ColumnMapperImpl(schema);
        ColumnMapper schemaMapper = schema.columnMapping();
        for (int i = 0; i < schema.length(); ++i) {
            int idx = schemaMapper.map(i);
            if (idx < 0) {
                newMapper.add(schema.column(i));
                continue;
            }
            newMapper.add0(i, mapping.map(idx), mapping.mappedColumn(idx));
        }
        return newMapper;
    }

    private ColumnMapping() {
    }

    private static class IdentityMapper
    implements ColumnMapper {
        private IdentityMapper() {
        }

        @Override
        public ColumnMapper add(Column col) {
            throw new IllegalStateException("Immutable identity column mapper.");
        }

        @Override
        public ColumnMapper add(int from, int to) {
            throw new IllegalStateException("Immutable identity column mapper.");
        }

        @Override
        public int map(int idx) {
            return idx;
        }

        @Override
        public Column mappedColumn(int idx) {
            return null;
        }
    }
}

