/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.DefaultValueGenerator;
import org.apache.ignite.internal.schema.DefaultValueProvider;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public final class CatalogToSchemaDescriptorConverter {
    private static final Map<String, NativeType> FIX_SIZED_TYPES;

    public static NativeType convertType(CatalogTableColumnDescriptor columnDescriptor) {
        String typeName = columnDescriptor.type().name();
        NativeType res = FIX_SIZED_TYPES.get(typeName);
        if (res != null) {
            return res;
        }
        switch (typeName) {
            case "STRING": {
                int strLen = columnDescriptor.length();
                return NativeTypes.stringOf((int)strLen);
            }
            case "BYTE_ARRAY": {
                int blobLen = columnDescriptor.length();
                return NativeTypes.blobOf((int)blobLen);
            }
            case "DECIMAL": {
                int prec = columnDescriptor.precision();
                int scale = columnDescriptor.scale();
                return NativeTypes.decimalOf((int)prec, (int)scale);
            }
            case "TIME": {
                return NativeTypes.time((int)columnDescriptor.precision());
            }
            case "DATETIME": {
                return NativeTypes.datetime((int)columnDescriptor.precision());
            }
            case "TIMESTAMP": {
                return NativeTypes.timestamp((int)columnDescriptor.precision());
            }
        }
        throw new IllegalArgumentException("Unknown type " + typeName);
    }

    public static Column convert(CatalogTableColumnDescriptor columnDescriptor) {
        DefaultValueProvider defaultValueProvider;
        NativeType type = CatalogToSchemaDescriptorConverter.convertType(columnDescriptor);
        DefaultValue defaultValue = columnDescriptor.defaultValue();
        Object computedDefaultValue = null;
        if (defaultValue == null) {
            defaultValueProvider = DefaultValueProvider.NULL_PROVIDER;
        } else if (defaultValue.type() == DefaultValue.Type.CONSTANT) {
            DefaultValue.ConstantValue constantValue = (DefaultValue.ConstantValue)defaultValue;
            defaultValueProvider = DefaultValueProvider.constantProvider(constantValue.value());
        } else if (defaultValue.type() == DefaultValue.Type.FUNCTION_CALL) {
            DefaultValue.FunctionCall functionCall = (DefaultValue.FunctionCall)defaultValue;
            computedDefaultValue = functionCall.computedValue();
            defaultValueProvider = DefaultValueProvider.forValueGenerator(DefaultValueGenerator.valueOf(functionCall.functionName()), functionCall.parameters());
        } else {
            throw new IllegalStateException("Unknown value supplier class " + defaultValue.getClass().getName());
        }
        return new Column(columnDescriptor.name(), type, columnDescriptor.nullable(), defaultValueProvider, computedDefaultValue);
    }

    public static SchemaDescriptor convert(CatalogTableDescriptor tableDescriptor, int tableVersion) {
        SchemaDescriptor descriptorOrNull = CatalogToSchemaDescriptorConverter.convertIfExists(tableDescriptor, tableVersion);
        assert (descriptorOrNull != null) : IgniteStringFormatter.format((String)"Cannot find table version {} in table descriptor {}", (Object[])new Object[]{tableVersion, tableDescriptor});
        return descriptorOrNull;
    }

    @Nullable
    public static SchemaDescriptor convertIfExists(CatalogTableDescriptor tableDescriptor, int tableVersion) {
        ArrayList<Column> columns = new ArrayList<Column>(tableDescriptor.columns().size());
        CatalogTableSchemaVersions.TableVersion tableVersionInstance = tableDescriptor.schemaVersions().get(tableVersion);
        if (tableVersionInstance == null) {
            return null;
        }
        for (CatalogTableColumnDescriptor column : tableVersionInstance.columns()) {
            columns.add(CatalogToSchemaDescriptorConverter.convert(column));
        }
        return new SchemaDescriptor(tableVersion, columns, tableDescriptor.primaryKeyColumns(), tableDescriptor.colocationColumns(), tableDescriptor.writeMode());
    }

    private CatalogToSchemaDescriptorConverter() {
    }

    static {
        List types = IgniteUtils.collectStaticFields(NativeTypes.class, NativeType.class);
        HashMap<String, NativeType> tmp = new HashMap<String, NativeType>(types.size(), 1.0f);
        for (NativeType type : types) {
            if (!type.fixedLength()) continue;
            tmp.put(type.spec().name(), type);
        }
        FIX_SIZED_TYPES = Map.copyOf(tmp);
    }
}

