/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleFormatException;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class BinaryTupleSchema {
    private final Element[] elements;

    private BinaryTupleSchema(Element[] elements) {
        this.elements = elements;
    }

    public static BinaryTupleSchema create(Element[] elements) {
        return new BinaryTupleSchema((Element[])elements.clone());
    }

    public static BinaryTupleSchema createRowSchema(SchemaDescriptor descriptor) {
        return BinaryTupleSchema.createSchema(descriptor, 0, descriptor.length());
    }

    public static BinaryTupleSchema createKeySchema(SchemaDescriptor descriptor) {
        List<Column> columns = descriptor.keyColumns();
        Element[] elements = new Element[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            elements[i] = new Element(column.type(), column.nullable());
        }
        return new DenseRowSchema(elements, 0, true);
    }

    public static BinaryTupleSchema createDestinationKeySchema(SchemaDescriptor descriptor) {
        List<Column> columns = descriptor.keyColumns();
        Element[] elements = new Element[columns.size()];
        int[] positions = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            elements[i] = new Element(column.type(), column.nullable());
            positions[i] = column.positionInRow();
        }
        return new SparseRowSchema(elements, positions);
    }

    public static BinaryTupleSchema createValueSchema(SchemaDescriptor descriptor) {
        return BinaryTupleSchema.createSchema(descriptor, descriptor.keyColumns().size(), descriptor.length());
    }

    private static BinaryTupleSchema createSchema(SchemaDescriptor descriptor, int colBegin, int colEnd) {
        int numCols = colEnd - colBegin;
        Element[] elements = new Element[numCols];
        for (int i = 0; i < numCols; ++i) {
            Column column = descriptor.column(colBegin + i);
            elements[i] = new Element(column.type(), column.nullable());
        }
        boolean fullSize = colBegin == 0 && (colEnd == descriptor.length() || colEnd == descriptor.keyColumns().size());
        return new DenseRowSchema(elements, colBegin, fullSize);
    }

    public static BinaryTupleSchema createSchema(SchemaDescriptor descriptor, int[] columns) {
        Element[] elements = new Element[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column column = descriptor.column(columns[i]);
            elements[i] = new Element(column.type(), column.nullable());
        }
        return new SparseRowSchema(elements, (int[])columns.clone());
    }

    public int elementCount() {
        return this.elements.length;
    }

    public Element element(int index) {
        return this.elements[index];
    }

    public int columnIndex(int index) {
        return -1;
    }

    public boolean convertible() {
        return false;
    }

    @Nullable
    public BigDecimal decimalValue(BinaryTupleReader tuple, int index) {
        return tuple.decimalValue(index, this.element((int)index).decimalScale);
    }

    public Object value(InternalTuple tuple, int index) {
        Element element = this.element(index);
        switch (element.typeSpec) {
            case BOOLEAN: {
                return tuple.booleanValueBoxed(index);
            }
            case INT8: {
                return tuple.byteValueBoxed(index);
            }
            case INT16: {
                return tuple.shortValueBoxed(index);
            }
            case INT32: {
                return tuple.intValueBoxed(index);
            }
            case INT64: {
                return tuple.longValueBoxed(index);
            }
            case FLOAT: {
                return tuple.floatValueBoxed(index);
            }
            case DOUBLE: {
                return tuple.doubleValueBoxed(index);
            }
            case DECIMAL: {
                return tuple.decimalValue(index, element.decimalScale);
            }
            case UUID: {
                return tuple.uuidValue(index);
            }
            case STRING: {
                return tuple.stringValue(index);
            }
            case BYTE_ARRAY: {
                return tuple.bytesValue(index);
            }
            case DATE: {
                return tuple.dateValue(index);
            }
            case TIME: {
                return tuple.timeValue(index);
            }
            case DATETIME: {
                return tuple.dateTimeValue(index);
            }
            case TIMESTAMP: {
                return tuple.timestampValue(index);
            }
        }
        throw new InvalidTypeException("Unknown element type: " + element.typeSpec);
    }

    public BinaryTupleBuilder appendValue(BinaryTupleBuilder builder, int index, @Nullable Object value) {
        Element element = this.element(index);
        if (value == null) {
            if (!element.nullable()) {
                throw new BinaryTupleFormatException("NULL value for non-nullable column in binary tuple builder.");
            }
            return builder.appendNull();
        }
        switch (element.typeSpec()) {
            case BOOLEAN: {
                return builder.appendBoolean(((Boolean)value).booleanValue());
            }
            case INT8: {
                return builder.appendByte(((Byte)value).byteValue());
            }
            case INT16: {
                return builder.appendShort(((Short)value).shortValue());
            }
            case INT32: {
                return builder.appendInt(((Integer)value).intValue());
            }
            case INT64: {
                return builder.appendLong(((Long)value).longValue());
            }
            case FLOAT: {
                return builder.appendFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return builder.appendDouble(((Double)value).doubleValue());
            }
            case DECIMAL: {
                return builder.appendDecimalNotNull((BigDecimal)value, element.decimalScale());
            }
            case UUID: {
                return builder.appendUuidNotNull((UUID)value);
            }
            case BYTE_ARRAY: {
                return builder.appendBytesNotNull((byte[])value);
            }
            case STRING: {
                return builder.appendStringNotNull((String)value);
            }
            case DATE: {
                return builder.appendDateNotNull((LocalDate)value);
            }
            case TIME: {
                return builder.appendTimeNotNull((LocalTime)value);
            }
            case DATETIME: {
                return builder.appendDateTimeNotNull((LocalDateTime)value);
            }
            case TIMESTAMP: {
                return builder.appendTimestampNotNull((Instant)value);
            }
        }
        throw new InvalidTypeException("Unknown element type: " + element.typeSpec);
    }

    public static final class Element {
        final ColumnType typeSpec;
        final int decimalScale;
        final boolean nullable;

        public Element(NativeType type, boolean nullable) {
            this.typeSpec = type.spec();
            if (this.typeSpec == ColumnType.DECIMAL) {
                DecimalNativeType decimalType = (DecimalNativeType)type;
                this.decimalScale = decimalType.scale();
            } else {
                this.decimalScale = 0;
            }
            this.nullable = nullable;
        }

        public ColumnType typeSpec() {
            return this.typeSpec;
        }

        public int decimalScale() {
            return this.decimalScale;
        }

        public boolean nullable() {
            return this.nullable;
        }
    }

    private static final class DenseRowSchema
    extends BinaryTupleSchema {
        int columnBase;
        boolean fullSize;

        private DenseRowSchema(Element[] elements, int columnBase, boolean fullSize) {
            super(elements);
            this.columnBase = columnBase;
            this.fullSize = fullSize;
        }

        @Override
        public int columnIndex(int index) {
            return index + this.columnBase;
        }

        @Override
        public boolean convertible() {
            return this.fullSize;
        }
    }

    private static final class SparseRowSchema
    extends BinaryTupleSchema {
        int[] columns;

        private SparseRowSchema(Element[] elements, int[] columns) {
            super(elements);
            this.columns = columns;
        }

        @Override
        public int columnIndex(int index) {
            return this.columns[index];
        }
    }
}

