/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.registry;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.BinaryRowConverter;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaException;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class UpgradingRowAdapter
implements Row {
    private final ColumnMapper mapper;
    private final SchemaDescriptor newSchema;
    private final BinaryTupleSchema newBinaryTupleSchema;
    private final Row row;

    private UpgradingRowAdapter(SchemaDescriptor newSchema, BinaryTupleSchema newBinaryTupleSchema, Row row, ColumnMapper mapper) {
        this.row = row;
        this.newSchema = newSchema;
        this.mapper = mapper;
        this.newBinaryTupleSchema = newBinaryTupleSchema;
    }

    public static UpgradingRowAdapter upgradeRow(SchemaDescriptor newSchema, ColumnMapper mapper, Row row) {
        return new UpgradingRowAdapter(newSchema, BinaryTupleSchema.createRowSchema(newSchema), row, mapper);
    }

    public static UpgradingRowAdapter upgradeKeyOnlyRow(SchemaDescriptor newSchema, ColumnMapper mapper, Row row) {
        return new UpgradingRowAdapter(newSchema, BinaryTupleSchema.createKeySchema(newSchema), row, mapper);
    }

    @Override
    public SchemaDescriptor schema() {
        return this.newSchema;
    }

    @Override
    public int schemaVersion() {
        return this.newSchema.version();
    }

    @Override
    public boolean keyOnly() {
        return false;
    }

    private int mapColumn(int colIdx) throws InvalidTypeException {
        return this.mapper.map(colIdx);
    }

    @Override
    public Object value(int colIdx) {
        int mappedId = this.mapColumn(colIdx);
        return mappedId < 0 ? this.mapper.mappedColumn(colIdx).defaultValueForUpgrade() : this.newBinaryTupleSchema.value(this, colIdx);
    }

    public boolean booleanValue(int colIdx) {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.BOOLEAN != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Boolean)column.defaultValueForUpgrade()).booleanValue() : this.row.booleanValue(mappedId);
    }

    public Boolean booleanValueBoxed(int colIdx) {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.BOOLEAN != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Boolean)column.defaultValueForUpgrade() : this.row.booleanValueBoxed(mappedId);
    }

    public byte byteValue(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT8);
        return mappedId < 0 ? ((Byte)column.defaultValueForUpgrade()).byteValue() : this.row.byteValue(mappedId);
    }

    public Byte byteValueBoxed(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT8);
        return mappedId < 0 ? (Byte)column.defaultValueForUpgrade() : this.row.byteValueBoxed(mappedId);
    }

    public short shortValue(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT16);
        return mappedId < 0 ? ((Short)column.defaultValueForUpgrade()).shortValue() : this.row.shortValue(mappedId);
    }

    public Short shortValueBoxed(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT16);
        return mappedId < 0 ? (Short)column.defaultValueForUpgrade() : this.row.shortValueBoxed(mappedId);
    }

    public int intValue(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT32);
        return mappedId < 0 ? ((Integer)column.defaultValueForUpgrade()).intValue() : this.row.intValue(mappedId);
    }

    public Integer intValueBoxed(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT32);
        return mappedId < 0 ? (Integer)column.defaultValueForUpgrade() : this.row.intValueBoxed(mappedId);
    }

    public long longValue(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT64);
        return mappedId < 0 ? ((Long)column.defaultValueForUpgrade()).longValue() : this.row.longValue(mappedId);
    }

    public Long longValueBoxed(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.INT64);
        return mappedId < 0 ? (Long)column.defaultValueForUpgrade() : this.row.longValueBoxed(mappedId);
    }

    public float floatValue(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.FLOAT);
        return mappedId < 0 ? ((Float)column.defaultValueForUpgrade()).floatValue() : this.row.floatValue(mappedId);
    }

    public Float floatValueBoxed(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.FLOAT);
        return mappedId < 0 ? (Float)column.defaultValueForUpgrade() : this.row.floatValueBoxed(mappedId);
    }

    public double doubleValue(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.DOUBLE);
        return mappedId < 0 ? ((Double)column.defaultValueForUpgrade()).doubleValue() : this.row.doubleValue(mappedId);
    }

    public Double doubleValueBoxed(int colIdx) throws InvalidTypeException {
        int mappedId = this.mapColumn(colIdx);
        Column column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        UpgradingRowAdapter.ensureTypeConversionAllowed(column.type().spec(), ColumnType.DOUBLE);
        return mappedId < 0 ? (Double)column.defaultValueForUpgrade() : this.row.doubleValueBoxed(mappedId);
    }

    @Override
    public BigDecimal decimalValue(int colIdx) {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.DECIMAL != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (BigDecimal)column.defaultValueForUpgrade() : this.row.decimalValue(mappedId);
    }

    public BigDecimal decimalValue(int colIdx, int scale) {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.DECIMAL != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (BigDecimal)column.defaultValueForUpgrade() : this.row.decimalValue(mappedId, scale);
    }

    public String stringValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.STRING != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (String)column.defaultValueForUpgrade() : this.row.stringValue(mappedId);
    }

    public byte[] bytesValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.BYTE_ARRAY != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (byte[])column.defaultValueForUpgrade() : this.row.bytesValue(mappedId);
    }

    public UUID uuidValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.UUID != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (UUID)column.defaultValueForUpgrade() : this.row.uuidValue(mappedId);
    }

    public LocalDate dateValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.DATE != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (LocalDate)column.defaultValueForUpgrade() : this.row.dateValue(mappedId);
    }

    public LocalTime timeValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.TIME != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (LocalTime)column.defaultValueForUpgrade() : this.row.timeValue(mappedId);
    }

    public LocalDateTime dateTimeValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.DATETIME != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (LocalDateTime)column.defaultValueForUpgrade() : this.row.dateTimeValue(mappedId);
    }

    public Instant timestampValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.TIMESTAMP != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Instant)column.defaultValueForUpgrade() : this.row.timestampValue(mappedId);
    }

    public Period periodValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.PERIOD != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Period)column.defaultValueForUpgrade() : this.row.periodValue(mappedId);
    }

    public Duration durationValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : this.row.schema().column(mappedId);
        if (ColumnType.DURATION != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Duration)column.defaultValueForUpgrade() : this.row.durationValue(mappedId);
    }

    public boolean hasNullValue(int colIdx) {
        int mappedId = this.mapColumn(colIdx);
        return mappedId < 0 ? this.mapper.mappedColumn(colIdx).defaultValueProvider().get() == null : this.row.hasNullValue(mappedId);
    }

    @Override
    public int colocationHash() {
        return this.row.colocationHash();
    }

    public int size() {
        return this.row.size();
    }

    public int elementCount() {
        return this.newBinaryTupleSchema.elementCount();
    }

    @Nullable
    public BinaryTuple binaryTuple() {
        return null;
    }

    public ByteBuffer byteBuffer() {
        int size = this.newBinaryTupleSchema.elementCount();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(size);
        for (int col = 0; col < size; ++col) {
            this.copyValue(builder, col);
        }
        return new BinaryTuple(size, builder.build()).byteBuffer();
    }

    @Override
    public void copyValue(BinaryTupleBuilder builder, int colIdx) {
        int mappedId = this.mapColumn(colIdx);
        if (mappedId < 0) {
            Column column = this.mapper.mappedColumn(colIdx);
            BinaryRowConverter.appendValue(builder, this.newBinaryTupleSchema.element(colIdx), column.defaultValueForUpgrade());
        } else {
            this.row.copyValue(builder, mappedId);
        }
    }

    @Override
    public int tupleSliceLength() {
        throw new UnsupportedOperationException("Underlying binary can't be accessed directly.");
    }

    @Override
    public ByteBuffer tupleSlice() {
        throw new UnsupportedOperationException("Underlying binary can't be accessed directly.");
    }

    private static void ensureTypeConversionAllowed(ColumnType from, ColumnType to) throws InvalidTypeException {
        if (!CatalogUtils.isSupportedColumnTypeChange((ColumnType)from, (ColumnType)to)) {
            throw new SchemaException(IgniteStringFormatter.format((String)"Type conversion is not allowed: {} -> {}", (Object[])new Object[]{from, to}));
        }
    }
}

