/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleComparatorUtils;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.UnsafeByteBufferAccessor;
import org.apache.ignite.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

public class BinaryTupleComparator
implements Comparator<ByteBuffer> {
    private final List<CatalogColumnCollation> columnCollations;
    private final List<@Nullable NativeType> columnTypes;
    private final int numElements;

    public BinaryTupleComparator(List<CatalogColumnCollation> columnCollations, List<NativeType> columnTypes) {
        this(columnCollations, columnTypes, columnTypes.size());
    }

    protected BinaryTupleComparator(List<CatalogColumnCollation> columnCollations, List<@Nullable NativeType> columnTypes, int numElements) {
        assert (columnCollations.size() <= numElements);
        this.columnCollations = columnCollations;
        this.columnTypes = columnTypes;
        this.numElements = numElements;
    }

    @Override
    public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
        int columnsToCompare;
        assert (buffer1.order() == ByteOrder.LITTLE_ENDIAN);
        assert (buffer2.order() == ByteOrder.LITTLE_ENDIAN);
        boolean isBuffer1Prefix = BinaryTupleComparatorUtils.isFlagSet(buffer1, 8);
        boolean isBuffer2Prefix = BinaryTupleComparatorUtils.isFlagSet(buffer2, 8);
        BinaryTupleReader tuple1 = isBuffer1Prefix ? new BinaryTuplePrefix(this.numElements, buffer1) : new BinaryTuple(this.numElements, buffer1, UnsafeByteBufferAccessor::new);
        BinaryTupleReader tuple2 = isBuffer2Prefix ? new BinaryTuplePrefix(this.numElements, buffer2) : new BinaryTuple(this.numElements, buffer2, UnsafeByteBufferAccessor::new);
        int n = columnsToCompare = isBuffer1Prefix || isBuffer2Prefix ? Math.min(tuple1.elementCount(), tuple2.elementCount()) : this.columnCollations.size();
        assert (columnsToCompare <= this.columnCollations.size());
        for (int i = 0; i < columnsToCompare; ++i) {
            int res = this.compareField(i, tuple1, tuple2);
            if (res == 0) continue;
            return res;
        }
        if (isBuffer1Prefix == isBuffer2Prefix) {
            return 0;
        }
        if (isBuffer1Prefix) {
            return BinaryTupleComparatorUtils.equalityFlag(buffer1);
        }
        return -BinaryTupleComparatorUtils.equalityFlag(buffer2);
    }

    protected int compareField(int colIdx, BinaryTupleReader tuple1, BinaryTupleReader tuple2) {
        return this.compareField(colIdx, tuple1, tuple2, colIdx);
    }

    protected int compareField(int colIdx, BinaryTupleReader tuple1, BinaryTupleReader tuple2, int mappedIdx) {
        CatalogColumnCollation collation = this.columnCollations.get(colIdx);
        boolean tuple1HasNull = tuple1.hasNullValue(mappedIdx);
        boolean tuple2HasNull = tuple2.hasNullValue(mappedIdx);
        if (tuple1HasNull && tuple2HasNull) {
            return 0;
        }
        if (tuple1HasNull || tuple2HasNull) {
            return collation.nullsFirst() == tuple1HasNull ? -1 : 1;
        }
        NativeType nativeType = this.columnTypes.get(colIdx);
        assert (nativeType != null) : "Column of NullType must not have a value.";
        int res = BinaryTupleComparatorUtils.compareFieldValue(nativeType.spec(), tuple1, tuple2, mappedIdx);
        return collation.asc() ? res : -res;
    }
}

