/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.internal.marshaller.ValidationUtils;
import org.apache.ignite.internal.schema.marshaller.asm.ColumnAccessCodeGenerator;
import org.apache.ignite.internal.schema.marshaller.asm.MarshallerCodeGenerator;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.table.mapper.PojoMapper;

class ObjectMarshallerCodeGenerator
implements MarshallerCodeGenerator {
    private final Class<?> targetClass;
    private final MarshallerColumn[] columns;
    private final ColumnAccessCodeGenerator[] columnAccessors;

    ObjectMarshallerCodeGenerator(MarshallerColumn[] marshallerColumns, PojoMapper<?> mapper, int firstColIdx) {
        Field field;
        this.columns = marshallerColumns;
        this.targetClass = mapper.targetType();
        this.columnAccessors = new ColumnAccessCodeGenerator[this.columns.length];
        HashMap<String, Field> flds = new HashMap<String, Field>();
        for (String fldName : mapper.fields()) {
            try {
                field = mapper.targetType().getDeclaredField(fldName);
                flds.put(fldName.toUpperCase(), field);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("Field " + fldName + " is returned from mapper of type " + mapper.getClass().getName() + ", but is not present in target class " + mapper.targetType().getName(), e);
            }
        }
        if (flds.size() > this.columns.length) {
            for (MarshallerColumn col : this.columns) {
                flds.remove(col.name());
            }
            List fldNames = flds.values().stream().map(Field::getName).sorted().collect(Collectors.toList());
            throw new IllegalArgumentException("Fields " + fldNames + " of type " + this.targetClass.getName() + " are not mapped to columns");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            MarshallerColumn column = this.columns[i];
            field = (Field)flds.get(column.name());
            if (field == null) {
                throw new IllegalArgumentException("No field found for column " + column.name());
            }
            ValidationUtils.validateColumnType((MarshallerColumn)column, field.getType());
            this.columnAccessors[i] = ColumnAccessCodeGenerator.createAccessor(BinaryMode.forClass(field.getType()), field.getName(), i + firstColIdx);
        }
    }

    @Override
    public BytecodeNode getValue(ParameterizedType marshallerClass, Variable obj, int i) {
        ColumnAccessCodeGenerator columnAccessor = this.columnAccessors[i];
        return BytecodeExpressions.getStatic((ParameterizedType)marshallerClass, (String)("FIELD_HANDLER_" + columnAccessor.columnIdx()), (ParameterizedType)ParameterizedType.type(VarHandle.class)).invoke("get", Object.class, new BytecodeExpression[]{obj});
    }

    public BytecodeBlock marshallObject(ParameterizedType marshallerClass, Variable asm, Variable obj) {
        BytecodeBlock block = new BytecodeBlock();
        for (int i = 0; i < this.columns.length; ++i) {
            ColumnAccessCodeGenerator columnAccessor = this.columnAccessors[i];
            BytecodeExpression fld = BytecodeExpressions.getStatic((ParameterizedType)marshallerClass, (String)("FIELD_HANDLER_" + columnAccessor.columnIdx()), (ParameterizedType)ParameterizedType.type(VarHandle.class)).invoke("get", columnAccessor.mappedType(), new BytecodeExpression[]{obj});
            block.append((BytecodeNode)asm.invoke(columnAccessor.writeMethodName(), RowAssembler.class, Collections.singletonList(columnAccessor.mappedType()), new BytecodeExpression[]{fld.cast(columnAccessor.mappedType())}));
        }
        return block;
    }

    public BytecodeBlock unmarshallObject(ParameterizedType marshallerClass, Variable row, Variable objVar, Variable objFactory) {
        BytecodeBlock block = new BytecodeBlock();
        block.append((BytecodeNode)objVar.set(objFactory.invoke("create", Object.class, new BytecodeExpression[0])));
        for (int i = 0; i < this.columns.length; ++i) {
            ColumnAccessCodeGenerator columnAccessor = this.columnAccessors[i];
            BytecodeExpression val = row.invoke(columnAccessor.readMethodName(), columnAccessor.mappedType(), new BytecodeExpression[]{BytecodeExpressions.constantInt((int)columnAccessor.columnIdx())});
            block.append((BytecodeNode)BytecodeExpressions.getStatic((ParameterizedType)marshallerClass, (String)("FIELD_HANDLER_" + columnAccessor.columnIdx()), (ParameterizedType)ParameterizedType.type(VarHandle.class)).invoke("set", Void.TYPE, new BytecodeExpression[]{objVar, val}));
        }
        return block;
    }

    @Override
    public void initStaticHandlers(ClassDefinition classDef) {
        MethodDefinition init = classDef.getClassInitializer();
        Variable lookup = init.getScope().createTempVariable(MethodHandles.Lookup.class);
        Variable targetClassVar = init.getScope().createTempVariable(Class.class);
        BytecodeBlock body = init.getBody().append((BytecodeNode)targetClassVar.set(BytecodeExpressions.invokeStatic(Class.class, (String)"forName", Class.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)this.targetClass.getName())})));
        body.append((BytecodeNode)lookup.set(BytecodeExpressions.invokeStatic(MethodHandles.class, (String)"privateLookupIn", MethodHandles.Lookup.class, (BytecodeExpression[])new BytecodeExpression[]{targetClassVar, BytecodeExpressions.invokeStatic(MethodHandles.class, (String)"lookup", MethodHandles.Lookup.class, (BytecodeExpression[])new BytecodeExpression[0])})));
        for (int i = 0; i < this.columnAccessors.length; ++i) {
            FieldDefinition fld = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.FINAL), "FIELD_HANDLER_" + this.columnAccessors[i].columnIdx(), VarHandle.class);
            body.append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)fld, (BytecodeExpression)lookup.invoke("findVarHandle", VarHandle.class, new BytecodeExpression[]{targetClassVar, BytecodeExpressions.constantString((String)this.columnAccessors[i].fieldName()), BytecodeExpressions.constantClass(this.columnAccessors[i].mappedType())})));
        }
    }
}

