/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.DefaultValueProvider;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.SchemaMismatchException;
import org.apache.ignite.internal.schema.SchemaUtils;
import org.apache.ignite.internal.schema.ValueOutOfBoundsException;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class Column {
    private static final DefaultValueProvider NULL_SUPPLIER = DefaultValueProvider.constantProvider(null);
    private final int rowPosition;
    private final int keyPosition;
    private final int valuePosition;
    private final int colocationPosition;
    private final String name;
    private final NativeType type;
    private final boolean nullable;
    @IgniteToStringExclude
    private final DefaultValueProvider defaultValueProvider;
    @Nullable
    private final Object computedDefaultValue;

    public Column(String name, NativeType type, boolean nullable) {
        this(-1, -1, -1, -1, name, type, nullable, NULL_SUPPLIER, null);
    }

    public Column(String name, NativeType type, boolean nullable, DefaultValueProvider defaultValueProvider) {
        this(-1, -1, -1, -1, name, type, nullable, defaultValueProvider, null);
    }

    public Column(String name, NativeType type, boolean nullable, DefaultValueProvider defaultValueProvider, @Nullable Object computedDefaultValue) {
        this(-1, -1, -1, -1, name, type, nullable, defaultValueProvider, computedDefaultValue);
    }

    private Column(int rowPosition, int keyPosition, int valuePosition, int colocationPosition, String name, NativeType type, boolean nullable, DefaultValueProvider defaultValueProvider, @Nullable Object computedDefaultValue) {
        this.rowPosition = rowPosition;
        this.keyPosition = keyPosition;
        this.valuePosition = valuePosition;
        this.colocationPosition = colocationPosition;
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.defaultValueProvider = defaultValueProvider;
        this.computedDefaultValue = computedDefaultValue;
    }

    public int positionInRow() {
        return this.rowPosition;
    }

    public int positionInKey() {
        return this.keyPosition;
    }

    public int positionInValue() {
        return this.valuePosition;
    }

    public int positionInColocation() {
        return this.colocationPosition;
    }

    public String name() {
        return this.name;
    }

    public NativeType type() {
        return this.type;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public DefaultValueProvider defaultValueProvider() {
        return this.defaultValueProvider;
    }

    @Nullable
    public Object defaultValueForUpgrade() {
        if (this.computedDefaultValue != null) {
            return this.computedDefaultValue;
        }
        return this.defaultValueForInsert();
    }

    public Object defaultValueForInsert() {
        return this.defaultValueProvider.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column col = (Column)o;
        return this.name.equals(col.name) && this.type.equals((Object)col.type);
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * this.type.hashCode();
    }

    public void validate(@Nullable Object val) {
        if (val == null) {
            if (this.nullable) {
                return;
            }
            throw new SchemaMismatchException(Column.nullConstraintViolationMessage(this.name));
        }
        NativeType objType = NativeTypes.fromObject((Object)val);
        if (objType != null && this.type.mismatch(objType)) {
            boolean specMatches;
            boolean bl = specMatches = objType.spec() == this.type.spec();
            if (specMatches && this.type instanceof VarlenNativeType) {
                String error = IgniteStringFormatter.format((String)"Value too long [column='{}', type={}]", (Object[])new Object[]{this.name, this.type.displayName()});
                throw new InvalidTypeException(error);
            }
            String error = IgniteStringFormatter.format((String)"Value type does not match [column='{}', expected={}, actual={}]", (Object[])new Object[]{this.name, this.type.displayName(), objType.displayName()});
            throw new InvalidTypeException(error);
        }
        if (this.type.spec() == ColumnType.DATE) {
            this.checkBounds((LocalDate)val, SchemaUtils.DATE_MIN, SchemaUtils.DATE_MAX);
        } else if (this.type.spec() == ColumnType.DATETIME) {
            this.checkBounds((LocalDateTime)val, SchemaUtils.DATETIME_MIN, SchemaUtils.DATETIME_MAX);
        } else if (this.type.spec() == ColumnType.TIMESTAMP) {
            this.checkBounds((Instant)val, SchemaUtils.TIMESTAMP_MIN, SchemaUtils.TIMESTAMP_MAX);
        }
    }

    private <T extends Comparable<T>> void checkBounds(T value, T min, T max) {
        if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
            throw new ValueOutOfBoundsException(IgniteStringFormatter.format((String)"Value is out of allowed range (column='{}', value='{}', min='{}', max='{}').", (Object[])new Object[]{this.name, value, min, max}));
        }
    }

    Column copy(int rowPosition, int keyPosition, int valuePosition, int colocationPosition) {
        assert (keyPosition == -1 && valuePosition >= 0 || keyPosition >= 0 && valuePosition == -1) : "keyPosition=" + keyPosition + ", valuePosition=" + valuePosition;
        return new Column(rowPosition, keyPosition, valuePosition, colocationPosition, this.name, this.type, this.nullable, this.defaultValueProvider, this.computedDefaultValue);
    }

    public String toString() {
        return S.toString(Column.class, (Object)this);
    }

    public static String nullConstraintViolationMessage(String columnName) {
        return IgniteStringFormatter.format((String)"Column '{}' does not allow NULLs", (Object[])new Object[]{columnName});
    }

    public static String numericFieldOverflow(String columnName) {
        return IgniteStringFormatter.format((String)"Numeric field overflow in column '{}'", (Object[])new Object[]{columnName});
    }
}

