/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.schedule;

import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.SchedulingPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.schedule.GridScheduleStatistics;
import org.apache.ignite.internal.processors.schedule.IgniteScheduleProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.AsyncFutureListener;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.scheduler.SchedulerFuture;
import org.jetbrains.annotations.Nullable;

class ScheduleFutureImpl<R>
implements SchedulerFuture<R> {
    private static final long[] EMPTY_TIMES = new long[0];
    private static final long NO_NEXT_EXECUTION_TIME = 0L;
    private volatile String id;
    private String pat;
    private int delay;
    private int maxCalls;
    private String cron;
    private boolean cancelled;
    private boolean done;
    private int callCnt;
    private final AtomicBoolean descheduled = new AtomicBoolean(false);
    private Collection<IgniteInClosure<? super IgniteFuture<R>>> lsnrs = new ArrayList<IgniteInClosure<? super IgniteFuture<R>>>(1);
    private GridScheduleStatistics stats = new GridScheduleStatistics();
    @GridToStringExclude
    private CountDownLatch resLatch = new CountDownLatch(1);
    @GridToStringExclude
    private Scheduler sched;
    @GridToStringExclude
    private GridKernalContext ctx;
    @GridToStringExclude
    private Callable<R> task;
    @GridToStringExclude
    private R lastRes;
    @GridToStringExclude
    private Throwable lastErr;
    private int lastLsnrExecCnt;
    private final Object mux = new Object();
    private IgniteLogger log;
    private final Runnable run = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private CountDownLatch onStart() {
            Object object = ScheduleFutureImpl.this.mux;
            synchronized (object) {
                if (ScheduleFutureImpl.this.done || ScheduleFutureImpl.this.cancelled) {
                    return null;
                }
                if (ScheduleFutureImpl.this.stats.isRunning()) {
                    U.warn((IgniteLogger)ScheduleFutureImpl.this.log, (Object)("Task got scheduled while previous was not finished: " + this));
                    return null;
                }
                if (ScheduleFutureImpl.this.callCnt == ScheduleFutureImpl.this.maxCalls && ScheduleFutureImpl.this.maxCalls > 0) {
                    return null;
                }
                ScheduleFutureImpl.this.callCnt++;
                ScheduleFutureImpl.this.stats.onStart();
                assert (ScheduleFutureImpl.this.resLatch != null);
                return ScheduleFutureImpl.this.resLatch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CountDownLatch latch = this.onStart();
            if (latch == null) {
                return;
            }
            Object res = null;
            Throwable err = null;
            try {
                res = ScheduleFutureImpl.this.task.call();
            }
            catch (Exception e) {
                err = e;
            }
            catch (Error e) {
                err = e;
                U.error((IgniteLogger)ScheduleFutureImpl.this.log, (Object)("Error occurred while executing scheduled task: " + this), (Throwable)e);
            }
            finally {
                if (!ScheduleFutureImpl.this.onEnd(latch, res, err, false)) {
                    ScheduleFutureImpl.this.deschedule();
                }
            }
        }
    };

    ScheduleFutureImpl(Scheduler sched, GridKernalContext ctx, String pat) {
        assert (sched != null);
        assert (ctx != null);
        assert (pat != null);
        this.sched = sched;
        this.ctx = ctx;
        this.pat = pat.trim();
        this.log = ctx.log(this.getClass());
        try {
            this.parsePatternParameters();
        }
        catch (IgniteCheckedException e) {
            this.onEnd(this.resLatch, null, e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean onEnd(CountDownLatch latch, R res, Throwable err, boolean initErr) {
        boolean bl;
        assert (latch != null);
        boolean notifyLsnr = false;
        CountDownLatch resLatchCp = null;
        try {
            Object object = this.mux;
            synchronized (object) {
                this.lastRes = res;
                this.lastErr = err;
                if (initErr) {
                    assert (err != null);
                    notifyLsnr = true;
                } else {
                    this.stats.onEnd();
                    int cnt = this.stats.getExecutionCount();
                    if (this.lastLsnrExecCnt != cnt) {
                        notifyLsnr = true;
                        this.lastLsnrExecCnt = cnt;
                    }
                }
                if (this.callCnt == this.maxCalls && this.maxCalls > 0 || this.cancelled || initErr) {
                    this.done = true;
                    resLatchCp = this.resLatch;
                    this.resLatch = null;
                    bl = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 12] lbl25 : MonitorExitStatement: MONITOREXIT : var7_7
                    latch.countDown();
                    if (resLatchCp != null) {
                        resLatchCp.countDown();
                    }
                    if (notifyLsnr) {
                        this.notifyListeners(res, err);
                    }
                    return bl;
                }
                this.resLatch = new CountDownLatch(1);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            latch.countDown();
            if (resLatchCp != null) {
                resLatchCp.countDown();
            }
            if (notifyLsnr) {
                this.notifyListeners(res, err);
            }
            throw throwable;
        }
        latch.countDown();
        if (resLatchCp != null) {
            resLatchCp.countDown();
        }
        if (notifyLsnr) {
            this.notifyListeners(res, err);
        }
        return bl;
    }

    void schedule(Callable<R> task) {
        block8: {
            assert (task != null);
            assert (this.task == null);
            if (this.isDone()) {
                return;
            }
            this.task = task;
            ((IgniteScheduleProcessor)this.ctx.schedule()).onScheduled(this);
            if (this.delay > 0) {
                this.ctx.timeout().addTimeoutObject((GridTimeoutObject)new GridTimeoutObjectAdapter(this.delay * 1000){

                    public void onTimeout() {
                        block3: {
                            assert (ScheduleFutureImpl.this.id == null);
                            try {
                                ScheduleFutureImpl.this.id = ScheduleFutureImpl.this.sched.schedule(ScheduleFutureImpl.this.cron, ScheduleFutureImpl.this.run);
                            }
                            catch (InvalidPatternException e) {
                                e.printStackTrace();
                                if ($assertionsDisabled) break block3;
                                throw new AssertionError((Object)("Invalid scheduling pattern: " + ScheduleFutureImpl.this.cron));
                            }
                        }
                    }
                });
            } else {
                assert (this.id == null);
                try {
                    this.id = this.sched.schedule(this.cron, this.run);
                }
                catch (InvalidPatternException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)("Invalid scheduling pattern: " + this.cron));
                }
            }
        }
    }

    void deschedule() {
        if (this.descheduled.compareAndSet(false, true)) {
            this.sched.deschedule(this.id);
            ((IgniteScheduleProcessor)this.ctx.schedule()).onDescheduled(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePatternParameters() throws IgniteCheckedException {
        assert (this.pat != null);
        String regEx = "(\\{(\\*|\\d+),\\s*(\\*|\\d+)\\})?(.*)";
        Matcher matcher = Pattern.compile(regEx).matcher(this.pat.trim());
        if (matcher.matches()) {
            String numOfCallsStr;
            String delayStr = matcher.group(2);
            if (delayStr != null) {
                if ("*".equals(delayStr)) {
                    this.delay = 0;
                } else {
                    try {
                        this.delay = Integer.valueOf(delayStr);
                    }
                    catch (NumberFormatException e) {
                        throw new IgniteCheckedException("Invalid delay parameter in schedule pattern [delay=" + delayStr + ", pattern=" + this.pat + ']', (Throwable)e);
                    }
                }
            }
            if ((numOfCallsStr = matcher.group(3)) != null) {
                int maxCalls0;
                if ("*".equals(numOfCallsStr)) {
                    maxCalls0 = 0;
                } else {
                    try {
                        maxCalls0 = Integer.valueOf(numOfCallsStr);
                    }
                    catch (NumberFormatException e) {
                        throw new IgniteCheckedException("Invalid number of calls parameter in schedule pattern [numOfCalls=" + numOfCallsStr + ", pattern=" + this.pat + ']', (Throwable)e);
                    }
                    if (maxCalls0 <= 0) {
                        throw new IgniteCheckedException("Number of calls must be greater than 0 or must be equal to \"*\" in schedule pattern [numOfCalls=" + maxCalls0 + ", pattern=" + this.pat + ']');
                    }
                }
                Object object = this.mux;
                synchronized (object) {
                    this.maxCalls = maxCalls0;
                }
            }
            this.cron = matcher.group(4);
            if (this.cron != null) {
                this.cron = this.cron.trim();
            }
            if (this.cron.isEmpty() || !SchedulingPattern.validate((String)this.cron)) {
                throw new IgniteCheckedException("Invalid cron expression in schedule pattern: " + this.pat);
            }
        } else {
            throw new IgniteCheckedException("Invalid schedule pattern: " + this.pat);
        }
    }

    public String pattern() {
        return this.pat;
    }

    public String id() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] nextExecutionTimes(int cnt, long start) {
        assert (cnt > 0);
        assert (start > 0L);
        if (this.isDone() || this.isCancelled()) {
            return EMPTY_TIMES;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.maxCalls > 0) {
                cnt = Math.min(cnt, this.maxCalls);
            }
        }
        long[] times = new long[cnt];
        if (start < this.createTime() + (long)(this.delay * 1000)) {
            start = this.createTime() + (long)(this.delay * 1000);
        }
        SchedulingPattern ptrn = new SchedulingPattern(this.cron);
        Predictor p = new Predictor(ptrn, start);
        for (int i = 0; i < cnt; ++i) {
            times[i] = p.nextMatchingTime();
        }
        return times;
    }

    public long nextExecutionTime() {
        long[] execTimes = this.nextExecutionTimes(1, U.currentTimeMillis());
        return execTimes == EMPTY_TIMES ? 0L : execTimes[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.mux;
        synchronized (object) {
            if (this.done) {
                return false;
            }
            if (this.cancelled) {
                return true;
            }
            if (!this.stats.isRunning()) {
                this.done = true;
            }
            this.cancelled = true;
        }
        this.deschedule();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createTime() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getCreateTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastStartTime() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getLastStartTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastFinishTime() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getLastEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double averageExecutionTime() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getLastExecutionTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastIdleTime() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getLastIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double averageIdleTime() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getAverageIdleTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.getExecutionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mux;
        synchronized (object) {
            return this.stats.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R last() throws IgniteException {
        Object object = this.mux;
        synchronized (object) {
            if (this.lastErr != null) {
                throw U.convertException((IgniteCheckedException)U.cast((Throwable)this.lastErr));
            }
            return this.lastRes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.mux;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.mux;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(IgniteInClosure<? super IgniteFuture<R>> lsnr) {
        R res;
        Throwable err;
        A.notNull(lsnr, (String)"lsnr");
        boolean notifyLsnr = false;
        Object object = this.mux;
        synchronized (object) {
            this.lsnrs.add(lsnr);
            err = this.lastErr;
            res = this.lastRes;
            int cnt = this.stats.getExecutionCount();
            if (cnt > 0 && this.lastLsnrExecCnt != cnt) {
                this.lastLsnrExecCnt = cnt;
                notifyLsnr = true;
            }
        }
        if (notifyLsnr) {
            this.notifyListener(lsnr, res, err);
        }
    }

    public void listenAsync(IgniteInClosure<? super IgniteFuture<R>> lsnr, Executor exec) {
        A.notNull(lsnr, (String)"lsnr");
        A.notNull((Object)exec, (String)"exec");
        this.listen((IgniteInClosure<? super IgniteFuture<R>>)new AsyncFutureListener(lsnr, exec));
    }

    public <T> IgniteFuture<T> chain(IgniteClosure<? super IgniteFuture<R>, T> doneCb) {
        A.notNull(doneCb, (String)"doneCb");
        return this.chain(doneCb, null);
    }

    public <T> IgniteFuture<T> chainAsync(IgniteClosure<? super IgniteFuture<R>, T> doneCb, Executor exec) {
        A.notNull(doneCb, (String)"");
        A.notNull((Object)exec, (String)"exec");
        return this.chain(doneCb, exec);
    }

    private <T> IgniteFuture<T> chain(final IgniteClosure<? super IgniteFuture<R>, T> doneCb, @Nullable Executor exec) {
        final GridFutureAdapter fut = new GridFutureAdapter<T>(){

            public String toString() {
                return "ChainFuture[orig=" + ScheduleFutureImpl.this + ", doneCb=" + doneCb + ']';
            }
        };
        CI1 lsnr = new CI1<IgniteFuture<R>>(){

            public void apply(IgniteFuture<R> fut0) {
                try {
                    fut.onDone(doneCb.apply(fut0));
                }
                catch (GridClosureException e) {
                    fut.onDone(e.unwrap());
                }
                catch (IgniteException e) {
                    fut.onDone((Throwable)e);
                }
                catch (Error | RuntimeException e) {
                    U.warn(null, (Object)("Failed to notify chained future (is grid stopped?) [igniteInstanceName=" + ScheduleFutureImpl.this.ctx.igniteInstanceName() + ", doneCb=" + doneCb + ", err=" + e.getMessage() + ']'));
                    fut.onDone(e);
                    throw e;
                }
            }
        };
        if (exec != null) {
            lsnr = new AsyncFutureListener((IgniteInClosure)lsnr, exec);
        }
        this.listen((IgniteInClosure<? super IgniteFuture<R>>)lsnr);
        return new IgniteFutureImpl((IgniteInternalFuture)fut);
    }

    private void notifyListener(IgniteInClosure<? super IgniteFuture<R>> lsnr, R res, Throwable err) {
        assert (lsnr != null);
        assert (!Thread.holdsLock(this.mux));
        assert (this.ctx != null);
        lsnr.apply(this.snapshot(res, err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(R res, Throwable err) {
        ArrayList<IgniteInClosure<IgniteFuture<R>>> tmp;
        Object object = this.mux;
        synchronized (object) {
            tmp = new ArrayList<IgniteInClosure<IgniteFuture<R>>>(this.lsnrs);
        }
        SchedulerFuture<R> snapshot = this.snapshot(res, err);
        for (IgniteInClosure igniteInClosure : tmp) {
            igniteInClosure.apply(snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CountDownLatch ensureGet() throws IgniteFutureCancelledException {
        Object object = this.mux;
        synchronized (object) {
            if (this.cancelled) {
                throw new IgniteFutureCancelledException("Scheduling has been cancelled: " + this);
            }
            if (this.done) {
                return null;
            }
            return this.resLatch;
        }
    }

    @Nullable
    public R get() {
        CountDownLatch latch = this.ensureGet();
        if (latch != null) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.isCancelled()) {
                    throw new IgniteFutureCancelledException((Throwable)e);
                }
                if (this.isDone()) {
                    return this.last();
                }
                throw new IgniteInterruptedException(e);
            }
        }
        return this.last();
    }

    public R get(long timeout) {
        return this.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public R get(long timeout, TimeUnit unit) throws IgniteException {
        CountDownLatch latch = this.ensureGet();
        if (latch != null) {
            try {
                if (latch.await(timeout, unit)) {
                    return this.last();
                }
                throw new IgniteFutureTimeoutException("Timed out waiting for completion of next scheduled computation: " + this);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.isCancelled()) {
                    throw new IgniteFutureCancelledException((Throwable)e);
                }
                if (this.isDone()) {
                    return this.last();
                }
                throw new IgniteInterruptedException(e);
            }
        }
        return this.last();
    }

    private SchedulerFuture<R> snapshot(R res, Throwable err) {
        return new ScheduleFutureSnapshot<R>(this, res, err);
    }

    public String toString() {
        return S.toString(ScheduleFutureImpl.class, (Object)this);
    }

    private static class ScheduleFutureSnapshot<R>
    implements SchedulerFuture<R> {
        private ScheduleFutureImpl<R> ref;
        private R res;
        private Throwable err;

        ScheduleFutureSnapshot(ScheduleFutureImpl<R> ref, R res, Throwable err) {
            assert (ref != null);
            this.ref = ref;
            this.res = res;
            this.err = err;
        }

        public R last() {
            if (this.err != null) {
                throw U.convertException((IgniteCheckedException)U.cast((Throwable)this.err));
            }
            return this.res;
        }

        public String id() {
            return this.ref.id();
        }

        public String pattern() {
            return this.ref.pattern();
        }

        public long createTime() {
            return this.ref.createTime();
        }

        public long lastStartTime() {
            return this.ref.lastStartTime();
        }

        public long lastFinishTime() {
            return this.ref.lastFinishTime();
        }

        public double averageExecutionTime() {
            return this.ref.averageExecutionTime();
        }

        public long lastIdleTime() {
            return this.ref.lastIdleTime();
        }

        public double averageIdleTime() {
            return this.ref.averageIdleTime();
        }

        public long[] nextExecutionTimes(int cnt, long start) {
            return this.ref.nextExecutionTimes(cnt, start);
        }

        public int count() {
            return this.ref.count();
        }

        public boolean isRunning() {
            return this.ref.isRunning();
        }

        public long nextExecutionTime() {
            return this.ref.nextExecutionTime();
        }

        @Nullable
        public R get() {
            return this.ref.get();
        }

        public R get(long timeout) {
            return this.ref.get(timeout);
        }

        @Nullable
        public R get(long timeout, TimeUnit unit) {
            return this.ref.get(timeout, unit);
        }

        public boolean cancel() {
            return this.ref.cancel();
        }

        public boolean isDone() {
            return this.ref.isDone();
        }

        public boolean isCancelled() {
            return this.ref.isCancelled();
        }

        public void listen(IgniteInClosure<? super IgniteFuture<R>> lsnr) {
            this.ref.listen(lsnr);
        }

        public void listenAsync(IgniteInClosure<? super IgniteFuture<R>> lsnr, Executor exec) {
            this.ref.listenAsync(lsnr, exec);
        }

        public <T> IgniteFuture<T> chain(IgniteClosure<? super IgniteFuture<R>, T> doneCb) {
            return this.ref.chain(doneCb);
        }

        public <T> IgniteFuture<T> chainAsync(IgniteClosure<? super IgniteFuture<R>, T> doneCb, Executor exec) {
            return this.ref.chainAsync(doneCb, exec);
        }
    }
}

