/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.schedule;

import it.sauronsoftware.cron4j.Scheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.schedule.IgniteScheduleProcessorAdapter;
import org.apache.ignite.internal.processors.schedule.ScheduleFutureImpl;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.scheduler.SchedulerFuture;
import org.jetbrains.annotations.Nullable;

public class IgniteScheduleProcessor
extends IgniteScheduleProcessorAdapter {
    private Scheduler sched;
    private Set<SchedulerFuture<?>> schedFuts = new GridConcurrentHashSet();

    public IgniteScheduleProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public SchedulerFuture<?> schedule(final Runnable c, String ptrn) {
        assert (c != null);
        assert (ptrn != null);
        ScheduleFutureImpl fut = new ScheduleFutureImpl(this.sched, this.ctx, ptrn);
        fut.schedule(new IgniteCallable<Object>(){

            @Nullable
            public Object call() {
                c.run();
                return null;
            }
        });
        return fut;
    }

    public <R> SchedulerFuture<R> schedule(Callable<R> c, String pattern) {
        assert (c != null);
        assert (pattern != null);
        ScheduleFutureImpl<R> fut = new ScheduleFutureImpl<R>(this.sched, this.ctx, pattern);
        fut.schedule(c);
        return fut;
    }

    public Collection<SchedulerFuture<?>> getScheduledFutures() {
        return Collections.unmodifiableList(new ArrayList(this.schedFuts));
    }

    void onDescheduled(SchedulerFuture<?> fut) {
        assert (fut != null);
        this.schedFuts.remove(fut);
    }

    void onScheduled(SchedulerFuture<?> fut) {
        assert (fut != null);
        this.schedFuts.add(fut);
    }

    public void start() throws IgniteCheckedException {
        this.sched = new Scheduler();
        this.sched.start();
    }

    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.sched.isStarted()) {
            this.sched.stop();
        }
        this.sched = null;
    }

    public void printMemoryStats() {
        X.println((String)">>>", (Object[])new Object[0]);
        X.println((String)(">>> Schedule processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']'), (Object[])new Object[0]);
        X.println((String)(">>>   schedFutsSize: " + this.schedFuts.size()), (Object[])new Object[0]);
    }
}

