/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.threading;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.catalog.definitions.CacheDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingCache;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingTable;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;

public class PublicApiThreadingIgniteCatalog
implements IgniteCatalog,
Wrapper {
    private final IgniteCatalog catalog;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteCatalog(IgniteCatalog catalog, Executor asyncContinuationExecutor) {
        this.catalog = catalog;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public CompletableFuture<Table> createTableAsync(Class<?> recordClass) {
        return this.doAsyncOperationForTable(() -> this.catalog.createTableAsync(recordClass));
    }

    public CompletableFuture<Table> createTableAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.doAsyncOperationForTable(() -> this.catalog.createTableAsync(keyClass, valueClass));
    }

    public CompletableFuture<Table> createTableAsync(TableDefinition definition) {
        return this.doAsyncOperationForTable(() -> this.catalog.createTableAsync(definition));
    }

    public Table createTable(Class<?> recordClass) {
        Table table = (Table)PublicApiThreading.execUserSyncOperation(() -> this.catalog.createTable(recordClass));
        return this.wrapTableForPublicUse(table);
    }

    public Table createTable(Class<?> keyClass, Class<?> valueClass) {
        Table table = (Table)PublicApiThreading.execUserSyncOperation(() -> this.catalog.createTable(keyClass, valueClass));
        return this.wrapTableForPublicUse(table);
    }

    public Table createTable(TableDefinition definition) {
        Table table = (Table)PublicApiThreading.execUserSyncOperation(() -> this.catalog.createTable(definition));
        return this.wrapTableForPublicUse(table);
    }

    public CompletableFuture<TableDefinition> tableDefinitionAsync(QualifiedName tableName) {
        return this.doAsyncOperation(() -> this.catalog.tableDefinitionAsync(tableName));
    }

    public TableDefinition tableDefinition(QualifiedName tableName) {
        return (TableDefinition)PublicApiThreading.execUserSyncOperation(() -> this.catalog.tableDefinition(tableName));
    }

    public CompletableFuture<Void> createZoneAsync(ZoneDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.createZoneAsync(definition));
    }

    public void createZone(ZoneDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.createZone(definition));
    }

    public CompletableFuture<ZoneDefinition> zoneDefinitionAsync(String zoneName) {
        return (CompletableFuture)PublicApiThreading.execUserSyncOperation(() -> this.catalog.zoneDefinitionAsync(zoneName));
    }

    public ZoneDefinition zoneDefinition(String zoneName) {
        return (ZoneDefinition)PublicApiThreading.execUserSyncOperation(() -> this.catalog.zoneDefinition(zoneName));
    }

    public CompletableFuture<Void> dropTableAsync(TableDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.dropTableAsync(definition));
    }

    public CompletableFuture<Void> dropTableAsync(QualifiedName name) {
        return this.doAsyncOperation(() -> this.catalog.dropTableAsync(name));
    }

    public void dropTable(TableDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropTable(definition));
    }

    public void dropTable(QualifiedName name) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropTable(name));
    }

    public CompletableFuture<Void> dropZoneAsync(ZoneDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.dropZoneAsync(definition));
    }

    public CompletableFuture<Void> dropZoneAsync(String name) {
        return this.doAsyncOperation(() -> this.catalog.dropZoneAsync(name));
    }

    public void dropZone(ZoneDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropZone(definition));
    }

    public void dropZone(String name) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropZone(name));
    }

    public Cache createCache(Class<?> keyClass, Class<?> valueClass) {
        Cache cache = (Cache)PublicApiThreading.execUserSyncOperation(() -> this.catalog.createCache(keyClass, valueClass));
        return this.wrapCacheForPublicUse(cache);
    }

    public Cache createCache(CacheDefinition definition) {
        Cache cache = (Cache)PublicApiThreading.execUserSyncOperation(() -> this.catalog.createCache(definition));
        return this.wrapCacheForPublicUse(cache);
    }

    public CompletableFuture<Cache> createCacheAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.doAsyncOperationForCache(() -> this.catalog.createCacheAsync(keyClass, valueClass));
    }

    public CompletableFuture<Cache> createCacheAsync(CacheDefinition definition) {
        return this.doAsyncOperationForCache(() -> this.catalog.createCacheAsync(definition));
    }

    public CacheDefinition cacheDefinition(QualifiedName name) {
        return (CacheDefinition)PublicApiThreading.execUserSyncOperation(() -> this.catalog.cacheDefinition(name));
    }

    public CompletableFuture<CacheDefinition> cacheDefinitionAsync(QualifiedName name) {
        return this.doAsyncOperation(() -> this.catalog.cacheDefinitionAsync(name));
    }

    public void dropCache(CacheDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropCache(definition));
    }

    public void dropCache(QualifiedName name) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropCache(name));
    }

    public CompletableFuture<Void> dropCacheAsync(CacheDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.dropCacheAsync(definition));
    }

    public CompletableFuture<Void> dropCacheAsync(QualifiedName name) {
        return this.doAsyncOperation(() -> this.catalog.dropCacheAsync(name));
    }

    private CompletableFuture<Table> doAsyncOperationForTable(Supplier<CompletableFuture<Table>> operation) {
        return this.doAsyncOperation(operation).thenApply(this::wrapTableForPublicUse);
    }

    private <T> CompletableFuture<T> doAsyncOperation(Supplier<CompletableFuture<T>> operation) {
        CompletableFuture future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack((CompletableFuture)future, (Executor)this.asyncContinuationExecutor);
    }

    private PublicApiThreadingTable wrapTableForPublicUse(Table table) {
        return new PublicApiThreadingTable(table, this.asyncContinuationExecutor);
    }

    private CompletableFuture<Cache> doAsyncOperationForCache(Supplier<CompletableFuture<Cache>> operation) {
        return this.doAsyncOperation(operation).thenApply(this::wrapCacheForPublicUse);
    }

    private PublicApiThreadingCache wrapCacheForPublicUse(Cache cache) {
        return new PublicApiThreadingCache(cache, this.asyncContinuationExecutor);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.catalog);
    }
}

