/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofApiObject;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

class RestartProofRecordView<R>
extends RestartProofApiObject<RecordView<R>>
implements RecordView<R>,
Wrapper {
    RestartProofRecordView(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, Function<Ignite, RecordView<R>> viewFactory) {
        super(attachmentLock, initialIgnite, viewFactory);
    }

    public R get(@Nullable Transaction tx, R keyRec) {
        return (R)this.attached(view -> view.get(tx, keyRec));
    }

    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        return this.attachedAsync(view -> view.getAsync(tx, keyRec));
    }

    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.attached(view -> view.getAll(tx, keyRecs));
    }

    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.attachedAsync(view -> view.getAllAsync(tx, keyRecs));
    }

    public boolean contains(@Nullable Transaction tx, R keyRec) {
        return this.attached(view -> view.contains(tx, keyRec));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R keyRec) {
        return this.attachedAsync(view -> view.containsAsync(tx, keyRec));
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return this.attached(view -> view.containsAll(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        return this.attachedAsync(view -> view.containsAllAsync(tx, keys));
    }

    public void upsert(@Nullable Transaction tx, R rec) {
        this.consumeAttached(view -> view.upsert(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        return this.attachedAsync(view -> view.upsertAsync(tx, rec));
    }

    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        this.consumeAttached(view -> view.upsertAll(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.attachedAsync(view -> view.upsertAllAsync(tx, recs));
    }

    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return (R)this.attached(view -> view.getAndUpsert(tx, rec));
    }

    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        return this.attachedAsync(view -> view.getAndUpsertAsync(tx, rec));
    }

    public boolean insert(@Nullable Transaction tx, R rec) {
        return this.attached(view -> view.insert(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        return this.attachedAsync(view -> view.insertAsync(tx, rec));
    }

    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return this.attached(view -> view.insertAll(tx, recs));
    }

    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.attachedAsync(view -> view.insertAllAsync(tx, recs));
    }

    public boolean replace(@Nullable Transaction tx, R rec) {
        return this.attached(view -> view.replace(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return this.attached(view -> view.replace(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        return this.attachedAsync(view -> view.replaceAsync(tx, rec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        return this.attachedAsync(view -> view.replaceAsync(tx, oldRec, newRec));
    }

    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return (R)this.attached(view -> view.getAndReplace(tx, rec));
    }

    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        return this.attachedAsync(view -> view.getAndReplaceAsync(tx, rec));
    }

    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return this.attached(view -> view.delete(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        return this.attachedAsync(view -> view.deleteAsync(tx, keyRec));
    }

    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return this.attached(view -> view.deleteExact(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        return this.attachedAsync(view -> view.deleteExactAsync(tx, rec));
    }

    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return (R)this.attached(view -> view.getAndDelete(tx, keyRec));
    }

    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        return this.attachedAsync(view -> view.getAndDeleteAsync(tx, keyRec));
    }

    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.attached(view -> view.deleteAll(tx, keyRecs));
    }

    public void deleteAll(@Nullable Transaction tx) {
        this.consumeAttached(view -> view.deleteAll(tx));
    }

    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.attachedAsync(view -> view.deleteAllAsync(tx, keyRecs));
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.attachedAsync(view -> view.deleteAllAsync(tx));
    }

    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return this.attached(view -> view.deleteAllExact(tx, recs));
    }

    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.attachedAsync(view -> view.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        return this.attachedAsync(view -> view.streamData(publisher, options));
    }

    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        return this.attachedAsync(view -> view.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options));
    }

    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.attached(view -> view.query(tx, criteria, indexName, opts));
    }

    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.attachedAsync(view -> view.queryAsync(tx, criteria, indexName, opts));
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.consumeAttached(view -> view.queryContinuously(subscriber, options));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attached(view -> Wrappers.unwrap((Object)view, (Class)classToUnwrap));
    }

    public void close() throws Exception {
        this.consumeAttached(view -> {
            try {
                view.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

