/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

class LowWatermarkRectifier
implements IgniteComponent {
    private final LowWatermark lowWatermark;
    private final CatalogService catalogService;

    LowWatermarkRectifier(LowWatermark lowWatermark, CatalogService catalogService) {
        this.lowWatermark = lowWatermark;
        this.catalogService = catalogService;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        HybridTimestamp earliestCatalogTimestamp = HybridTimestamp.hybridTimestamp((long)this.catalogService.earliestCatalog().time());
        @Nullable HybridTimestamp lwm = this.lowWatermark.getLowWatermark();
        if (lwm != null && lwm.compareTo(earliestCatalogTimestamp) < 0) {
            this.lowWatermark.setLowWatermarkOnRecovery(earliestCatalogTimestamp);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

