/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import org.apache.ignite.Ignite;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RefCache;
import org.apache.ignite.internal.restart.RestartProofKeyValueView;
import org.apache.ignite.internal.restart.RestartProofPartitionManager;
import org.apache.ignite.internal.restart.RestartProofRecordView;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersionsImpl;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.TableViewOptions;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.PartitionManager;

class RestartProofTable
implements Table,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;
    private final int tableId;
    private final RefCache<Table> tableCache;

    RestartProofTable(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, int tableId) {
        this.attachmentLock = attachmentLock;
        this.tableId = tableId;
        this.tableCache = new RefCache<Table>(initialIgnite, this::tableFromIgnite);
    }

    static int tableId(Table table) {
        return ((TableViewInternal)Wrappers.unwrap((Object)table, TableViewInternal.class)).tableId();
    }

    private Table tableFromIgnite(Ignite ignite) {
        Table underlyingTable = ignite.tables().tables().stream().filter(table -> RestartProofTable.tableId(table) == this.tableId).findAny().orElse(null);
        if (underlyingTable == null) {
            throw SchemaVersionsImpl.tableNotFoundException((int)this.tableId);
        }
        return underlyingTable;
    }

    public QualifiedName qualifiedName() {
        return this.attachmentLock.attached(ignite -> this.tableCache.actualFor((Ignite)ignite).qualifiedName());
    }

    public PartitionManager partitionManager() {
        return this.attachmentLock.attached(ignite -> new RestartProofPartitionManager(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).partitionManager()));
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView(recMapper)));
    }

    public RecordView<Tuple> recordView() {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView()));
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper, TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView(recMapper, tableViewOptions)));
    }

    public RecordView<Tuple> recordView(TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView(tableViewOptions)));
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView(keyMapper, valMapper)));
    }

    public KeyValueView<Tuple, Tuple> keyValueView() {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView()));
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper, TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView(keyMapper, valMapper, tableViewOptions)));
    }

    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView(tableViewOptions)));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)this.tableCache.actualFor((Ignite)ignite), (Class)classToUnwrap));
    }
}

