/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteServer;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientHandlerModule;
import org.apache.ignite.client.handler.ClientInboundMessageHandler;
import org.apache.ignite.client.handler.ClusterInfo;
import org.apache.ignite.client.handler.configuration.ClientConnectorConfiguration;
import org.apache.ignite.client.handler.configuration.ClientConnectorExtensionConfiguration;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.configuration.ConfigurationDynamicDefaultsPatcher;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.KeyIgnorer;
import org.apache.ignite.internal.app.LifecycleManager;
import org.apache.ignite.internal.app.NodePropertiesImpl;
import org.apache.ignite.internal.app.SystemPropertiesComponent;
import org.apache.ignite.internal.app.ThreadPoolsManager;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogManagerImpl;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.compaction.CatalogCompactionRunner;
import org.apache.ignite.internal.catalog.configuration.SchemaSynchronizationConfiguration;
import org.apache.ignite.internal.catalog.configuration.SchemaSynchronizationExtensionConfiguration;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.sql.IgniteCatalogSqlImpl;
import org.apache.ignite.internal.catalog.storage.UpdateLog;
import org.apache.ignite.internal.catalog.storage.UpdateLogImpl;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.cluster.management.ClusterIdStore;
import org.apache.ignite.internal.cluster.management.ClusterInitializer;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterStopper;
import org.apache.ignite.internal.cluster.management.CmgGroupId;
import org.apache.ignite.internal.cluster.management.InvalidNodeConfigurationException;
import org.apache.ignite.internal.cluster.management.NodeAttributes;
import org.apache.ignite.internal.cluster.management.NodeAttributesCollector;
import org.apache.ignite.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite.internal.cluster.management.configuration.NodeAttributesExtensionConfiguration;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite.internal.cluster.management.raft.RocksDbClusterStateStorage;
import org.apache.ignite.internal.cluster.management.raft.ValidationManager;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopologyImpl;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopologyServiceImpl;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.compute.AntiHijackIgniteCompute;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeComponentImpl;
import org.apache.ignite.internal.compute.IgniteComputeImpl;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.LicensedIgniteCompute;
import org.apache.ignite.internal.compute.SecuredIgniteCompute;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.compute.configuration.ComputeExtensionConfiguration;
import org.apache.ignite.internal.compute.executor.ComputeExecutor;
import org.apache.ignite.internal.compute.executor.ComputeExecutorImpl;
import org.apache.ignite.internal.compute.executor.SecuredIgnite;
import org.apache.ignite.internal.compute.executor.platform.PlatformComputeTransport;
import org.apache.ignite.internal.compute.loader.JobClassLoaderFactory;
import org.apache.ignite.internal.compute.loader.JobContextManager;
import org.apache.ignite.internal.compute.state.ComputeStateMachine;
import org.apache.ignite.internal.compute.state.InMemoryComputeStateMachine;
import org.apache.ignite.internal.configuration.ComponentWorkingDir;
import org.apache.ignite.internal.configuration.ConfigurationDynamicDefaultsPatcherImpl;
import org.apache.ignite.internal.configuration.ConfigurationManager;
import org.apache.ignite.internal.configuration.ConfigurationModules;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.IgnitePaths;
import org.apache.ignite.internal.configuration.JdbcPortProviderImpl;
import org.apache.ignite.internal.configuration.RaftGroupOptionsConfigHelper;
import org.apache.ignite.internal.configuration.ServiceLoaderModulesProvider;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.configuration.SystemDistributedExtensionConfiguration;
import org.apache.ignite.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite.internal.configuration.SystemLocalExtensionConfiguration;
import org.apache.ignite.internal.configuration.ThreadPoolsExtensionConfiguration;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.DistributedConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.LocalFileConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidatorImpl;
import org.apache.ignite.internal.deployunit.DeploymentManagerImpl;
import org.apache.ignite.internal.deployunit.IgniteDeployment;
import org.apache.ignite.internal.deployunit.configuration.DeploymentExtensionConfiguration;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStoreImpl;
import org.apache.ignite.internal.disaster.system.ClusterIdService;
import org.apache.ignite.internal.disaster.system.MetastorageRepairImpl;
import org.apache.ignite.internal.disaster.system.ServerRestarter;
import org.apache.ignite.internal.disaster.system.SystemDisasterRecoveryManager;
import org.apache.ignite.internal.disaster.system.SystemDisasterRecoveryManagerImpl;
import org.apache.ignite.internal.disaster.system.SystemDisasterRecoveryStorage;
import org.apache.ignite.internal.disaster.system.repair.MetastorageRepair;
import org.apache.ignite.internal.disaster.system.storage.ClusterResetStorage;
import org.apache.ignite.internal.disaster.system.storage.MetastorageRepairStorage;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceMinimumRequiredTimeProvider;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceMinimumRequiredTimeProviderImpl;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.event.EventProducer;
import org.apache.ignite.internal.eventlog.api.Event;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.eventlog.config.schema.EventLogExtensionConfiguration;
import org.apache.ignite.internal.eventlog.impl.EventLogImpl;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.failure.configuration.FailureProcessorConfiguration;
import org.apache.ignite.internal.failure.configuration.FailureProcessorExtensionConfiguration;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.ClockServiceImpl;
import org.apache.ignite.internal.hlc.ClockWaiter;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridClockImpl;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.index.IndexBuildingManager;
import org.apache.ignite.internal.index.IndexManager;
import org.apache.ignite.internal.index.IndexNodeFinishedRwTransactionsChecker;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.LowWatermarkImpl;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.cache.IdempotentCacheVacuumizer;
import org.apache.ignite.internal.metastorage.impl.ElectionListener;
import org.apache.ignite.internal.metastorage.impl.MetaStorageCompactionTrigger;
import org.apache.ignite.internal.metastorage.impl.MetaStorageManagerImpl;
import org.apache.ignite.internal.metastorage.impl.MetaStorageRevisionListenerRegistry;
import org.apache.ignite.internal.metastorage.impl.MetastorageGroupMaintenance;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.NotificationEnqueuedListener;
import org.apache.ignite.internal.metastorage.server.ReadOperationForCompactionTracker;
import org.apache.ignite.internal.metastorage.server.persistence.EncryptedRocksDbKeyValueStorage;
import org.apache.ignite.internal.metastorage.server.raft.MetastorageGroupId;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricManagerImpl;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.SecuredMetricManager;
import org.apache.ignite.internal.metrics.configuration.MetricExtensionConfiguration;
import org.apache.ignite.internal.metrics.messaging.MetricMessaging;
import org.apache.ignite.internal.metrics.sources.ClockServiceMetricSource;
import org.apache.ignite.internal.metrics.sources.JvmMetricSource;
import org.apache.ignite.internal.metrics.sources.OsMetricSource;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ChannelTypeRegistryProvider;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.DefaultMessagingService;
import org.apache.ignite.internal.network.IgniteClusterImpl;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.JoinedNodes;
import org.apache.ignite.internal.network.MessageSerializationRegistryImpl;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.NettyWorkersRegistrar;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.PublicApiThreadingIgniteCluster;
import org.apache.ignite.internal.network.configuration.NetworkConfiguration;
import org.apache.ignite.internal.network.configuration.NetworkExtensionConfiguration;
import org.apache.ignite.internal.network.recovery.InMemoryStaleIds;
import org.apache.ignite.internal.network.recovery.StaleIds;
import org.apache.ignite.internal.network.scalecube.ScaleCubeClusterServiceFactory;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.network.serialization.SerializationRegistryServiceLoader;
import org.apache.ignite.internal.network.wrapper.JumpToExecutorByConsistentIdAfterSend;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessageGroup;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.PlacementDriverManager;
import org.apache.ignite.internal.raft.Loza;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.internal.raft.RaftGroupOptionsConfigurer;
import org.apache.ignite.internal.raft.RaftManager;
import org.apache.ignite.internal.raft.client.TopologyAwareRaftGroupServiceFactory;
import org.apache.ignite.internal.raft.configuration.RaftConfiguration;
import org.apache.ignite.internal.raft.configuration.RaftExtensionConfiguration;
import org.apache.ignite.internal.raft.server.impl.GroupStoragesContextResolver;
import org.apache.ignite.internal.raft.storage.GroupStoragesDestructionIntents;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.EncryptedLogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageFactoryCreator;
import org.apache.ignite.internal.raft.storage.impl.VaultGroupStoragesDestructionIntents;
import org.apache.ignite.internal.raft.storage.impl.VolatileLogStorageFactoryCreator;
import org.apache.ignite.internal.raft.util.SharedLogStorageFactoryUtils;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.VersionedAssignments;
import org.apache.ignite.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite.internal.replicator.configuration.ReplicationExtensionConfiguration;
import org.apache.ignite.internal.rest.RestComponent;
import org.apache.ignite.internal.rest.RestFactory;
import org.apache.ignite.internal.rest.RestManager;
import org.apache.ignite.internal.rest.RestManagerFactory;
import org.apache.ignite.internal.rest.authentication.AuthenticationProviderFactory;
import org.apache.ignite.internal.rest.cluster.ClusterManagementRestFactory;
import org.apache.ignite.internal.rest.compute.ComputeRestFactory;
import org.apache.ignite.internal.rest.configuration.PresentationsFactory;
import org.apache.ignite.internal.rest.configuration.RestConfiguration;
import org.apache.ignite.internal.rest.configuration.RestExtensionConfiguration;
import org.apache.ignite.internal.rest.deployment.CodeDeploymentRestFactory;
import org.apache.ignite.internal.rest.metrics.MetricRestFactory;
import org.apache.ignite.internal.rest.node.JdbcPortProvider;
import org.apache.ignite.internal.rest.node.NodeManagementRestFactory;
import org.apache.ignite.internal.rest.node.NodePropertiesFactory;
import org.apache.ignite.internal.rest.node.StateProvider;
import org.apache.ignite.internal.rest.recovery.DisasterRecoveryFactory;
import org.apache.ignite.internal.rest.recovery.system.SystemDisasterRecoveryFactory;
import org.apache.ignite.internal.rest.sql.SqlQueryRestFactory;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaSafeTimeTracker;
import org.apache.ignite.internal.schema.SchemaSafeTimeTrackerImpl;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.schema.configuration.GcConfiguration;
import org.apache.ignite.internal.schema.configuration.GcExtensionConfiguration;
import org.apache.ignite.internal.security.authentication.AuthenticationManager;
import org.apache.ignite.internal.security.authentication.AuthenticationManagerImpl;
import org.apache.ignite.internal.security.configuration.SecurityConfiguration;
import org.apache.ignite.internal.security.configuration.SecurityExtensionConfiguration;
import org.apache.ignite.internal.sql.api.IgniteSqlImpl;
import org.apache.ignite.internal.sql.api.PublicApiThreadingIgniteSql;
import org.apache.ignite.internal.sql.api.SecuredIgniteSql;
import org.apache.ignite.internal.sql.configuration.distributed.SqlClusterExtensionConfiguration;
import org.apache.ignite.internal.sql.configuration.local.SqlNodeExtensionConfiguration;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlQueryProcessor;
import org.apache.ignite.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite.internal.sql.engine.api.kill.KillHandlerRegistry;
import org.apache.ignite.internal.sql.engine.api.kill.OperationKillHandler;
import org.apache.ignite.internal.sql.engine.exec.kill.KillCommandHandler;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.DataStorageModules;
import org.apache.ignite.internal.storage.SecondaryStorageModule;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.engine.ThreadAssertingStorageEngine;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryStorageEngine;
import org.apache.ignite.internal.storage.secondary.SecondaryStorageEngine;
import org.apache.ignite.internal.storage.secondary.ThreadAssertingSecondaryStorageEngine;
import org.apache.ignite.internal.systemview.SystemViewManagerImpl;
import org.apache.ignite.internal.systemview.api.SystemViewManager;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.configuration.TableConfiguration;
import org.apache.ignite.internal.table.configuration.TableExtensionConfiguration;
import org.apache.ignite.internal.table.distributed.PartitionModificationCounterFactory;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingIgniteCaches;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingIgniteTables;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.distributed.disaster.AuthorizedDisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorServiceImpl;
import org.apache.ignite.internal.table.distributed.schema.CheckCatalogVersionOnActionRequest;
import org.apache.ignite.internal.table.distributed.schema.CheckCatalogVersionOnAppendEntries;
import org.apache.ignite.internal.table.distributed.schema.SchemaSyncServiceImpl;
import org.apache.ignite.internal.table.distributed.schema.ThreadLocalPartitionCommandsMarshaller;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.threading.PublicApiThreadingIgniteCatalog;
import org.apache.ignite.internal.tx.ActiveLocalTxMinimumRequiredTimeProvider;
import org.apache.ignite.internal.tx.LocalRwTxCounter;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.configuration.TransactionConfiguration;
import org.apache.ignite.internal.tx.configuration.TransactionExtensionConfiguration;
import org.apache.ignite.internal.tx.impl.HeapLockManager;
import org.apache.ignite.internal.tx.impl.IgniteTransactionsImpl;
import org.apache.ignite.internal.tx.impl.PublicApiThreadingIgniteTransactions;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.tx.impl.ResourceVacuumManager;
import org.apache.ignite.internal.tx.impl.TransactionIdGenerator;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.impl.TxManagerImpl;
import org.apache.ignite.internal.tx.message.TxMessageGroup;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite.internal.util.ClusterNameProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.internal.vault.VaultService;
import org.apache.ignite.internal.vault.persistence.PersistentVaultService;
import org.apache.ignite.internal.version.DefaultIgniteProductVersionSource;
import org.apache.ignite.internal.version.IgniteProductVersionSource;
import org.apache.ignite.internal.worker.CriticalWorkerRegistry;
import org.apache.ignite.internal.worker.CriticalWorkerWatchdog;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.IgniteCluster;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;
import org.apache.ignite.raft.jraft.rpc.impl.ActionRequestInterceptor;
import org.apache.ignite.raft.jraft.rpc.impl.RaftGroupEventsClientListener;
import org.apache.ignite.raft.jraft.rpc.impl.core.AppendEntriesRequestInterceptor;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;
import org.gridgain.internal.cdc.api.CdcManager;
import org.gridgain.internal.cdc.api.sink.IcebergTableSink;
import org.gridgain.internal.cdc.api.sink.IcebergTableSinkValidator;
import org.gridgain.internal.cdc.core.CdcManagerImpl;
import org.gridgain.internal.cdc.core.LicensedCdcManager;
import org.gridgain.internal.cdc.core.SecuredCdcManager;
import org.gridgain.internal.cdc.gg8.sink.GridGain8SinkAdapter;
import org.gridgain.internal.dcr.DcrManager;
import org.gridgain.internal.dcr.DcrManagerImpl;
import org.gridgain.internal.dcr.LicensedDcrManager;
import org.gridgain.internal.encryption.EncryptionConfigurationVault;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.EncryptionManagerImpl;
import org.gridgain.internal.encryption.configuration.EncryptionConfiguration;
import org.gridgain.internal.encryption.configuration.EncryptionExtensionConfiguration;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManager;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManagerImpl;
import org.gridgain.internal.encryption.storage.KeyStorage;
import org.gridgain.internal.eviction.EvictionManager;
import org.gridgain.internal.eviction.PrimaryReplicaProvider;
import org.gridgain.internal.eviction.task.EvictionTaskFactory;
import org.gridgain.internal.license.GridLicenseManager;
import org.gridgain.internal.license.HasLicenseFeatureValidator;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.LicenseAttributesCollector;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.LicenseFeatureCheckerImpl;
import org.gridgain.internal.license.LicenseField;
import org.gridgain.internal.license.LicenseValidationManager;
import org.gridgain.internal.license.configuration.LicenseConfiguration;
import org.gridgain.internal.license.configuration.LicenseExtensionConfiguration;
import org.gridgain.internal.license.event.LicenseEvent;
import org.gridgain.internal.license.provider.LicenseProviderFactory;
import org.gridgain.internal.pitr.PitrManager;
import org.gridgain.internal.pitr.configuration.NodePitrExtensionConfiguration;
import org.gridgain.internal.rbac.Rbac;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rest.cdc.CdcRestFactory;
import org.gridgain.internal.rest.dcr.DcrRestFactory;
import org.gridgain.internal.rest.jwt.JwtRestFactory;
import org.gridgain.internal.rest.license.LicenseManagementRestFactory;
import org.gridgain.internal.rest.rbac.RbacRestFactory;
import org.gridgain.internal.rest.recovery.pitr.PitrRestFactory;
import org.gridgain.internal.rest.snapshot.SnapshotManagementRestFactory;
import org.gridgain.internal.rest.upgrade.RollingUpgradeRestFactory;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.jwt.JwtTokenManager;
import org.gridgain.internal.security.key.NodeKeyManager;
import org.gridgain.internal.security.key.NodeKeyManagerImpl;
import org.gridgain.internal.security.key.store.PrivateKeyStore;
import org.gridgain.internal.security.key.store.PublicKeyStore;
import org.gridgain.internal.snapshots.SecuredSnapshotFacade;
import org.gridgain.internal.snapshots.SnapshotFacade;
import org.gridgain.internal.snapshots.SnapshotFacadeImpl;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.SnapshotBufferManager;
import org.gridgain.internal.snapshots.configuration.ClusterSnapshotConfiguration;
import org.gridgain.internal.snapshots.configuration.ClusterSnapshotExtensionConfiguration;
import org.gridgain.internal.snapshots.configuration.NodeSnapshotConfiguration;
import org.gridgain.internal.snapshots.configuration.NodeSnapshotExtensionConfiguration;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManager;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManagerImpl;
import org.gridgain.internal.snapshots.tombstone.SnapshotTombstoneManager;
import org.gridgain.internal.structure.GridgainStructuresComponent;
import org.gridgain.internal.table.InternalTablesWrapper;
import org.gridgain.internal.upgrade.RollingUpgradeManager;
import org.gridgain.internal.upgrade.RollingUpgradeManagerImpl;
import org.gridgain.internal.upgrade.SecuredRollingUpgradeManager;
import org.gridgain.lang.GridgainErrorGroups;
import org.gridgain.structure.IgniteStructures;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteImpl
implements Ignite {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteImpl.class);
    private static final String PARTITION_GROUP_NAME = "partition";
    private static final String TX_STATE_DIR = "tx-state";
    private final String name;
    private final Path workDir;
    private final LifecycleManager lifecycleManager;
    private final ThreadPoolsManager threadPoolsManager;
    private final VaultManager vaultMgr;
    private final NodePropertiesImpl nodeProperties;
    private final SqlQueryProcessor qryEngine;
    private final IgniteSqlImpl sql;
    private final IgniteSql sqlWithSystemContext;
    private final ConfigurationManager nodeCfgMgr;
    private final ClusterIdService clusterIdService;
    private final ClusterService clusterSvc;
    private final ComputeComponentImpl computeComponent;
    private final CriticalWorkerWatchdog criticalWorkerRegistry;
    private final LicenseFeatureCheckerImpl licenseFeatureChecker;
    private final FailureManager failureManager;
    private final NettyBootstrapFactory nettyBootstrapFactory;
    private final NettyWorkersRegistrar nettyWorkersRegistrar;
    private final Loza raftMgr;
    private final MetaStorageManagerImpl metaStorageMgr;
    private final MetaStorageCompactionTrigger metaStorageCompactionTrigger;
    private final PlacementDriverManager placementDriverMgr;
    private final ConfigurationManager clusterCfgMgr;
    private final IdempotentCacheVacuumizer idempotentCacheVacuumizer;
    private final ClusterInitializer clusterInitializer;
    private final ReplicaManager replicaMgr;
    private final TxManagerImpl txManager;
    private final TableManager distributedTblMgr;
    private final TxStateRocksDbSharedStorage sharedTxStateStorage;
    private final DisasterRecoveryManager disasterRecoveryManager;
    private final IndexManager indexManager;
    private final RestComponent restComponent;
    private final ClusterStateStorage clusterStateStorage;
    private final ClusterManagementGroupManager cmgMgr;
    private final LogicalTopologyService logicalTopologyService;
    private final ComponentWorkingDir partitionsWorkDir;
    private final ComponentWorkingDir metastorageWorkDir;
    private final ComponentWorkingDir cmgWorkDir;
    private final ClientHandlerModule clientHandlerModule;
    private final ConfigurationStorage cfgStorage;
    private final IgniteComputeInternal compute;
    private final LongJvmPauseDetector longJvmPauseDetector;
    private final DataStorageManager dataStorageMgr;
    private final SchemaSafeTimeTrackerImpl schemaSafeTimeTracker;
    private final SchemaManager schemaManager;
    private final MetricManager metricManager;
    private final MetricMessaging metricMessaging;
    private final DeploymentManagerImpl deploymentManager;
    private final DistributionZoneManager distributionZoneManager;
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final VolatileLogStorageFactoryCreator volatileLogStorageFactoryCreator;
    private final SystemPropertiesComponent systemPropertiesComponent;
    private final HybridClock clock;
    private final ClockWaiter clockWaiter;
    private final ClockService clockService;
    private final LowWatermarkImpl lowWatermark;
    private final SnapshotTombstoneManager snapshotTombstoneManager;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final CatalogManager catalogManager;
    private final CatalogCompactionRunner catalogCompactionRunner;
    private final AuthenticationManagerImpl authenticationManager;
    private final Rbac rbac;
    private final HybridTimestampTracker observableTimestampTracker = HybridTimestampTracker.atomicTracker(null);
    private final SystemViewManagerImpl systemViewManager;
    private final IndexBuildingManager indexBuildingManager;
    private final IndexNodeFinishedRwTransactionsChecker indexNodeFinishedRwTransactionsChecker;
    private final ResourceVacuumManager resourceVacuumManager;
    private final RemotelyTriggeredResourceRegistry resourcesRegistry;
    private final SystemDisasterRecoveryManagerImpl systemDisasterRecoveryManager;
    private final IgniteTables publicTables;
    private final IgniteTransactions publicTransactions;
    private final IgniteSql publicSql;
    private final IgniteCompute publicCompute;
    private final IgniteCatalog publicCatalog;
    private final IgniteCaches publicCaches;
    private final IgniteCluster publicCluster;
    private final LogStorageFactory partitionsLogStorageFactory;
    private final LogStorageFactory msLogStorageFactory;
    private final LogStorageFactory cmgLogStorageFactory;
    private final RaftGroupOptionsConfigurer partitionRaftConfigurer;
    private final IndexMetaStorage indexMetaStorage;
    private final SnapshotManager snapshotManager;
    private final SnapshotFileSystemManager snapshotFileSystemManager;
    private final PitrManager pitrManager;
    private final NodeKeyManager nodeKeyManager;
    private final JwtTokenManager jwtTokenManager;
    private final DcrManager dcrManager;
    private final RollingUpgradeManager rollingUpgradeManager;
    private final RollingUpgradeManager unsecuredRollingUpgradeManager;
    private final SnapshotFacade snapshotFacade;
    private final EncryptionManager encryptionManager;
    private final EncryptionConfigurationVault encryptionConfigurationVault;
    private final EventLogImpl eventLog;
    private final EvictionManager evictionManager;
    private final IgniteStructures igniteStructures;
    private final GridLicenseManager licenseManager;
    private final KillCommandHandler killCommandHandler;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final CompletableFuture<Void> stopFuture = new CompletableFuture();
    @Nullable
    private volatile ClusterState clusterState;
    private final CdcManager cdcManager;
    private final ClockServiceMetricSource clockServiceMetricSource;

    IgniteImpl(IgniteServer node, ServerRestarter restarter, Path configPath, Path workDir, @Nullable ClassLoader serviceProviderClassLoader, Executor asyncContinuationExecutor) {
        DeploymentManagerImpl deploymentManagerImpl;
        this.name = node.name();
        this.workDir = workDir;
        this.longJvmPauseDetector = new LongJvmPauseDetector(this.name);
        this.lifecycleManager = new LifecycleManager(this.name);
        this.vaultMgr = new VaultManager((VaultService)new PersistentVaultService(IgnitePaths.vaultPath(workDir)));
        this.nodeProperties = new NodePropertiesImpl(this.vaultMgr);
        ConfigurationModules modules = IgniteImpl.loadConfigurationModules(serviceProviderClassLoader);
        ConfigurationTreeGenerator localConfigurationGenerator = new ConfigurationTreeGenerator(modules.local().rootKeys(), modules.local().schemaExtensions(), modules.local().polymorphicSchemaExtensions());
        LocalFileConfigurationStorage localFileConfigurationStorage = new LocalFileConfigurationStorage(this.name, configPath, localConfigurationGenerator, modules.local());
        ConfigurationValidatorImpl localConfigurationValidator = ConfigurationValidatorImpl.withDefaultValidators((ConfigurationTreeGenerator)localConfigurationGenerator, (Set)modules.local().validators());
        this.nodeCfgMgr = new ConfigurationManager(modules.local().rootKeys(), (ConfigurationStorage)localFileConfigurationStorage, localConfigurationGenerator, (ConfigurationValidator)localConfigurationValidator, arg_0 -> ((ConfigurationModule)modules.local()).migrateDeprecatedConfigurations(arg_0), KeyIgnorer.fromDeletedPrefixes((Collection)modules.local().deletedPrefixes()));
        try {
            this.lifecycleManager.startComponentsAsync(new ComponentContext(), new IgniteComponent[]{this.nodeCfgMgr});
        }
        catch (NodeStoppingException e) {
            throw new AssertionError(String.format("Unexpected exception: [nodeName=%s, configPath=%s]", this.name, configPath), e);
        }
        LOG.info("Starting node: [name={}, workDir={}, configPath={}]", new Object[]{this.name, workDir, configPath});
        ConfigurationRegistry nodeConfigRegistry = this.nodeCfgMgr.configurationRegistry();
        LOG.info("Local node configuration: {}", new Object[]{IgniteImpl.convertToHoconString(nodeConfigRegistry)});
        NetworkConfiguration networkConfiguration = ((NetworkExtensionConfiguration)nodeConfigRegistry.getConfiguration(NetworkExtensionConfiguration.KEY)).network();
        MessageSerializationRegistry serializationRegistry = IgniteImpl.createSerializationRegistry(serviceProviderClassLoader);
        this.licenseFeatureChecker = new LicenseFeatureCheckerImpl();
        FailureProcessorConfiguration failureProcessorConfiguration = ((FailureProcessorExtensionConfiguration)nodeConfigRegistry.getConfiguration(FailureProcessorExtensionConfiguration.KEY)).failureHandler();
        this.failureManager = new FailureManager(node::shutdown, failureProcessorConfiguration);
        SystemLocalConfiguration systemConfiguration = ((SystemLocalExtensionConfiguration)nodeConfigRegistry.getConfiguration(SystemLocalExtensionConfiguration.KEY)).system();
        this.cmgWorkDir = IgnitePaths.cmgPath(systemConfiguration, workDir);
        this.clusterStateStorage = new RocksDbClusterStateStorage(this.cmgWorkDir.dbPath(), this.name);
        this.clusterIdService = new ClusterIdService(this.vaultMgr);
        this.metricManager = new MetricManagerImpl();
        ThreadPoolsExtensionConfiguration threadPoolsConfiguration = (ThreadPoolsExtensionConfiguration)nodeConfigRegistry.getConfiguration(ThreadPoolsExtensionConfiguration.KEY);
        this.threadPoolsManager = new ThreadPoolsManager(this.name, threadPoolsConfiguration.authentication(), this.metricManager);
        this.criticalWorkerRegistry = new CriticalWorkerWatchdog(systemConfiguration.criticalWorkers(), this.threadPoolsManager.commonScheduler(), this.failureManager);
        this.nettyBootstrapFactory = new NettyBootstrapFactory(networkConfiguration, this.name);
        this.nettyWorkersRegistrar = new NettyWorkersRegistrar((CriticalWorkerRegistry)this.criticalWorkerRegistry, this.threadPoolsManager.commonScheduler(), this.nettyBootstrapFactory, systemConfiguration.criticalWorkers(), this.failureManager);
        DefaultIgniteProductVersionSource versionProvider = new DefaultIgniteProductVersionSource();
        this.clusterSvc = new ScaleCubeClusterServiceFactory().createClusterService(this.name, networkConfiguration, this.nettyBootstrapFactory, serializationRegistry, (StaleIds)new InMemoryStaleIds(), (ClusterIdSupplier)this.clusterIdService, (CriticalWorkerRegistry)this.criticalWorkerRegistry, (FailureProcessor)this.failureManager, ChannelTypeRegistryProvider.loadByServiceLoader((ClassLoader)serviceProviderClassLoader), (IgniteProductVersionSource)versionProvider, this::rollingUpgradeManager);
        this.clock = new HybridClockImpl((FailureProcessor)this.failureManager);
        this.clockWaiter = new ClockWaiter(this.name, this.clock, this.threadPoolsManager.commonScheduler());
        RaftConfiguration raftConfiguration = ((RaftExtensionConfiguration)nodeConfigRegistry.getConfiguration(RaftExtensionConfiguration.KEY)).raft();
        RaftGroupEventsClientListener raftGroupEventsClientListener = new RaftGroupEventsClientListener();
        this.partitionsWorkDir = IgnitePaths.partitionsPath(systemConfiguration, workDir);
        this.partitionsLogStorageFactory = SharedLogStorageFactoryUtils.create((String)this.clusterSvc.nodeName(), (Path)this.partitionsWorkDir.raftLogPath(), (nodeName, path) -> new EncryptedLogStorageFactory("table data log", nodeName, path, this::encryptionManager, ((Boolean)raftConfiguration.fsync().value()).booleanValue()));
        this.metastorageWorkDir = IgnitePaths.metastoragePath(systemConfiguration, workDir);
        this.msLogStorageFactory = SharedLogStorageFactoryUtils.create((String)this.clusterSvc.nodeName(), (Path)this.metastorageWorkDir.raftLogPath(), (nodeName, path) -> new EncryptedLogStorageFactory("meta-storage log", nodeName, path, this::encryptionManager, true));
        this.cmgLogStorageFactory = SharedLogStorageFactoryUtils.create((String)this.clusterSvc.nodeName(), (Path)this.cmgWorkDir.raftLogPath(), (nodeName, path) -> new EncryptedLogStorageFactory("cluster-management-group log", nodeName, path, this::encryptionManager, true));
        RaftGroupOptionsConfigurer cmgRaftConfigurer = RaftGroupOptionsConfigHelper.configureProperties((LogStorageFactory)this.cmgLogStorageFactory, (Path)this.cmgWorkDir.metaPath());
        RaftGroupOptionsConfigurer msRaftConfigurer = RaftGroupOptionsConfigHelper.configureProperties((LogStorageFactory)this.msLogStorageFactory, (Path)this.metastorageWorkDir.metaPath());
        this.partitionRaftConfigurer = RaftGroupOptionsConfigHelper.configureProperties((LogStorageFactory)this.partitionsLogStorageFactory, (Path)this.partitionsWorkDir.metaPath());
        GroupStoragesContextResolver groupStoragesContextResolver = this.createGroupStoragesContextResolver();
        VaultGroupStoragesDestructionIntents groupStoragesDestructionIntents = new VaultGroupStoragesDestructionIntents(this.vaultMgr);
        this.raftMgr = new Loza(this.clusterSvc, this.metricManager, raftConfiguration, this.clock, raftGroupEventsClientListener, this.failureManager, (GroupStoragesDestructionIntents)groupStoragesDestructionIntents, groupStoragesContextResolver);
        JumpToExecutorByConsistentIdAfterSend messagingServiceReturningToStorageOperationsPool = new JumpToExecutorByConsistentIdAfterSend(this.clusterSvc.messagingService(), this.name, message -> this.threadPoolsManager.partitionOperationsExecutor());
        LogicalTopologyImpl logicalTopology = new LogicalTopologyImpl(this.clusterStateStorage, (FailureProcessor)this.failureManager);
        logicalTopology.addEventListener(IgniteImpl.logicalTopologyJoinedNodesListener((JoinedNodes)this.clusterSvc.topologyService()));
        ConfigurationTreeGenerator distributedConfigurationGenerator = new ConfigurationTreeGenerator(modules.distributed().rootKeys(), modules.distributed().schemaExtensions(), modules.distributed().polymorphicSchemaExtensions());
        HashSet<HasLicenseFeatureValidator> clusterCfgValidators = new HashSet<HasLicenseFeatureValidator>(modules.distributed().validators());
        HasLicenseFeatureValidator hasLicenseFeatureValidator = new HasLicenseFeatureValidator((LicenseFeatureChecker)this.licenseFeatureChecker);
        clusterCfgValidators.add(hasLicenseFeatureValidator);
        ConfigurationValidatorImpl distributedCfgValidator = ConfigurationValidatorImpl.withDefaultValidators((ConfigurationTreeGenerator)distributedConfigurationGenerator, clusterCfgValidators);
        ConfigurationDynamicDefaultsPatcherImpl clusterCfgDynamicDefaultsPatcher = new ConfigurationDynamicDefaultsPatcherImpl(modules.distributed(), distributedConfigurationGenerator);
        this.clusterInitializer = new ClusterInitializer(this.clusterSvc, (ConfigurationDynamicDefaultsPatcher)clusterCfgDynamicDefaultsPatcher, (ConfigurationValidator)distributedCfgValidator, (NodeProperties)this.nodeProperties);
        NodeAttributesCollector nodeAttributesCollector = new NodeAttributesCollector(((NodeAttributesExtensionConfiguration)nodeConfigRegistry.getConfiguration(NodeAttributesExtensionConfiguration.KEY)).nodeAttributes(), ((StorageExtensionConfiguration)nodeConfigRegistry.getConfiguration(StorageExtensionConfiguration.KEY)).storage());
        nodeAttributesCollector.register((NodeAttributesProvider)this.nodeProperties);
        ClusterStateStorageManager clusterStateStorageMgr = new ClusterStateStorageManager(this.clusterStateStorage);
        LicenseValidationManager validationManager = new LicenseValidationManager(clusterStateStorageMgr, (LogicalTopology)logicalTopology, this::fireEvent);
        SystemDisasterRecoveryStorage systemDisasterRecoveryStorage = new SystemDisasterRecoveryStorage(this.vaultMgr);
        this.cmgMgr = new ClusterManagementGroupManager(this.vaultMgr, (ClusterResetStorage)systemDisasterRecoveryStorage, this.clusterSvc, this.clusterInitializer, (RaftManager)this.raftMgr, clusterStateStorageMgr, (LogicalTopology)logicalTopology, (ValidationManager)validationManager, (NodeAttributes)nodeAttributesCollector, (FailureProcessor)this.failureManager, (ClusterIdStore)this.clusterIdService, cmgRaftConfigurer, this.metricManager, (NodeProperties)this.nodeProperties, node::shutdown);
        this.logicalTopologyService = new LogicalTopologyServiceImpl((LogicalTopology)logicalTopology, this.cmgMgr);
        TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory = new TopologyAwareRaftGroupServiceFactory(this.clusterSvc, this.logicalTopologyService, Loza.FACTORY, raftGroupEventsClientListener);
        ReadOperationForCompactionTracker readOperationForCompactionTracker = new ReadOperationForCompactionTracker();
        EncryptedRocksDbKeyValueStorage storage = new EncryptedRocksDbKeyValueStorage(this.name, this.metastorageWorkDir.dbPath(), this.failureManager, readOperationForCompactionTracker, this.threadPoolsManager.commonScheduler(), this::encryptionManager);
        this.metaStorageMgr = new MetaStorageManagerImpl(this.clusterSvc, this.cmgMgr, this.logicalTopologyService, (RaftManager)this.raftMgr, (KeyValueStorage)storage, this.clock, topologyAwareRaftGroupServiceFactory, this.metricManager, (MetastorageRepairStorage)systemDisasterRecoveryStorage, (MetastorageRepair)new MetastorageRepairImpl(this.clusterSvc.messagingService(), (LogicalTopology)logicalTopology, this.cmgMgr), msRaftConfigurer, readOperationForCompactionTracker, (Executor)this.threadPoolsManager.tableIoExecutor(), (FailureProcessor)this.failureManager);
        this.cfgStorage = new DistributedConfigurationStorage(this.name, (MetaStorageManager)this.metaStorageMgr);
        this.clusterCfgMgr = new ConfigurationManager(modules.distributed().rootKeys(), this.cfgStorage, distributedConfigurationGenerator, (ConfigurationValidator)distributedCfgValidator, arg_0 -> ((ConfigurationModule)modules.distributed()).migrateDeprecatedConfigurations(arg_0), KeyIgnorer.fromDeletedPrefixes((Collection)modules.local().deletedPrefixes()));
        ConfigurationRegistry clusterConfigRegistry = this.clusterCfgMgr.configurationRegistry();
        this.cmgMgr.setClusterConfigurationRegistry(clusterConfigRegistry);
        SecurityConfiguration securityConfiguration = ((SecurityExtensionConfiguration)clusterConfigRegistry.getConfiguration(SecurityExtensionConfiguration.KEY)).security();
        this.eventLog = new EventLogImpl(((EventLogExtensionConfiguration)clusterConfigRegistry.getConfiguration(EventLogExtensionConfiguration.KEY)).eventlog(), () -> this.clusterState().clusterTag().clusterId(), this.name);
        this.rbac = new Rbac((Executor)this.threadPoolsManager.authenticationExecutor(), securityConfiguration, (EventLog)this.eventLog);
        SystemDistributedConfiguration systemDistributedConfiguration = ((SystemDistributedExtensionConfiguration)clusterConfigRegistry.getConfiguration(SystemDistributedExtensionConfiguration.KEY)).system();
        this.metaStorageMgr.configure(systemDistributedConfiguration);
        this.systemDisasterRecoveryManager = new SystemDisasterRecoveryManagerImpl(this.name, this.clusterSvc.topologyService(), this.clusterSvc.messagingService(), this.vaultMgr, restarter, (MetastorageGroupMaintenance)this.metaStorageMgr, this.cmgMgr, (ClusterIdSupplier)this.clusterIdService);
        this.metaStorageCompactionTrigger = new MetaStorageCompactionTrigger(this.name, (KeyValueStorage)storage, this.metaStorageMgr, (FailureProcessor)this.failureManager, readOperationForCompactionTracker, systemDistributedConfiguration);
        SchemaSynchronizationConfiguration schemaSyncConfig = ((SchemaSynchronizationExtensionConfiguration)clusterConfigRegistry.getConfiguration(SchemaSynchronizationExtensionConfiguration.KEY)).schemaSync();
        this.clockServiceMetricSource = new ClockServiceMetricSource();
        this.clockService = new ClockServiceImpl(this.clock, this.clockWaiter, () -> (Long)schemaSyncConfig.maxClockSkewMillis().value(), arg_0 -> ((ClockServiceMetricSource)this.clockServiceMetricSource).onMaxClockSkewExceeded(arg_0));
        this.idempotentCacheVacuumizer = new IdempotentCacheVacuumizer(this.name, this.threadPoolsManager.commonScheduler(), arg_0 -> ((MetaStorageManagerImpl)this.metaStorageMgr).evictIdempotentCommandsCache(arg_0), raftConfiguration.retryTimeoutMillis(), this.clockService, (FailureProcessor)this.failureManager, 1L, 1L, TimeUnit.MINUTES);
        this.metaStorageMgr.addElectionListener((ElectionListener)this.idempotentCacheVacuumizer);
        MetaStorageRevisionListenerRegistry registry = new MetaStorageRevisionListenerRegistry((MetaStorageManager)this.metaStorageMgr);
        LongSupplier delayDurationMsSupplier = IgniteImpl.delayDurationMsSupplier(schemaSyncConfig);
        CatalogManagerImpl catalogManager = new CatalogManagerImpl((UpdateLog)new UpdateLogImpl((MetaStorageManager)this.metaStorageMgr, (FailureProcessor)this.failureManager), this.clockService, (FailureProcessor)this.failureManager, delayDurationMsSupplier, () -> this.unsecuredRollingUpgradeManager().isUpgradeInProgress());
        ReplicationConfiguration replicationConfig = ((ReplicationExtensionConfiguration)clusterConfigRegistry.getConfiguration(ReplicationExtensionConfiguration.KEY)).replication();
        this.placementDriverMgr = new PlacementDriverManager(this.name, (MetaStorageManager)this.metaStorageMgr, (ReplicationGroupId)MetastorageGroupId.INSTANCE, this.clusterSvc, () -> ((ClusterManagementGroupManager)this.cmgMgr).metaStorageNodes(), this.logicalTopologyService, (RaftManager)this.raftMgr, topologyAwareRaftGroupServiceFactory, this.clockService, (FailureProcessor)this.failureManager, (NodeProperties)this.nodeProperties, replicationConfig, (Executor)this.threadPoolsManager.commonScheduler(), this.metricManager, zoneId -> this.distributionZoneManager().currentDataNodes(zoneId.intValue()), tableId -> {
            CatalogTableDescriptor table = catalogManager.activeCatalog(this.clock.now().longValue()).table(tableId.intValue());
            return table == null ? null : Integer.valueOf(table.zoneId());
        });
        TransactionConfiguration txConfig = ((TransactionExtensionConfiguration)clusterConfigRegistry.getConfiguration(TransactionExtensionConfiguration.KEY)).transaction();
        ReplicaService replicaSvc = new ReplicaService((MessagingService)messagingServiceReturningToStorageOperationsPool, this.clockService, (Executor)this.threadPoolsManager.partitionOperationsExecutor(), replicationConfig, this.threadPoolsManager.commonScheduler());
        LongSupplier partitionIdleSafeTimePropagationPeriodMsSupplier = IgniteImpl.partitionIdleSafeTimePropagationPeriodMsSupplier(replicationConfig);
        ThreadLocalPartitionCommandsMarshaller raftMarshaller = new ThreadLocalPartitionCommandsMarshaller(this.clusterSvc.serializationRegistry());
        this.volatileLogStorageFactoryCreator = new VolatileLogStorageFactoryCreator(this.name, workDir.resolve("volatile-log-spillout"));
        this.replicaMgr = new ReplicaManager(this.name, this.clusterSvc, this.cmgMgr, this.clockService, Set.of(PartitionReplicationMessageGroup.class, TxMessageGroup.class), this.placementDriverMgr.placementDriver(), (Executor)this.threadPoolsManager.partitionOperationsExecutor(), partitionIdleSafeTimePropagationPeriodMsSupplier, (FailureProcessor)this.failureManager, (Marshaller)raftMarshaller, topologyAwareRaftGroupServiceFactory, (RaftManager)this.raftMgr, this.partitionRaftConfigurer, (LogStorageFactoryCreator)this.volatileLogStorageFactoryCreator, (Executor)this.threadPoolsManager.tableIoExecutor(), replicaGrpId -> this.metaStorageMgr.get(RebalanceUtil.pendingPartAssignmentsQueueKey((TablePartitionId)((TablePartitionId)replicaGrpId))).thenApply(entry -> new VersionedAssignments(entry.value(), entry.revision())), (Executor)this.threadPoolsManager.commonScheduler());
        this.metricManager.configure(((MetricExtensionConfiguration)clusterConfigRegistry.getConfiguration(MetricExtensionConfiguration.KEY)).metrics(), () -> this.clusterState().clusterTag().clusterId(), this.name);
        DataStorageModules dataStorageModules = new DataStorageModules(ServiceLoader.load(DataStorageModule.class, serviceProviderClassLoader), ServiceLoader.load(SecondaryStorageModule.class, serviceProviderClassLoader));
        Path storagePath = this.partitionsWorkDir.dbPath();
        Path secondaryStoragePath = IgniteImpl.createPartitionsStoreDirectory(IgnitePaths.secondaryStoragePath(workDir));
        GcConfiguration gcConfig = ((GcExtensionConfiguration)clusterConfigRegistry.getConfiguration(GcExtensionConfiguration.KEY)).gc();
        this.encryptionManager = this.createEncryptionManager();
        this.encryptionConfigurationVault = new EncryptionConfigurationVault((EncryptionManagerImpl)this.encryptionManager, this.vaultMgr, () -> ((ConfigurationTreeGenerator)distributedConfigurationGenerator).createSuperRoot(), this.cmgMgr, new IgniteComponent(){

            public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
                return IgniteUtils.startAsync((ComponentContext)componentContext, (IgniteComponent[])new IgniteComponent[]{IgniteImpl.this.cmgLogStorageFactory, IgniteImpl.this.msLogStorageFactory, IgniteImpl.this.partitionsLogStorageFactory});
            }

            public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
                return IgniteUtils.stopAsync((ComponentContext)componentContext, (IgniteComponent[])new IgniteComponent[]{IgniteImpl.this.partitionsLogStorageFactory, IgniteImpl.this.msLogStorageFactory, IgniteImpl.this.cmgLogStorageFactory});
            }
        }, (Executor)this.threadPoolsManager.tableIoExecutor(), ((EncryptionExtensionConfiguration)clusterConfigRegistry.getConfiguration(EncryptionExtensionConfiguration.KEY)).encryption());
        StorageConfiguration storageConfiguration = ((StorageExtensionConfiguration)nodeConfigRegistry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        Map storageEngines = dataStorageModules.createStorageEngines(this.name, this.metricManager, nodeConfigRegistry, storagePath, this.longJvmPauseDetector, this.failureManager, this.vaultMgr, this.encryptionManager, (LogSyncer)this.partitionsLogStorageFactory, this.clock, this.threadPoolsManager.commonScheduler());
        Map secondaryStorageEngines = dataStorageModules.createSecondaryStorageEngines(this.name, nodeConfigRegistry, secondaryStoragePath);
        this.dataStorageMgr = new DataStorageManager(IgniteImpl.applyThreadAssertionsIfNeeded(storageEngines), IgniteImpl.applyThreadAssertionsToSecondariesIfNeeded(secondaryStorageEngines), storageConfiguration, (LicenseFeatureChecker)this.licenseFeatureChecker);
        this.outgoingSnapshotsManager = new OutgoingSnapshotsManager(this.name, this.clusterSvc.messagingService(), (FailureProcessor)this.failureManager);
        this.systemViewManager = new SystemViewManagerImpl(this.name, (CatalogManager)catalogManager, (FailureProcessor)this.failureManager);
        nodeAttributesCollector.register((NodeAttributesProvider)this.systemViewManager);
        logicalTopology.addEventListener((LogicalTopologyEventListener)this.systemViewManager);
        this.systemViewManager.register((SystemViewProvider)catalogManager);
        this.catalogManager = catalogManager;
        this.lowWatermark = new LowWatermarkImpl(this.name, gcConfig.lowWatermark(), this.clockService, this.vaultMgr, this.failureManager, this.clusterSvc.messagingService());
        this.indexMetaStorage = new IndexMetaStorage((CatalogService)catalogManager, (LowWatermark)this.lowWatermark, (MetaStorageManager)this.metaStorageMgr);
        this.raftMgr.appendEntriesRequestInterceptor((AppendEntriesRequestInterceptor)new CheckCatalogVersionOnAppendEntries((CatalogService)catalogManager));
        this.raftMgr.actionRequestInterceptor((ActionRequestInterceptor)new CheckCatalogVersionOnActionRequest((CatalogService)catalogManager));
        this.schemaSafeTimeTracker = new SchemaSafeTimeTrackerImpl(this.metaStorageMgr.clusterTime());
        this.metaStorageMgr.registerNotificationEnqueuedListener((NotificationEnqueuedListener)this.schemaSafeTimeTracker);
        SchemaSyncServiceImpl schemaSyncService = new SchemaSyncServiceImpl((SchemaSafeTimeTracker)this.schemaSafeTimeTracker, delayDurationMsSupplier);
        this.schemaManager = new SchemaManager((RevisionListenerRegistry)registry, (CatalogService)catalogManager);
        this.distributionZoneManager = new DistributionZoneManager(this.name, () -> this.clusterSvc.topologyService().localMember().id(), (RevisionListenerRegistry)registry, (MetaStorageManager)this.metaStorageMgr, this.logicalTopologyService, (FailureProcessor)this.failureManager, (CatalogManager)catalogManager, systemDistributedConfiguration, this.clockService, (NodeProperties)this.nodeProperties, this.metricManager);
        this.indexNodeFinishedRwTransactionsChecker = new IndexNodeFinishedRwTransactionsChecker((CatalogService)catalogManager, this.clusterSvc.messagingService(), this.clock);
        MinimumRequiredTimeCollectorServiceImpl minTimeCollectorService = new MinimumRequiredTimeCollectorServiceImpl();
        CatalogCompactionRunner catalogCompactionRunner = new CatalogCompactionRunner(this.name, catalogManager, this.clusterSvc.messagingService(), this.logicalTopologyService, this.placementDriverMgr.placementDriver(), replicaSvc, this.clockService, (SchemaSyncService)schemaSyncService, this.clusterSvc.topologyService(), (NodeProperties)this.nodeProperties, (ActiveLocalTxMinimumRequiredTimeProvider)this.indexNodeFinishedRwTransactionsChecker, (MinimumRequiredTimeCollectorService)minTimeCollectorService, (RebalanceMinimumRequiredTimeProvider)new RebalanceMinimumRequiredTimeProviderImpl((MetaStorageManager)this.metaStorageMgr, (CatalogService)catalogManager), () -> this.unsecuredRollingUpgradeManager().isUpgradeInProgress());
        this.metaStorageMgr.addElectionListener(arg_0 -> ((CatalogCompactionRunner)catalogCompactionRunner).updateCoordinator(arg_0));
        this.catalogCompactionRunner = catalogCompactionRunner;
        this.killCommandHandler = new KillCommandHandler(this.name, this.logicalTopologyService, this.clusterSvc.messagingService());
        this.lowWatermark.listen((org.apache.ignite.internal.event.Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, params -> catalogCompactionRunner.onLowWatermarkChanged(((ChangeLowWatermarkEventParameters)params).newLowWatermark()));
        this.resourcesRegistry = new RemotelyTriggeredResourceRegistry();
        TransactionInflights transactionInflights = new TransactionInflights(this.placementDriverMgr.placementDriver(), this.clockService);
        HeapLockManager lockMgr = new HeapLockManager(systemConfiguration);
        this.txManager = new TxManagerImpl(this.name, txConfig, systemDistributedConfiguration, (MessagingService)messagingServiceReturningToStorageOperationsPool, this.clusterSvc.topologyService(), replicaSvc, (LockManager)lockMgr, this.clockService, new TransactionIdGenerator(() -> this.clusterSvc.nodeName().hashCode()), this.placementDriverMgr.placementDriver(), partitionIdleSafeTimePropagationPeriodMsSupplier, (LocalRwTxCounter)this.indexNodeFinishedRwTransactionsChecker, (Executor)this.threadPoolsManager.partitionOperationsExecutor(), this.resourcesRegistry, transactionInflights, (LowWatermark)this.lowWatermark, this.threadPoolsManager.commonScheduler(), (FailureProcessor)this.failureManager, (NodeProperties)this.nodeProperties, this.metricManager);
        this.sharedTxStateStorage = new TxStateRocksDbSharedStorage(this.name, storagePath.resolve(TX_STATE_DIR), this.threadPoolsManager.commonScheduler(), this.threadPoolsManager.tableIoExecutor(), (LogSyncer)this.partitionsLogStorageFactory, (FailureProcessor)this.failureManager);
        this.partitionReplicaLifecycleManager = new PartitionReplicaLifecycleManager((CatalogService)catalogManager, this.replicaMgr, this.distributionZoneManager, (MetaStorageManager)this.metaStorageMgr, this.clusterSvc.topologyService(), (LowWatermark)this.lowWatermark, (FailureProcessor)this.failureManager, (NodeProperties)this.nodeProperties, this.threadPoolsManager.tableIoExecutor(), this.threadPoolsManager.rebalanceScheduler(), (Executor)this.threadPoolsManager.partitionOperationsExecutor(), this.clockService, this.placementDriverMgr.placementDriver(), (SchemaSyncService)schemaSyncService, systemDistributedConfiguration, this.sharedTxStateStorage, (TxManager)this.txManager, this.schemaManager, this.dataStorageMgr, this.outgoingSnapshotsManager);
        this.systemViewManager.register((SystemViewProvider)this.txManager);
        this.killCommandHandler.register(IgniteImpl.transactionKillHandler((TxManager)this.txManager));
        this.resourceVacuumManager = new ResourceVacuumManager(this.name, this.resourcesRegistry, this.clusterSvc.topologyService(), (MessagingService)messagingServiceReturningToStorageOperationsPool, transactionInflights, (TxManager)this.txManager, (LowWatermark)this.lowWatermark, (FailureProcessor)this.failureManager, this.metricManager);
        TableConfiguration tableConfiguration = ((TableExtensionConfiguration)nodeConfigRegistry.getConfiguration(TableExtensionConfiguration.KEY)).table();
        PartitionModificationCounterFactory partitionModificationCounterFactory = new PartitionModificationCounterFactory(() -> ((ClockService)this.clockService).current());
        this.distributedTblMgr = new TableManager(this.name, (RevisionListenerRegistry)registry, gcConfig, txConfig, replicationConfig, (MessagingService)messagingServiceReturningToStorageOperationsPool, this.clusterSvc.topologyService(), this.clusterSvc.serializationRegistry(), this.replicaMgr, (LockManager)lockMgr, replicaSvc, (TxManager)this.txManager, this.dataStorageMgr, storagePath, this.sharedTxStateStorage, (MetaStorageManager)this.metaStorageMgr, this.schemaManager, this.threadPoolsManager.tableIoExecutor(), (Executor)this.threadPoolsManager.partitionOperationsExecutor(), this.threadPoolsManager.rebalanceScheduler(), this.threadPoolsManager.commonScheduler(), this.clockService, this.outgoingSnapshotsManager, this.distributionZoneManager, (SchemaSyncService)schemaSyncService, (CatalogService)catalogManager, (FailureProcessor)this.failureManager, this.observableTimestampTracker, this.placementDriverMgr.placementDriver(), this::bareSql, this.resourcesRegistry, tableConfiguration.expiration(), (LowWatermark)this.lowWatermark, transactionInflights, this.indexMetaStorage, this.encryptionManager, (LogSyncer)this.partitionsLogStorageFactory, this.partitionReplicaLifecycleManager, (NodeProperties)this.nodeProperties, (MinimumRequiredTimeCollectorService)minTimeCollectorService, systemDistributedConfiguration, this.metricManager, (LicenseFeatureChecker)this.licenseFeatureChecker, partitionModificationCounterFactory, this.cmgMgr);
        ClusterSnapshotConfiguration clusterSnapshotConfiguration = ((ClusterSnapshotExtensionConfiguration)clusterConfigRegistry.getConfiguration(ClusterSnapshotExtensionConfiguration.KEY)).snapshot();
        NodeSnapshotConfiguration nodeSnapshotConfiguration = ((NodeSnapshotExtensionConfiguration)nodeConfigRegistry.getConfiguration(NodeSnapshotExtensionConfiguration.KEY)).snapshot();
        this.snapshotTombstoneManager = new SnapshotTombstoneManager(clusterSnapshotConfiguration, this.distributedTblMgr, this.threadPoolsManager.commonScheduler(), this.threadPoolsManager.partitionOperationsExecutor(), this.vaultMgr, this.clock, (FailureProcessor)this.failureManager);
        PrimaryReplicaProvider primaryReplicaProvider = new PrimaryReplicaProvider(this.placementDriverMgr.placementDriver(), this.clusterSvc.topologyService(), (NodeProperties)this.nodeProperties);
        EvictionTaskFactory evictionTaskFactory = new EvictionTaskFactory(this.threadPoolsManager.commonScheduler(), (LowWatermark)this.lowWatermark, gcConfig.lowWatermark(), this.clockService, (CatalogManager)catalogManager, this.distributedTblMgr, this.schemaManager, primaryReplicaProvider, (FailureProcessor)this.failureManager, (NodeProperties)this.nodeProperties);
        this.evictionManager = new EvictionManager(this.name, tableConfiguration.eviction(), (VolatilePageMemoryStorageEngine)storageEngines.get("aimem"), this.threadPoolsManager.partitionOperationsExecutor(), this.threadPoolsManager.commonScheduler(), evictionTaskFactory, (LicenseFeatureChecker)this.licenseFeatureChecker, (FailureProcessor)this.failureManager);
        Authorizer authorizer = this.rbac.authorizer();
        this.disasterRecoveryManager = new AuthorizedDisasterRecoveryManager(this.threadPoolsManager.tableIoExecutor(), (MessagingService)messagingServiceReturningToStorageOperationsPool, (MetaStorageManager)this.metaStorageMgr, (CatalogManager)catalogManager, this.distributionZoneManager, this.raftMgr, this.clusterSvc.topologyService(), this.distributedTblMgr, this.metricManager, authorizer, this.failureManager, this.partitionReplicaLifecycleManager, (NodeProperties)this.nodeProperties, (SystemViewManager)this.systemViewManager, this.cmgMgr);
        this.indexManager = new IndexManager(this.schemaManager, this.distributedTblMgr, (CatalogService)catalogManager, this.threadPoolsManager.tableIoExecutor(), (RevisionListenerRegistry)registry, (LowWatermark)this.lowWatermark);
        this.indexBuildingManager = new IndexBuildingManager(this.name, replicaSvc, (CatalogManager)catalogManager, (MetaStorageManager)this.metaStorageMgr, this.indexManager, this.indexMetaStorage, this.placementDriverMgr.placementDriver(), this.clusterSvc, this.logicalTopologyService, this.clockService, (FailureProcessor)this.failureManager, (NodeProperties)this.nodeProperties, (LowWatermark)this.lowWatermark, (TxManager)this.txManager);
        this.qryEngine = new SqlQueryProcessor(this.clusterSvc, this.logicalTopologyService, this.distributedTblMgr, this.schemaManager, this.dataStorageMgr, replicaSvc, this.clockService, (SchemaSyncService)schemaSyncService, (CatalogManager)catalogManager, this.metricManager, (SystemViewManager)this.systemViewManager, this.failureManager, this.placementDriverMgr.placementDriver(), ((SqlClusterExtensionConfiguration)clusterConfigRegistry.getConfiguration(SqlClusterExtensionConfiguration.KEY)).sql(), ((SqlNodeExtensionConfiguration)nodeConfigRegistry.getConfiguration(SqlNodeExtensionConfiguration.KEY)).sql(), transactionInflights, (TxManager)this.txManager, (NodeProperties)this.nodeProperties, (LowWatermark)this.lowWatermark, this.threadPoolsManager.commonScheduler(), this.killCommandHandler, (EventLog)this.eventLog, this.rbac, (LicenseFeatureChecker)this.licenseFeatureChecker, this.distributionZoneManager, workDir);
        this.systemViewManager.register((SystemViewProvider)this.qryEngine);
        this.sql = new IgniteSqlImpl((QueryProcessor)this.qryEngine, this.observableTimestampTracker, (Executor)this.threadPoolsManager.commonScheduler());
        this.sqlWithSystemContext = new SecuredIgniteSql((IgniteSql)this.sql, GridGainSecurity.systemContext());
        ComputeConfiguration computeCfg = ((ComputeExtensionConfiguration)nodeConfigRegistry.getConfiguration(ComputeExtensionConfiguration.KEY)).compute();
        InMemoryComputeStateMachine stateMachine = new InMemoryComputeStateMachine(computeCfg, this.name);
        ComputeExecutorImpl computeExecutor = new ComputeExecutorImpl((Ignite)this, this::createSecuredIgnite, (ComputeStateMachine)stateMachine, computeCfg, this.clusterSvc.topologyService(), this.clockService, (EventLog)this.eventLog);
        this.deploymentManager = deploymentManagerImpl = new DeploymentManagerImpl(this.clusterSvc, (DeploymentUnitStore)new DeploymentUnitStoreImpl((MetaStorageManager)this.metaStorageMgr), this.logicalTopologyService, workDir, ((DeploymentExtensionConfiguration)nodeConfigRegistry.getConfiguration(DeploymentExtensionConfiguration.KEY)).deployment(), this.cmgMgr, authorizer, this.name, arg_0 -> ((ComputeExecutorImpl)computeExecutor).onUnitRemoving(arg_0));
        this.computeComponent = new ComputeComponentImpl(this.name, this.clusterSvc.messagingService(), this.clusterSvc.topologyService(), this.logicalTopologyService, new JobContextManager((IgniteDeployment)deploymentManagerImpl, deploymentManagerImpl.deploymentUnitAccessor(), new JobClassLoaderFactory()), (ComputeExecutor)computeExecutor, computeCfg, (EventLog)this.eventLog);
        this.systemViewManager.register((SystemViewProvider)this.computeComponent);
        this.compute = new LicensedIgniteCompute((IgniteComputeInternal)new IgniteComputeImpl(this.name, this.placementDriverMgr.placementDriver(), this.clusterSvc.topologyService(), (IgniteTablesInternal)this.distributedTblMgr, (ComputeComponent)this.computeComponent, this.clock, (NodeProperties)this.nodeProperties, this.observableTimestampTracker, authorizer), (LicenseFeatureChecker)this.licenseFeatureChecker);
        this.killCommandHandler.register(IgniteImpl.computeKillHandler(this.compute));
        this.authenticationManager = this.createAuthenticationManager();
        ClientConnectorConfiguration clientConnectorConfiguration = ((ClientConnectorExtensionConfiguration)nodeConfigRegistry.getConfiguration(ClientConnectorExtensionConfiguration.KEY)).clientConnector();
        this.publicSql = new PublicApiThreadingIgniteSql(this.bareSql(), asyncContinuationExecutor);
        this.igniteStructures = new GridgainStructuresComponent((CatalogManager)catalogManager, (IgniteTablesInternal)this.distributedTblMgr, this.publicSql, this.schemaManager);
        this.clientHandlerModule = new ClientHandlerModule((QueryProcessor)this.qryEngine, (IgniteTablesInternal)new InternalTablesWrapper((IgniteTablesInternal)this.distributedTblMgr, authorizer), (TxManager)this.txManager, this.compute, this.clusterSvc, this.nettyBootstrapFactory, () -> {
            ClusterState localClusterState = this.clusterState();
            return new ClusterInfo(localClusterState.clusterTag(), localClusterState.clusterIdHistory());
        }, this.metricManager, new ClientHandlerMetricSource(), (AuthenticationManager)this.authenticationManager, this.clockService, (SchemaSyncService)schemaSyncService, (CatalogService)catalogManager, this.placementDriverMgr.placementDriver(), clientConnectorConfiguration, (LowWatermark)this.lowWatermark, (NodeProperties)this.nodeProperties, (Executor)this.threadPoolsManager.partitionOperationsExecutor(), authorizer, this.igniteStructures);
        computeExecutor.setPlatformComputeTransport((PlatformComputeTransport)this.clientHandlerModule);
        this.metricMessaging = new MetricMessaging(this.metricManager, this.clusterSvc.messagingService(), this.clusterSvc.topologyService());
        this.systemPropertiesComponent = new SystemPropertiesComponent(systemDistributedConfiguration);
        this.restComponent = this.createRestComponent(this.name);
        this.publicTables = new PublicApiThreadingIgniteTables((IgniteTables)this.distributedTblMgr, asyncContinuationExecutor);
        this.publicTransactions = new PublicApiThreadingIgniteTransactions((IgniteTransactions)new IgniteTransactionsImpl((TxManager)this.txManager, this.observableTimestampTracker, (LicenseFeatureChecker)this.licenseFeatureChecker), asyncContinuationExecutor);
        this.publicCompute = new AntiHijackIgniteCompute((IgniteCompute)new SecuredIgniteCompute((IgniteCompute)this.compute, GridGainSecurity.systemContext()), asyncContinuationExecutor);
        IgniteCatalogSqlImpl catalog = new IgniteCatalogSqlImpl(this.bareSql(), (IgniteTables)this.distributedTblMgr, (IgniteCaches)this.distributedTblMgr);
        this.publicCatalog = new PublicApiThreadingIgniteCatalog((IgniteCatalog)catalog, asyncContinuationExecutor);
        this.publicCaches = new PublicApiThreadingIgniteCaches((IgniteCaches)this.distributedTblMgr, asyncContinuationExecutor);
        this.publicCluster = new PublicApiThreadingIgniteCluster((IgniteCluster)new IgniteClusterImpl(this.clusterSvc.topologyService(), (ClusterIdSupplier)this.clusterIdService));
        DataEncryptionKeyManagerImpl dataEncryptionKeyManager = new DataEncryptionKeyManagerImpl(KeyStorage.NoopKeyStorage.INSTANCE, this.encryptionManager, (FailureProcessor)this.failureManager);
        this.snapshotFileSystemManager = new SnapshotFileSystemManagerImpl(clusterSnapshotConfiguration, workDir, this.name, this.encryptionManager, (DataEncryptionKeyManager)dataEncryptionKeyManager, (ByteBufferPoolProvider)new SnapshotBufferManager(nodeSnapshotConfiguration));
        this.snapshotManager = this.createSnapshotManager(nodeSnapshotConfiguration, (SchemaSyncService)schemaSyncService, replicationConfig, (DataEncryptionKeyManager)dataEncryptionKeyManager, systemConfiguration, this.clockService);
        PrivateKeyStore privateKeyStore = new PrivateKeyStore(this.vaultMgr);
        PublicKeyStore publicKeyStore = new PublicKeyStore((MetaStorageManager)this.metaStorageMgr);
        this.nodeKeyManager = new NodeKeyManagerImpl(this.name, privateKeyStore, publicKeyStore, securityConfiguration);
        this.jwtTokenManager = new JwtTokenManager(this.clusterNameProvider(), () -> this.name, securityConfiguration.jwt(), this.nodeKeyManager, (MetaStorageManager)this.metaStorageMgr, authorizer, (EventProducer)this.authenticationManager);
        this.dcrManager = new LicensedDcrManager((DcrManager)new DcrManagerImpl(this.name, this.clusterNameFuture(), (IgniteTables)this.distributedTblMgr, (MetaStorageManager)this.metaStorageMgr, this.logicalTopologyService, this.clusterSvc.messagingService(), this.clusterSvc.topologyService(), this.metricManager, this.clockService), (LicenseFeatureChecker)this.licenseFeatureChecker);
        this.snapshotFacade = new SecuredSnapshotFacade((SnapshotFacade)new SnapshotFacadeImpl(this.clusterSvc, this.metaStorageMgr, this.encryptionManager), (LicenseFeatureChecker)this.licenseFeatureChecker, authorizer);
        this.pitrManager = new PitrManager(((NodePitrExtensionConfiguration)nodeConfigRegistry.getConfiguration(NodePitrExtensionConfiguration.KEY)).pitr(), this.clusterSvc, this.metaStorageMgr, (CatalogManager)catalogManager, this.distributedTblMgr, (TxManager)this.txManager, this.distributionZoneManager, this.logicalTopologyService, this.clock, replicationConfig, this.replicaMgr, this.partitionReplicaLifecycleManager, (NodeProperties)this.nodeProperties);
        this.unsecuredRollingUpgradeManager = new RollingUpgradeManagerImpl(this.clusterSvc.messagingService(), this.clusterSvc.topologyService(), this.cmgMgr, (IgniteProductVersionSource)versionProvider, clusterConfigRegistry);
        this.rollingUpgradeManager = new SecuredRollingUpgradeManager(authorizer, this.unsecuredRollingUpgradeManager);
        ClusterStopper clusterStopper = new ClusterStopper(this.clusterSvc, this.threadPoolsManager.commonScheduler(), node::shutdown);
        LicenseAttributesCollector licenseAttributesCollector = new LicenseAttributesCollector(storageConfiguration, (PersistentPageMemoryStorageEngine)storageEngines.get("aipersist"), ManagementFactory.getMemoryMXBean(), ManagementFactory.getOperatingSystemMXBean());
        nodeAttributesCollector.register((NodeAttributesProvider)licenseAttributesCollector);
        LicenseConfiguration licenseConfiguration = ((LicenseExtensionConfiguration)clusterConfigRegistry.getConfiguration(LicenseExtensionConfiguration.KEY)).license();
        LicenseProviderFactory licenseProviderFactory = new LicenseProviderFactory(configPath);
        this.licenseManager = new GridLicenseManager(licenseConfiguration, this.cmgMgr, (LogicalTopology)logicalTopology, clusterStopper, this.threadPoolsManager.commonScheduler(), this.metricManager, this::fireEvent, licenseProviderFactory);
        this.licenseManager.listen((org.apache.ignite.internal.event.Event)LicenseEvent.LICENSE_APPLIED, (EventListener)validationManager);
        this.licenseManager.listen((org.apache.ignite.internal.event.Event)LicenseEvent.LICENSE_APPLIED, (EventListener)this.licenseFeatureChecker);
        this.listenLicenseSecurityFeature();
        this.systemViewManager.register((SystemViewProvider)this.licenseManager);
        this.cdcManager = new LicensedCdcManager((LicenseFeatureChecker)this.licenseFeatureChecker, (CdcManager)new SecuredCdcManager(authorizer, (CdcManager)new CdcManagerImpl(this.name, this.publicTables, this.publicTransactions, (CatalogManager)catalogManager, sinkDefinition -> {
            switch (sinkDefinition.type()) {
                case ICEBERG: {
                    return new IcebergTableSink();
                }
                case GRIDGAIN_8: {
                    return new GridGain8SinkAdapter();
                }
            }
            throw new IgniteInternalException(UUID.randomUUID(), GridgainErrorGroups.Cdc.CDC_SINK_INIT_ERR, "Unsupported sink type: " + sinkDefinition.type());
        }, sinkDefinition -> {
            switch (sinkDefinition.type()) {
                case ICEBERG: {
                    return new IcebergTableSinkValidator();
                }
                case GRIDGAIN_8: {
                    return definition -> List.of();
                }
            }
            throw new IgniteInternalException(UUID.randomUUID(), GridgainErrorGroups.Cdc.CDC_SINK_INIT_ERR, "Unsupported sink type: " + sinkDefinition.type());
        }, this.logicalTopologyService, this.clusterSvc.topologyService(), systemDistributedConfiguration, this.clockService, IgniteImpl.partitionIdleSafeTimePropagationPeriodMsSupplier(replicationConfig))));
    }

    private SecuredIgnite createSecuredIgnite(SecurityContext securityContext) {
        return new SecuredIgnite((Ignite)this, (IgniteSql)this.sql, (IgniteCompute)this.compute, this.rbac.authorizer(), securityContext);
    }

    private void listenLicenseSecurityFeature() {
        this.licenseManager.listen((org.apache.ignite.internal.event.Event)LicenseEvent.LICENSE_APPLIED, parameters -> {
            Set licenseFeatures = (Set)parameters.license().field((LicenseField)HoconLicenseField.FEATURES);
            boolean rbacEnabled = IgniteImpl.containsSecurityFlag(licenseFeatures, LicenseFeature.RBAC);
            boolean basicAuthEnabled = IgniteImpl.containsSecurityFlag(licenseFeatures, LicenseFeature.BASIC_AUTH);
            this.rbac.enableRbacFeature(rbacEnabled);
            this.authenticationManager.enableSecurityFeature(basicAuthEnabled);
            return CompletableFutures.falseCompletedFuture();
        });
    }

    private static boolean containsSecurityFlag(@Nullable Set<LicenseFeature> allFeatures, LicenseFeature requiredFeature) {
        return allFeatures != null && (allFeatures.contains(requiredFeature) || allFeatures.contains(LicenseFeature.SECURITY));
    }

    private GroupStoragesContextResolver createGroupStoragesContextResolver() {
        Map<String, LogStorageFactory> logStorageFactoryByGroupName = Map.of(PARTITION_GROUP_NAME, this.partitionsLogStorageFactory, MetastorageGroupId.INSTANCE.toString(), this.msLogStorageFactory, CmgGroupId.INSTANCE.toString(), this.cmgLogStorageFactory);
        Map<String, Path> serverDataPathByGroupName = Map.of(PARTITION_GROUP_NAME, this.partitionsWorkDir.metaPath(), MetastorageGroupId.INSTANCE.toString(), this.metastorageWorkDir.metaPath(), CmgGroupId.INSTANCE.toString(), this.cmgWorkDir.metaPath());
        return new GroupStoragesContextResolver(replicationGroupId -> replicationGroupId instanceof PartitionGroupId ? PARTITION_GROUP_NAME : replicationGroupId.toString(), serverDataPathByGroupName, logStorageFactoryByGroupName);
    }

    private static LogicalTopologyEventListener logicalTopologyJoinedNodesListener(final JoinedNodes joinedNodes) {
        return new LogicalTopologyEventListener(){

            public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
                joinedNodes.onJoined((InternalClusterNode)joinedNode);
            }

            public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
                joinedNodes.onLeft((InternalClusterNode)leftNode);
            }
        };
    }

    private ClusterState clusterState() {
        ClusterState localClusterState = this.clusterState;
        assert (localClusterState != null) : "Cluster has not been initialized yet.";
        return localClusterState;
    }

    private static Map<String, StorageEngine> applyThreadAssertionsIfNeeded(Map<String, StorageEngine> storageEngines) {
        boolean enabled = ThreadAssertions.enabled();
        LOG.info("Thread assertions enablement status: {}", new Object[]{enabled});
        if (!enabled) {
            return storageEngines;
        }
        HashMap<String, ThreadAssertingStorageEngine> decoratedEngines = new HashMap<String, ThreadAssertingStorageEngine>();
        for (Map.Entry<String, StorageEngine> entry : storageEngines.entrySet()) {
            decoratedEngines.put(entry.getKey(), new ThreadAssertingStorageEngine(entry.getValue()));
        }
        return Map.copyOf(decoratedEngines);
    }

    private static Map<String, SecondaryStorageEngine> applyThreadAssertionsToSecondariesIfNeeded(Map<String, SecondaryStorageEngine> storageEngines) {
        if (!ThreadAssertions.enabled()) {
            return storageEngines;
        }
        HashMap<String, ThreadAssertingSecondaryStorageEngine> decoratedEngines = new HashMap<String, ThreadAssertingSecondaryStorageEngine>();
        for (Map.Entry<String, SecondaryStorageEngine> entry : storageEngines.entrySet()) {
            decoratedEngines.put(entry.getKey(), new ThreadAssertingSecondaryStorageEngine(entry.getValue()));
        }
        return Map.copyOf(decoratedEngines);
    }

    private static LongSupplier delayDurationMsSupplier(SchemaSynchronizationConfiguration schemaSyncConfig) {
        return () -> (Long)schemaSyncConfig.delayDurationMillis().value();
    }

    private static LongSupplier partitionIdleSafeTimePropagationPeriodMsSupplier(ReplicationConfiguration replicationConfig) {
        return () -> (Long)replicationConfig.idleSafeTimePropagationDurationMillis().value();
    }

    private AuthenticationManagerImpl createAuthenticationManager() {
        SecurityConfiguration securityConfiguration = ((SecurityExtensionConfiguration)this.clusterCfgMgr.configurationRegistry().getConfiguration(SecurityExtensionConfiguration.KEY)).security();
        return new AuthenticationManagerImpl((Executor)this.threadPoolsManager.authenticationExecutor(), securityConfiguration, (LicenseFeatureChecker)this.licenseFeatureChecker, (EventLog)this.eventLog);
    }

    private EncryptionManager createEncryptionManager() {
        EncryptionConfiguration encryptionConfiguration = ((EncryptionExtensionConfiguration)this.clusterCfgMgr.configurationRegistry().getConfiguration(EncryptionExtensionConfiguration.KEY)).encryption();
        return new EncryptionManagerImpl(encryptionConfiguration, (LicenseFeatureChecker)this.licenseFeatureChecker);
    }

    private RestComponent createRestComponent(String name) {
        RestManager restManager = new RestManager();
        Supplier<RestFactory> presentationsFactory = () -> new PresentationsFactory(this.nodeCfgMgr, this.clusterCfgMgr, this.rbac.authorizer());
        Supplier<RestFactory> clusterManagementRestFactory = () -> new ClusterManagementRestFactory(this.clusterSvc, this.clusterInitializer, this.cmgMgr);
        Supplier<RestFactory> nodeManagementRestFactory = () -> new NodeManagementRestFactory((StateProvider)this.lifecycleManager, () -> name, (JdbcPortProvider)new JdbcPortProviderImpl(this.nodeCfgMgr.configurationRegistry()));
        Supplier<RestFactory> metricRestFactory = () -> new MetricRestFactory((MetricManager)new SecuredMetricManager(this.metricManager, this.rbac.authorizer()), this.metricMessaging);
        Supplier<RestFactory> authProviderFactory = () -> new AuthenticationProviderFactory((AuthenticationManager)this.authenticationManager);
        Supplier<RestFactory> deploymentCodeRestFactory = () -> new CodeDeploymentRestFactory((IgniteDeployment)this.deploymentManager, this.deploymentManager.tempStorageProvider());
        Supplier<RestFactory> restManagerFactory = () -> new RestManagerFactory(restManager);
        Supplier<RestFactory> computeRestFactory = () -> new ComputeRestFactory(this.compute);
        Supplier<RestFactory> disasterRecoveryFactory = () -> new DisasterRecoveryFactory(this.disasterRecoveryManager);
        Supplier<RestFactory> systemDisasterRecoveryFactory = () -> new SystemDisasterRecoveryFactory((SystemDisasterRecoveryManager)this.systemDisasterRecoveryManager);
        Supplier<RestFactory> sqlQueryRestFactory = () -> new SqlQueryRestFactory(this.bareSql(), (KillHandlerRegistry)this.killCommandHandler, this.rbac.authorizer());
        Supplier<RestFactory> nodePropertiesRestFactory = () -> new NodePropertiesFactory((NodeProperties)this.nodeProperties);
        Supplier<RestFactory> rbacRestFactory = () -> new RbacRestFactory(this.rbac);
        Supplier<RestFactory> pitrRestFactory = () -> new PitrRestFactory(this.pitrManager.api((LicenseFeatureChecker)this.licenseFeatureChecker, this.rbac.authorizer()));
        Supplier<RestFactory> licenseManagementRestFactory = () -> new LicenseManagementRestFactory((LicenseFeatureChecker)this.licenseFeatureChecker, this.licenseManager);
        Supplier<RestFactory> jwtRestFactory = () -> new JwtRestFactory((AuthenticationManager)this.authenticationManager, (LicenseFeatureChecker)this.licenseFeatureChecker, this.jwtTokenManager);
        Supplier<RestFactory> snapshotManagementRestFactory = () -> new SnapshotManagementRestFactory(this.snapshotFacade);
        Supplier<RestFactory> dcrRestFactory = () -> new DcrRestFactory(this.dcrManager);
        Supplier<RestFactory> rollingUpgradeRestFactory = () -> new RollingUpgradeRestFactory(this.rollingUpgradeManager);
        Supplier<RestFactory> cdcRestFactory = () -> new CdcRestFactory(this.cdcManager);
        RestConfiguration restConfiguration = ((RestExtensionConfiguration)this.nodeCfgMgr.configurationRegistry().getConfiguration(RestExtensionConfiguration.KEY)).rest();
        return new RestComponent(List.of(presentationsFactory, clusterManagementRestFactory, nodeManagementRestFactory, metricRestFactory, deploymentCodeRestFactory, authProviderFactory, restManagerFactory, computeRestFactory, disasterRecoveryFactory, systemDisasterRecoveryFactory, sqlQueryRestFactory, nodePropertiesRestFactory, rbacRestFactory, pitrRestFactory, licenseManagementRestFactory, jwtRestFactory, snapshotManagementRestFactory, dcrRestFactory, rollingUpgradeRestFactory, cdcRestFactory), restManager, restConfiguration);
    }

    private ClusterNameProvider clusterNameProvider() {
        return () -> {
            try {
                return ((ClusterState)this.cmgMgr.clusterState().get()).clusterTag().clusterName();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
            }
        };
    }

    private CompletableFuture<String> clusterNameFuture() {
        return this.cmgMgr.joinFuture().thenCompose(unused -> this.cmgMgr.clusterState().thenApply(state -> state.clusterTag().clusterName()));
    }

    private static MessageSerializationRegistry createSerializationRegistry(@Nullable ClassLoader classLoader) {
        SerializationRegistryServiceLoader serviceLoader = new SerializationRegistryServiceLoader(classLoader);
        MessageSerializationRegistryImpl serializationRegistry = new MessageSerializationRegistryImpl();
        serviceLoader.registerSerializationFactories((MessageSerializationRegistry)serializationRegistry);
        return serializationRegistry;
    }

    private static ConfigurationModules loadConfigurationModules(@Nullable ClassLoader classLoader) {
        ServiceLoaderModulesProvider modulesProvider = new ServiceLoaderModulesProvider();
        List<ConfigurationModule> modules = modulesProvider.modules(classLoader);
        if (modules.isEmpty()) {
            throw new IllegalStateException("No configuration modules were loaded, this means Ignite cannot start. Please make sure that the classloader for loading services is correct.");
        }
        return new ConfigurationModules(modules);
    }

    CompletableFuture<Void> startAsync() {
        ExecutorService startupExecutor = Executors.newSingleThreadExecutor((ThreadFactory)IgniteThreadFactory.create((String)this.name, (String)"start", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        ComponentContext componentContext = new ComponentContext(startupExecutor);
        try {
            JvmMetricSource jvmMetrics = new JvmMetricSource();
            this.metricManager.registerSource((MetricSource)jvmMetrics);
            this.metricManager.enable((MetricSource)jvmMetrics);
            OsMetricSource osMetrics = new OsMetricSource();
            this.metricManager.registerSource((MetricSource)osMetrics);
            this.metricManager.enable((MetricSource)osMetrics);
            this.metricManager.registerSource((MetricSource)this.clockServiceMetricSource);
            this.metricManager.enable((MetricSource)this.clockServiceMetricSource);
            CompletableFuture<Void> componentsStartFuture = this.lifecycleManager.startComponentsAsync(componentContext, new IgniteComponent[]{this.longJvmPauseDetector, this.vaultMgr, this.nodeProperties, this.threadPoolsManager, this.clockWaiter, this.failureManager, this.clusterStateStorage, this.clusterIdService, this.systemDisasterRecoveryManager, this.criticalWorkerRegistry, this.nettyBootstrapFactory, this.nettyWorkersRegistrar, this.clusterSvc, this.restComponent, this.raftMgr, this.encryptionConfigurationVault, this.cmgMgr, this.lowWatermark, this.licenseManager});
            return ((CompletableFuture)((CompletableFuture)componentsStartFuture.thenRunAsync(() -> {
                this.vaultMgr.putName(this.name);
                this.clusterSvc.updateMetadata(new NodeMetadata(this.restComponent.hostName(), this.restComponent.httpPort(), this.restComponent.httpsPort()));
                LOG.info("Components started", new Object[0]);
            }, startupExecutor)).handleAsync((v, e) -> {
                if (e != null) {
                    throw this.handleStartException((Throwable)e);
                }
                return v;
            }, (Executor)startupExecutor)).whenCompleteAsync((res, ex) -> startupExecutor.shutdownNow());
        }
        catch (Throwable e2) {
            startupExecutor.shutdownNow();
            throw this.handleStartException(e2);
        }
    }

    CompletableFuture<Ignite> joinClusterAsync() {
        LOG.info("Joining the cluster", new Object[0]);
        ExecutorService joinExecutor = Executors.newSingleThreadExecutor((ThreadFactory)IgniteThreadFactory.create((String)this.name, (String)"join", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        ComponentContext componentContext = new ComponentContext(joinExecutor);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.cmgMgr.joinFuture().thenComposeAsync(unused -> this.cmgMgr.clusterState(), (Executor)joinExecutor)).thenAcceptAsync(clusterState -> {
            this.clusterState = clusterState;
            this.systemDisasterRecoveryManager.saveClusterState(clusterState);
        }, (Executor)joinExecutor)).thenRunAsync(() -> ((RestComponent)this.restComponent).disable(), joinExecutor)).thenComposeAsync(unused -> {
            LOG.info("Join complete, starting MetaStorage", new Object[0]);
            try {
                this.lifecycleManager.startComponentAsync((IgniteComponent)this.metaStorageMgr, componentContext);
            }
            catch (NodeStoppingException e) {
                throw new CompletionException(e);
            }
            return this.metaStorageMgr.recoveryFinishedFuture();
        }, (Executor)joinExecutor)).thenComposeAsync(unused -> this.initializeClusterConfiguration(joinExecutor), (Executor)joinExecutor)).thenComposeAsync(unused -> this.rollingUpgradeManager.blockConfigurationUpdatesIfNeeded(), (Executor)joinExecutor)).thenRunAsync(() -> {
            try {
                this.lifecycleManager.startComponentsAsync(componentContext, new IgniteComponent[]{this.clusterCfgMgr});
            }
            catch (NodeStoppingException e) {
                throw new CompletionException(e);
            }
        }, joinExecutor)).thenComposeAsync(unused -> this.licenseManager.refreshLicense(), (Executor)joinExecutor)).thenRunAsync(() -> {
            LOG.info("MetaStorage started, starting the remaining components", new Object[0]);
            this.dataStorageMgr.checkLoadedStorageEnginesForLicense();
            try {
                this.lifecycleManager.startComponentsAsync(componentContext, new IgniteComponent[]{this.encryptionManager, this.rbac, this.catalogManager, this.catalogCompactionRunner, this.indexMetaStorage, this.idempotentCacheVacuumizer, this.authenticationManager, this.placementDriverMgr, this.metricManager, this.metricMessaging, this.distributionZoneManager, this.computeComponent, this.volatileLogStorageFactoryCreator, this.replicaMgr, this.indexNodeFinishedRwTransactionsChecker, this.txManager, this.dataStorageMgr, this.schemaSafeTimeTracker, this.schemaManager, this.outgoingSnapshotsManager, this.sharedTxStateStorage, this.partitionReplicaLifecycleManager, this.distributedTblMgr, this.disasterRecoveryManager, this.indexManager, this.indexBuildingManager, this.qryEngine, this.clientHandlerModule, this.deploymentManager, this.snapshotManager, this.snapshotFileSystemManager, this.sql, this.systemPropertiesComponent, this.resourceVacuumManager, this.metaStorageCompactionTrigger, this.nodeKeyManager, this.jwtTokenManager, this.dcrManager, this.evictionManager, this.snapshotTombstoneManager, this.pitrManager, this.rollingUpgradeManager, this.eventLog, this.cdcManager});
                this.lifecycleManager.startComponentAsync((IgniteComponent)this.systemViewManager, componentContext);
            }
            catch (NodeStoppingException e) {
                throw new CompletionException(e);
            }
        }, joinExecutor)).thenComposeAsync(v -> {
            LOG.info("Components started, performing recovery", new Object[0]);
            LOG.info("Cluster configuration: {}", new Object[]{IgniteImpl.convertToHoconString(this.clusterCfgMgr.configurationRegistry())});
            return this.recoverComponentsStateOnStart(joinExecutor, this.lifecycleManager.allComponentsStartFuture(joinExecutor));
        }, (Executor)joinExecutor)).thenComposeAsync(v -> this.clusterCfgMgr.configurationRegistry().startFuture(), (Executor)joinExecutor)).thenComposeAsync(v -> {
            LOG.info("Recovery complete, finishing join", new Object[0]);
            return this.cmgMgr.onJoinReady();
        }, (Executor)joinExecutor)).thenComposeAsync(ignored -> this.awaitSelfInLocalLogicalTopology(), (Executor)joinExecutor)).thenCompose(ignored -> this.catalogManager.catalogInitializationFuture())).thenCompose(ignored -> this.systemViewManager.completeRegistration())).thenRunAsync(() -> {
            try {
                this.lowWatermark.scheduleUpdates();
                this.clientHandlerModule.enable();
                this.restComponent.enable();
                this.computeComponent.enable();
                this.licenseManager.checkLimits();
                this.lifecycleManager.onStartComplete();
            }
            catch (NodeStoppingException e) {
                throw new CompletionException(e);
            }
        }, joinExecutor)).handleAsync((v, e) -> {
            if (e != null) {
                throw this.handleStartException((Throwable)e);
            }
            return this;
        }, (Executor)joinExecutor)).whenCompleteAsync((res, ex) -> joinExecutor.shutdownNow());
    }

    private CompletableFuture<Void> awaitSelfInLocalLogicalTopology() {
        final CompletableFuture<Void> awaitSelfInLogicalTopologyFuture = new CompletableFuture<Void>();
        LogicalTopologyEventListener awaitSelfListener = new LogicalTopologyEventListener(){

            public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
                IgniteImpl.this.checkSelfInTopology(newTopology, awaitSelfInLogicalTopologyFuture, this);
            }

            public void onTopologyLeap(LogicalTopologySnapshot newTopology) {
                IgniteImpl.this.checkSelfInTopology(newTopology, awaitSelfInLogicalTopologyFuture, this);
            }
        };
        this.logicalTopologyService.addEventListener(awaitSelfListener);
        this.checkSelfInTopology(this.logicalTopologyService.localLogicalTopology(), awaitSelfInLogicalTopologyFuture, awaitSelfListener);
        return awaitSelfInLogicalTopologyFuture;
    }

    private void checkSelfInTopology(LogicalTopologySnapshot logicalTopologySnapshot, CompletableFuture<Void> awaitSelfInLogicalTopologyFuture, LogicalTopologyEventListener awaitSelfListener) {
        if (logicalTopologySnapshot.nodes().stream().map(ClusterNodeImpl::id).collect(Collectors.toSet()).contains(this.id())) {
            awaitSelfInLogicalTopologyFuture.complete(null);
            this.logicalTopologyService.removeEventListener(awaitSelfListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException handleStartException(Throwable e) {
        String errMsg = "Unable to start [node=" + this.name + "]";
        IgniteException igniteException = new IgniteException(ExceptionUtils.extractCodeFrom((Throwable)e), errMsg, e);
        Throwable rootEx = ExceptionUtils.unwrapRootCause((Throwable)e);
        if (rootEx instanceof InvalidNodeConfigurationException) {
            LOG.error("{}. Reason: {}", new Object[]{errMsg, rootEx.getMessage()});
        } else {
            LOG.error(errMsg, (Throwable)igniteException);
        }
        ExecutorService lifecycleExecutor = this.stopExecutor();
        try {
            this.lifecycleManager.stopNode(new ComponentContext(lifecycleExecutor)).get();
        }
        catch (Throwable ex) {
            LOG.error("Node stop failed after node start failure", ex);
            igniteException.addSuppressed(ex);
        }
        finally {
            lifecycleExecutor.shutdownNow();
        }
        return igniteException;
    }

    public void stop() throws ExecutionException, InterruptedException {
        this.stopAsync().get();
    }

    public CompletableFuture<Void> stopAsync() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return this.stopFuture;
        }
        ExecutorService lifecycleExecutor = this.stopExecutor();
        ((CompletableFuture)this.lifecycleManager.stopNode(new ComponentContext(lifecycleExecutor)).whenCompleteAsync((res, ex) -> lifecycleExecutor.shutdownNow())).whenCompleteAsync(CompletableFutures.copyStateTo(this.stopFuture));
        return this.stopFuture;
    }

    private ExecutorService stopExecutor() {
        return Executors.newSingleThreadExecutor((ThreadFactory)IgniteThreadFactory.create((String)this.name, (String)"stop", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
    }

    public IgniteTables tables() {
        return this.publicTables;
    }

    public IgniteStructures structures() {
        return this.igniteStructures;
    }

    @TestOnly
    public DisasterRecoveryManager disasterRecoveryManager() {
        return this.disasterRecoveryManager;
    }

    public IgniteCaches caches() {
        return this.publicCaches;
    }

    @TestOnly
    public VaultManager vault() {
        return this.vaultMgr;
    }

    @TestOnly
    public ClusterStateStorage clusterStateStorage() {
        return this.clusterStateStorage;
    }

    @TestOnly
    public ClusterManagementGroupManager clusterManagementGroupManager() {
        return this.cmgMgr;
    }

    @TestOnly
    public QueryProcessor queryEngine() {
        return this.qryEngine;
    }

    @TestOnly
    public SystemViewManager systemViewManager() {
        return this.systemViewManager;
    }

    @TestOnly
    public MetaStorageManager metaStorageManager() {
        return this.metaStorageMgr;
    }

    @TestOnly
    public LicenseFeatureChecker licenseFeatureChecker() {
        return this.licenseFeatureChecker;
    }

    @TestOnly
    public FailureManager failureProcessor() {
        return this.failureManager;
    }

    @TestOnly
    public MetricManager metricManager() {
        return this.metricManager;
    }

    @TestOnly
    public TableManager distributedTableManager() {
        return this.distributedTblMgr;
    }

    @TestOnly
    public ConfigurationStorage clusterCfgStorage() {
        return this.cfgStorage;
    }

    public IgniteTransactions transactions() {
        return this.publicTransactions;
    }

    private IgniteSql bareSql() {
        return this.sqlWithSystemContext;
    }

    public IgniteSql sql() {
        return this.publicSql;
    }

    public String name() {
        return this.name;
    }

    public IgniteCompute compute() {
        return this.publicCompute;
    }

    public IgniteCatalog catalog() {
        return this.publicCatalog;
    }

    public IgniteCluster cluster() {
        return this.publicCluster;
    }

    private RollingUpgradeManager rollingUpgradeManager() {
        return this.rollingUpgradeManager;
    }

    private RollingUpgradeManager unsecuredRollingUpgradeManager() {
        return this.unsecuredRollingUpgradeManager;
    }

    public Path workDir() {
        return this.workDir;
    }

    public ConfigurationRegistry nodeConfiguration() {
        return this.nodeCfgMgr.configurationRegistry();
    }

    public ConfigurationRegistry clusterConfiguration() {
        return this.clusterCfgMgr.configurationRegistry();
    }

    public HybridTimestampTracker observableTimeTracker() {
        return this.observableTimestampTracker;
    }

    public UUID id() {
        return this.clusterSvc.topologyService().localMember().id();
    }

    @Nullable
    public NetworkAddress restHttpAddress() {
        String host = this.restComponent.hostName();
        int port = this.restComponent.httpPort();
        if (port != -1) {
            return new NetworkAddress(host, port);
        }
        return null;
    }

    @Nullable
    public NetworkAddress restHttpsAddress() {
        String host = this.restComponent.hostName();
        int port = this.restComponent.httpsPort();
        if (port != -1) {
            return new NetworkAddress(host, port);
        }
        return null;
    }

    public NetworkAddress clientAddress() {
        return NetworkAddress.from((InetSocketAddress)this.clientHandlerModule.localAddress());
    }

    CompletableFuture<Void> initClusterAsync(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName, String clusterConfiguration, String license) throws NodeStoppingException {
        return this.cmgMgr.initClusterAsync(metaStorageNodeNames, cmgNodeNames, clusterName, clusterConfiguration, license);
    }

    private CompletableFuture<Void> initializeClusterConfiguration(ExecutorService startupExecutor) {
        return ((CompletableFuture)this.cfgStorage.localRevision().thenComposeAsync(appliedRevision -> {
            if (appliedRevision != 0L) {
                return CompletableFutures.nullCompletedFuture();
            }
            return this.cmgMgr.initialClusterConfigurationFuture().thenAcceptAsync(initialConfigHocon -> {
                if (initialConfigHocon == null) {
                    return;
                }
                Config config = ConfigFactory.parseString((String)initialConfigHocon);
                ConfigurationSource hoconSource = HoconConverter.hoconSource((ConfigObject)config.root());
                this.clusterCfgMgr.configurationRegistry().initializeConfigurationWith(hoconSource);
            }, (Executor)startupExecutor);
        }, (Executor)startupExecutor)).thenRunAsync(() -> ((SystemDisasterRecoveryManagerImpl)this.systemDisasterRecoveryManager).markInitConfigApplied(), startupExecutor);
    }

    private CompletableFuture<?> recoverComponentsStateOnStart(ExecutorService startupExecutor, CompletableFuture<Void> startFuture) {
        this.encryptionConfigurationVault.saveCurrentEncryptionConfig();
        CompletableFuture startupRevisionUpdate = this.metaStorageMgr.notifyRevisionUpdateListenerOnStart();
        return CompletableFuture.allOf(startupRevisionUpdate, startFuture).thenComposeAsync(unused -> this.metaStorageMgr.deployWatches(), (Executor)startupExecutor);
    }

    private static Path createPartitionsStoreDirectory(Path storePath) {
        try {
            Files.createDirectories(storePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IgniteInternalException("Failed to create directory for partitions storage: " + e.getMessage(), (Throwable)e);
        }
        return storePath;
    }

    private SnapshotManager createSnapshotManager(NodeSnapshotConfiguration snapshotConfiguration, SchemaSyncService schemaSyncService, ReplicationConfiguration replicationConfiguration, DataEncryptionKeyManager dataEncryptionKeyManager, SystemLocalConfiguration systemLocalConfiguration, ClockService clockService) {
        return new SnapshotManager(this.clusterSvc, this.metaStorageMgr, this.catalogManager, this.distributedTblMgr, (TxManager)this.txManager, this.partitionReplicaLifecycleManager, this.logicalTopologyService, schemaSyncService, this.placementDriverMgr.placementDriver(), this.replicaMgr, this.clock, this.snapshotFileSystemManager, snapshotConfiguration, replicationConfiguration, this.snapshotTombstoneManager, this.encryptionManager, dataEncryptionKeyManager, (NodeProperties)this.nodeProperties, systemLocalConfiguration, clockService);
    }

    private void fireEvent(Event evt) {
        assert (this.eventLog != null);
        this.eventLog.log(evt);
    }

    private static OperationKillHandler computeKillHandler(final IgniteComputeInternal compute) {
        return new OperationKillHandler(){

            public CompletableFuture<Boolean> cancelAsync(String operationId) {
                UUID jobId = UUID.fromString(operationId);
                return compute.cancelAsync(jobId).thenApply(res -> res != null ? res : Boolean.FALSE);
            }

            public boolean local() {
                return false;
            }

            public CancellableOperationType type() {
                return CancellableOperationType.COMPUTE;
            }
        };
    }

    private static OperationKillHandler transactionKillHandler(final TxManager txManager) {
        return new OperationKillHandler(){

            public CompletableFuture<Boolean> cancelAsync(String operationId) {
                UUID transactionId = UUID.fromString(operationId);
                return txManager.kill(transactionId);
            }

            public boolean local() {
                return true;
            }

            public CancellableOperationType type() {
                return CancellableOperationType.TRANSACTION;
            }
        };
    }

    @TestOnly
    public Loza raftManager() {
        return this.raftMgr;
    }

    @TestOnly
    public RollingUpgradeManager securedRollingUpgradeManager() {
        return this.rollingUpgradeManager;
    }

    @TestOnly
    public InternalClusterNode node() {
        return this.clusterSvc.topologyService().localMember();
    }

    @TestOnly
    public DistributionZoneManager distributionZoneManager() {
        return this.distributionZoneManager;
    }

    @TestOnly
    public LogicalTopologyService logicalTopologyService() {
        return this.logicalTopologyService;
    }

    @TestOnly
    public IgniteDeployment deployment() {
        return this.deploymentManager;
    }

    @TestOnly
    public Rbac rbac() {
        return this.rbac;
    }

    @TestOnly
    public TableManager tableManager() {
        return this.distributedTblMgr;
    }

    @TestOnly
    public SnapshotTombstoneManager snapshotTombstoneManager() {
        return this.snapshotTombstoneManager;
    }

    @TestOnly
    public SnapshotManager snapshotManager() {
        return this.snapshotManager;
    }

    @TestOnly
    public void dropMessages(BiPredicate<@Nullable String, NetworkMessage> predicate) {
        ((DefaultMessagingService)this.clusterSvc.messagingService()).dropMessages(predicate);
    }

    @TestOnly
    @Nullable
    public BiPredicate<String, NetworkMessage> dropMessagesPredicate() {
        return ((DefaultMessagingService)this.clusterSvc.messagingService()).dropMessagesPredicate();
    }

    @TestOnly
    public void sendFakeMessage(String recipientConsistentId, NetworkMessage msg) {
        this.clusterSvc.messagingService().send(recipientConsistentId, ChannelType.DEFAULT, msg);
    }

    @TestOnly
    public void stopDroppingMessages() {
        ((DefaultMessagingService)this.clusterSvc.messagingService()).stopDroppingMessages();
    }

    @TestOnly
    public HybridClock clock() {
        return this.clock;
    }

    @TestOnly
    public ClockService clockService() {
        return this.clockService;
    }

    @TestOnly
    public ComponentWorkingDir partitionsWorkDir() {
        return this.partitionsWorkDir;
    }

    @TestOnly
    public ComponentWorkingDir metastorageWorkDir() {
        return this.metastorageWorkDir;
    }

    @TestOnly
    public LogStorageFactory partitionsLogStorageFactory() {
        return this.partitionsLogStorageFactory;
    }

    @TestOnly
    public TxManager txManager() {
        return this.txManager;
    }

    @TestOnly
    public ClientInboundMessageHandler clientInboundMessageHandler() {
        return this.clientHandlerModule.handler();
    }

    @TestOnly
    public PlacementDriver placementDriver() {
        return this.placementDriverMgr.placementDriver();
    }

    @TestOnly
    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    @TestOnly
    public CatalogCompactionRunner catalogCompactionRunner() {
        return this.catalogCompactionRunner;
    }

    @TestOnly
    public NettyBootstrapFactory nettyBootstrapFactory() {
        return this.nettyBootstrapFactory;
    }

    @TestOnly
    public ClusterService clusterService() {
        return this.clusterSvc;
    }

    @TestOnly
    public ClusterIdService clusterIdService() {
        return this.clusterIdService;
    }

    @TestOnly
    public RemotelyTriggeredResourceRegistry resourcesRegistry() {
        return this.resourcesRegistry;
    }

    @TestOnly
    public LowWatermarkImpl lowWatermark() {
        return this.lowWatermark;
    }

    @TestOnly
    public ReplicaManager replicaManager() {
        return this.replicaMgr;
    }

    @TestOnly
    public SystemDisasterRecoveryManager systemDisasterRecoveryManager() {
        return this.systemDisasterRecoveryManager;
    }

    @TestOnly
    public PartitionReplicaLifecycleManager partitionReplicaLifecycleManager() {
        return this.partitionReplicaLifecycleManager;
    }

    @TestOnly
    public TxStateRocksDbSharedStorage sharedTxStateStorage() {
        return this.sharedTxStateStorage;
    }

    @TestOnly
    public NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    @TestOnly
    public SchemaSafeTimeTrackerImpl schemaSafeTimeTracker() {
        return this.schemaSafeTimeTracker;
    }

    @TestOnly
    public EncryptionManager encryptionManager() {
        return this.encryptionManager;
    }

    @TestOnly
    public DataStorageManager dataStorageManager() {
        return this.dataStorageMgr;
    }

    @TestOnly
    public EvictionManager evictionManager() {
        return this.evictionManager;
    }

    @TestOnly
    public GridLicenseManager licenseManager() {
        return this.licenseManager;
    }

    @TestOnly
    public CdcManager cdcManager() {
        return this.cdcManager;
    }

    @TestOnly
    public PitrManager pitrManager() {
        return this.pitrManager;
    }

    @TestOnly
    public void dumpClusterState() {
        IgniteStringBuilder sb = new IgniteStringBuilder().app("Dumping cluster state for node ").app(this.node().name()).app(":").nl();
        this.lifecycleManager.dumpState(sb, "");
        LOG.info(sb.toString(), new Object[0]);
    }

    private static String convertToHoconString(ConfigurationRegistry configRegistry) {
        return HoconConverter.represent((TraversableTreeNode)configRegistry.superRoot(), List.of()).render(ConfigRenderOptions.concise().setJson(false));
    }
}

