/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofCache;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.table.QualifiedName;
import org.jetbrains.annotations.Nullable;

class RestartProofIgniteCaches
implements IgniteCaches,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteCaches(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    public List<Cache> caches() {
        return this.attachmentLock.attached(ignite -> {
            List caches = ignite.caches().caches();
            return this.wrapCaches(caches, (Ignite)ignite);
        });
    }

    public CompletableFuture<List<Cache>> cachesAsync() {
        return this.attachmentLock.attachedAsync(ignite -> ignite.caches().cachesAsync().thenApply(caches -> this.wrapCaches((List<Cache>)caches, (Ignite)ignite)));
    }

    @Nullable
    public Cache cache(QualifiedName name) {
        return this.attachmentLock.attached(ignite -> {
            Cache cache = ignite.caches().cache(name);
            return this.wrapCache(cache, (Ignite)ignite);
        });
    }

    public CompletableFuture<Cache> cacheAsync(QualifiedName name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.caches().cacheAsync(name).thenApply(cache -> this.wrapCache((Cache)cache, (Ignite)ignite)));
    }

    @Nullable
    private Cache wrapCache(@Nullable Cache cache, Ignite ignite) {
        if (cache == null) {
            return null;
        }
        return new RestartProofCache(this.attachmentLock, ignite, RestartProofCache.cacheId(cache));
    }

    private List<Cache> wrapCaches(List<Cache> caches, Ignite ignite) {
        return caches.stream().map(cache -> this.wrapCache((Cache)cache, ignite)).collect(Collectors.toList());
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)ignite.caches(), (Class)classToUnwrap));
    }
}

