/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.configuration.AuthenticationThreadPoolConfiguration;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.sources.ThreadPoolMetricSource;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;

public class ThreadPoolsManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ThreadPoolsManager.class);
    private final ExecutorService tableIoExecutor;
    private final ExecutorService partitionOperationsExecutor;
    private final ScheduledExecutorService commonScheduler;
    private final ExecutorService authenticationExecutor;
    private final ScheduledExecutorService rebalanceScheduler;
    private final MetricManager metricManager;
    private final List<ThreadPoolMetricSource> metricSources;

    public ThreadPoolsManager(String nodeName, AuthenticationThreadPoolConfiguration authentication, MetricManager metricManager) {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.tableIoExecutor = Executors.newFixedThreadPool(Math.min(cpus * 3, 25), (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"tableManager-io", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        int partitionsOperationsThreads = Math.min(cpus * 3, 25);
        this.partitionOperationsExecutor = Executors.newFixedThreadPool(partitionsOperationsThreads, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"partition-operations", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE, ThreadOperation.TX_STATE_STORAGE_ACCESS, ThreadOperation.PROCESS_RAFT_REQ}));
        this.commonScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"common-scheduler", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        this.authenticationExecutor = ThreadPoolsManager.createAuthenticationExecutor(nodeName, authentication);
        this.rebalanceScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"rebalance-scheduler", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        this.metricManager = metricManager;
        this.metricSources = new ArrayList<ThreadPoolMetricSource>();
        this.metricSources.add(new ThreadPoolMetricSource("thread.pools.partitions-executor", "The partitions-executor pool handles all the table related operations.", (ThreadPoolExecutor)this.partitionOperationsExecutor));
    }

    private static ExecutorService createAuthenticationExecutor(String nodeName, AuthenticationThreadPoolConfiguration authentication) {
        return new ThreadPoolExecutor(1, (int)((Integer)authentication.threadPoolSize().value()), (long)((Long)authentication.threadKeepAliveTime().value()), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"authentication", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.metricSources.forEach(metricSource -> {
            this.metricManager.registerSource((MetricSource)metricSource);
            this.metricManager.enable((MetricSource)metricSource);
        });
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.tableIoExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.partitionOperationsExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.commonScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.authenticationExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.rebalanceScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    public ExecutorService tableIoExecutor() {
        return this.tableIoExecutor;
    }

    public ExecutorService partitionOperationsExecutor() {
        return this.partitionOperationsExecutor;
    }

    public ScheduledExecutorService commonScheduler() {
        return this.commonScheduler;
    }

    public ExecutorService authenticationExecutor() {
        return this.authenticationExecutor;
    }

    public ScheduledExecutorService rebalanceScheduler() {
        return this.rebalanceScheduler;
    }
}

