/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;

public class NodePropertiesImpl
implements NodeProperties,
IgniteComponent,
NodeAttributesProvider {
    private static final IgniteLogger LOG = Loggers.forClass(NodePropertiesImpl.class);
    public static final ByteArray ZONE_BASED_REPLICATION_KEY = ByteArray.fromString((String)"zone.based.replication");
    private final VaultManager vaultManager;
    private boolean started;
    private boolean colocationEnabled;

    public NodePropertiesImpl(VaultManager vaultManager) {
        this.vaultManager = vaultManager;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.detectAndSaveColocationStatusIfNeeded();
        this.started = true;
        return CompletableFutures.nullCompletedFuture();
    }

    private void detectAndSaveColocationStatusIfNeeded() {
        String logComment;
        VaultEntry entry = this.vaultManager.get(ZONE_BASED_REPLICATION_KEY);
        if (entry != null) {
            this.colocationEnabled = entry.value()[0] == 1;
            logComment = "from Vault";
        } else {
            boolean freshNode;
            boolean bl = freshNode = this.vaultManager.name() == null;
            if (freshNode) {
                this.colocationEnabled = IgniteSystemProperties.colocationEnabled();
                logComment = "from system properties on a fresh node";
            } else {
                this.colocationEnabled = false;
                logComment = "node of an older version was run without zone based replication";
            }
            this.saveToVault(this.colocationEnabled);
        }
        LOG.info("Zone based replication: {} ({})", new Object[]{this.colocationEnabled, logComment});
        if (this.colocationEnabled != IgniteSystemProperties.colocationEnabled()) {
            LOG.warn("Zone based replication status configured via system properties ({}) does not match, it is ignored", new Object[]{IgniteSystemProperties.colocationEnabled()});
        }
        if (!this.colocationEnabled) {
            LOG.warn("Zone based replication is disabled, this mode is deprecated and will be removed in a future version. Consider migrating to zone based replication (which is default now).", new Object[0]);
        }
    }

    private void saveToVault(boolean enablementStatus) {
        this.vaultManager.put(ZONE_BASED_REPLICATION_KEY, new byte[]{(byte)(enablementStatus ? 1 : 0)});
    }

    public boolean colocationEnabled() {
        if (!this.started) {
            throw new IllegalStateException("NodeProperties not started.");
        }
        return this.colocationEnabled;
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    public Map<String, String> nodeAttributes() {
        return Map.of("IGNITE_ZONE_BASED_REPLICATION", Boolean.toString(this.colocationEnabled()), "ignite.version", IgniteProductVersion.CURRENT_VERSION.toString());
    }
}

