/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.cache.CacheStoreFactory;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RefCache;
import org.apache.ignite.internal.restart.RestartProofKeyValueView;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersionsImpl;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

class RestartProofCache
implements Cache,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;
    private final int cacheId;
    private final RefCache<Cache> cacheCache;

    RestartProofCache(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, int cacheId) {
        this.attachmentLock = attachmentLock;
        this.cacheId = cacheId;
        this.cacheCache = new RefCache<Cache>(initialIgnite, this::cacheFromIgnite);
    }

    static int cacheId(Cache cache) {
        return ((TableViewInternal)Wrappers.unwrap((Object)cache, TableViewInternal.class)).tableId();
    }

    private Cache cacheFromIgnite(Ignite ignite) {
        Cache underlyingCache = ignite.caches().caches().stream().filter(cache -> RestartProofCache.cacheId(cache) == this.cacheId).findAny().orElse(null);
        if (underlyingCache == null) {
            throw SchemaVersionsImpl.tableNotFoundException((int)this.cacheId);
        }
        return underlyingCache;
    }

    public String name() {
        return this.attachmentLock.attached(ignite -> this.cacheCache.actualFor((Ignite)ignite).name());
    }

    public QualifiedName qualifiedName() {
        return this.attachmentLock.attached(ignite -> this.cacheCache.actualFor((Ignite)ignite).qualifiedName());
    }

    public <K, V> KeyValueView<K, V> keyValueView(CacheStoreFactory store, Mapper<K> keyMapper, Mapper<V> valMapper) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.cacheCache.actualFor((Ignite)currentIgnite).keyValueView(store, keyMapper, valMapper)));
    }

    public KeyValueView<Tuple, Tuple> keyValueView(CacheStoreFactory store) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.cacheCache.actualFor((Ignite)currentIgnite).keyValueView(store)));
    }

    public <K, V> CompletableFuture<Void> loadAsync(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper, @Nullable BiPredicate<K, V> filter, Object ... args) {
        return this.attachmentLock.attachedAsync(ignite -> this.cacheCache.actualFor((Ignite)ignite).loadAsync(fac, keyMapper, valMapper, filter, args));
    }

    public CompletableFuture<Void> loadAsync(CacheStoreFactory fac, @Nullable BiPredicate<Tuple, Tuple> filter, Object ... args) {
        return this.attachmentLock.attachedAsync(ignite -> this.cacheCache.actualFor((Ignite)ignite).loadAsync(fac, filter, args));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)this.cacheCache.actualFor((Ignite)ignite), (Class)classToUnwrap));
    }
}

