/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.function.Function;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.restart.IgniteAware;

class RefCache<T> {
    private static final IgniteLogger LOG = Loggers.forClass(RefCache.class);
    private final Function<Ignite, T> supplier;
    private IgniteAware<T> value;

    RefCache(Ignite initialIgnite, Function<Ignite, T> supplier) {
        this.value = new IgniteAware<T>(supplier.apply(initialIgnite), initialIgnite);
        this.supplier = supplier;
    }

    public T actualFor(Ignite ignite) {
        IgniteAware<T> igniteAware = this.value;
        if (igniteAware.ignite() != ignite) {
            if (igniteAware.instance() instanceof AutoCloseable) {
                AutoCloseable closeable = (AutoCloseable)igniteAware.instance();
                try {
                    closeable.close();
                }
                catch (Exception ex) {
                    LOG.warn("Failed to close old instance of: " + closeable.getClass().getName(), new Object[0]);
                }
            }
            igniteAware = new IgniteAware<T>(this.supplier.apply(ignite), ignite);
            this.value = igniteAware;
        }
        return igniteAware.instance();
    }
}

