/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import java.util.function.Consumer;
import org.apache.ignite.internal.rocksdb.KeyEncryptorAdapter;
import org.apache.ignite.internal.util.OperatingSystem;
import org.gridgain.internal.encryption.EncryptionManager;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.GgEncryptionCallback;
import org.rocksdb.GgEncryptionEnv;
import org.rocksdb.KeyEncryptor;

public class EncryptionPluginUtils {
    private EncryptionPluginUtils() {
    }

    public static boolean isEncryptionSupported() {
        return OperatingSystem.current() == OperatingSystem.LINUX;
    }

    @Nullable
    public static GgEncryptionEnv createDbOptionsEnvironment(EncryptionManager encryptionManager, Consumer<AbstractNativeReference> resourceTracker) {
        if (encryptionManager.encryptionEnabled()) {
            assert (EncryptionPluginUtils.isEncryptionSupported()) : "Encryption is not supported on your platform";
            GgEncryptionCallback callback = new GgEncryptionCallback((KeyEncryptor)new KeyEncryptorAdapter(encryptionManager));
            resourceTracker.accept((AbstractNativeReference)callback);
            GgEncryptionEnv ggEnv = new GgEncryptionEnv(callback);
            resourceTracker.accept((AbstractNativeReference)ggEnv);
            return ggEnv;
        }
        return null;
    }
}

