/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.configuration;

import io.micronaut.http.HttpResponse;
import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.internal.rest.SecurityContextAware;

public abstract class AbstractConfigurationController
implements ResourceHolder,
SecurityContextAware {
    private ConfigurationPresentation<String> cfgPresentation;
    private final SecurityService securityService;

    public AbstractConfigurationController(ConfigurationPresentation<String> cfgPresentation, SecurityService securityService) {
        this.cfgPresentation = cfgPresentation;
        this.securityService = securityService;
    }

    public HttpResponse<String> getConfiguration() {
        return AbstractConfigurationController.plainTextResponse((String)this.secured(() -> (String)this.cfgPresentation.represent()));
    }

    public HttpResponse<String> getConfigurationByPath(String path) {
        try {
            return AbstractConfigurationController.plainTextResponse((String)this.secured(() -> (String)this.cfgPresentation.representByPath(path)));
        }
        catch (IllegalArgumentException ex) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)ex);
        }
    }

    private static HttpResponse<String> plainTextResponse(String text) {
        return HttpResponse.ok((Object)text).contentType((CharSequence)"text/plain");
    }

    public CompletableFuture<Void> updateConfiguration(String updatedConfiguration) {
        return (CompletableFuture)this.secured(() -> this.cfgPresentation.update((Object)updatedConfiguration));
    }

    public void cleanResources() {
        this.cfgPresentation = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

