/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.authentication;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.RestManager;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Filter(value={"/**"})
@Requires(property="ignite.endpoints.filter-non-initialized", value="true", defaultValue="true")
public class ClusterStateHttpServerFilter
implements HttpServerFilter,
ResourceHolder {
    public static final int ORDER = 0;
    private RestManager restManager;

    public ClusterStateHttpServerFilter(RestManager restManager) {
        this.restManager = restManager;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return Mono.just((Object)this.restManager.pathAvailability(request.getPath())).flatMap(availability -> {
            if (!availability.isAvailable()) {
                return Mono.just((Object)HttpProblemResponse.from((Problem)Problem.fromHttpCode((HttpCode)HttpCode.CONFLICT).title(availability.unavailableTitle()).detail(availability.unavailableReason()).build()));
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.from((Publisher)chain.proceed(request)));
    }

    public int getOrder() {
        return 0;
    }

    public void cleanResources() {
        this.restManager = null;
    }
}

