/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.recovery;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.recovery.DisasterRecoveryApi;
import org.apache.ignite.internal.rest.api.recovery.GlobalZonePartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.GlobalZonePartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalZonePartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalZonePartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.ResetZonePartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.RestartZonePartitionsRequest;
import org.apache.ignite.internal.rest.exception.handler.IgniteInternalExceptionHandler;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.GlobalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateByNode;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/recovery/")
@Requires(classes={IgniteInternalExceptionHandler.class})
public class DisasterRecoveryController
implements DisasterRecoveryApi,
ResourceHolder,
SecurityContextAware {
    private DisasterRecoveryManager disasterRecoveryManager;
    private SecurityService securityService;

    public DisasterRecoveryController(DisasterRecoveryManager disasterRecoveryManager, SecurityService securityService) {
        this.disasterRecoveryManager = disasterRecoveryManager;
        this.securityService = securityService;
    }

    public CompletableFuture<Void> resetZonePartitions(ResetZonePartitionsRequest command) {
        return (CompletableFuture)this.secured(() -> this.disasterRecoveryManager.resetPartitions(command.zoneName(), command.partitionIds()));
    }

    public CompletableFuture<Void> restartZonePartitions(RestartZonePartitionsRequest command) {
        return (CompletableFuture)this.secured(() -> this.disasterRecoveryManager.restartPartitions(command.nodeNames(), command.zoneName(), command.partitionIds()));
    }

    public CompletableFuture<Void> restartZonePartitionsWithCleanup(RestartZonePartitionsRequest command) {
        return this.disasterRecoveryManager.restartPartitionsWithCleanup(command.nodeNames(), command.zoneName(), command.partitionIds());
    }

    public CompletableFuture<LocalZonePartitionStatesResponse> getZoneLocalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<String>> nodeNames, Optional<Set<Integer>> partitionIds) {
        return this.disasterRecoveryManager.localPartitionStates(zoneNames.orElse(Collections.emptySet()), nodeNames.orElse(Collections.emptySet()), partitionIds.orElse(Collections.emptySet())).thenApply(DisasterRecoveryController::convertLocalZoneStates);
    }

    public CompletableFuture<GlobalZonePartitionStatesResponse> getZoneGlobalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<Integer>> partitionIds) {
        return this.disasterRecoveryManager.globalPartitionStates(zoneNames.orElse(Collections.emptySet()), partitionIds.orElse(Collections.emptySet())).thenApply(DisasterRecoveryController::convertGlobalZoneStates);
    }

    private static LocalZonePartitionStatesResponse convertLocalZoneStates(Map<ZonePartitionId, LocalPartitionStateByNode> localStates) {
        ArrayList<LocalZonePartitionStateResponse> states = new ArrayList<LocalZonePartitionStateResponse>();
        for (LocalPartitionStateByNode map : localStates.values()) {
            for (Map.Entry entry : map.entrySet()) {
                String nodeName = (String)entry.getKey();
                LocalPartitionState state = (LocalPartitionState)entry.getValue();
                states.add(new LocalZonePartitionStateResponse(nodeName, state.zoneName, state.partitionId, state.state.name(), state.estimatedRows));
            }
        }
        states.sort(Comparator.comparing(LocalZonePartitionStateResponse::partitionId).thenComparing(LocalZonePartitionStateResponse::nodeName));
        return new LocalZonePartitionStatesResponse(states);
    }

    private static GlobalZonePartitionStatesResponse convertGlobalZoneStates(Map<ZonePartitionId, GlobalPartitionState> globalStates) {
        ArrayList<GlobalZonePartitionStateResponse> states = new ArrayList<GlobalZonePartitionStateResponse>();
        for (GlobalPartitionState state : globalStates.values()) {
            states.add(new GlobalZonePartitionStateResponse(state.zoneName, state.partitionId, state.state.name()));
        }
        states.sort(Comparator.comparing(GlobalZonePartitionStateResponse::partitionId));
        return new GlobalZonePartitionStatesResponse(states);
    }

    public void cleanResources() {
        this.disasterRecoveryManager = null;
        this.securityService = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

