/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest;

import io.micronaut.security.utils.SecurityService;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;

public interface SecurityContextAware {
    default public <T> T secured(Supplier<T> supplier) {
        return GridGainSecurity.with((SecurityContext)this.createContext(), supplier).get();
    }

    default public void secured(Runnable runnable) {
        GridGainSecurity.with((SecurityContext)this.createContext(), (Runnable)runnable).run();
    }

    private SecurityContext createContext() {
        String username = this.securityService().username().orElse(null);
        Set roles = this.securityService().getAuthentication().map(a -> a.getRoles().stream()).orElse(Stream.of(new String[0])).collect(Collectors.toSet());
        return GridGainSecurity.context((String)username, roles);
    }

    public SecurityService securityService();
}

