/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.zone;

import io.micronaut.http.annotation.Controller;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.zone.DataNodesApi;

@Controller(value="/management/v1/zones")
public class DataNodesController
implements DataNodesApi,
ResourceHolder {
    private DistributionZoneManager distributionZoneManager;

    public DataNodesController(DistributionZoneManager distributionZoneManager) {
        this.distributionZoneManager = distributionZoneManager;
    }

    public CompletableFuture<Set<String>> getDataNodesForZone(String zoneName) {
        return this.distributionZoneManager.currentDataNodes(zoneName);
    }

    public CompletableFuture<Void> resetDataNodesForZone(String zoneName) {
        return this.distributionZoneManager.recalculateDataNodes(zoneName);
    }

    public CompletableFuture<Void> resetDataNodesForZones(Optional<Set<String>> zoneNames) {
        return this.distributionZoneManager.recalculateDataNodes(zoneNames.orElse(Set.of()));
    }

    public void cleanResources() {
        this.distributionZoneManager = null;
    }
}

