/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.sql;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.sql.SqlQueryApi;
import org.apache.ignite.internal.rest.api.sql.SqlQueryInfo;
import org.apache.ignite.internal.rest.sql.exception.SqlQueryKillException;
import org.apache.ignite.internal.rest.sql.exception.SqlQueryNotFoundException;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite.internal.sql.engine.api.kill.KillHandlerRegistry;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rest.SecurityContextAware;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/sql")
public class SqlQueryController
implements SqlQueryApi,
ResourceHolder,
SecurityContextAware {
    private static final IgniteLogger LOG = Loggers.forClass(SqlQueryController.class);
    private IgniteSql igniteSql;
    private KillHandlerRegistry killHandlerRegistry;
    private final SecurityService securityService;
    private Authorizer authorizer;

    public SqlQueryController(IgniteSql igniteSql, KillHandlerRegistry killHandlerRegistry, SecurityService securityService, Authorizer authorizer) {
        this.igniteSql = igniteSql;
        this.killHandlerRegistry = killHandlerRegistry;
        this.securityService = securityService;
        this.authorizer = authorizer;
    }

    public CompletableFuture<Collection<SqlQueryInfo>> queries() {
        return (CompletableFuture)this.secured(() -> this.authorizer.authorizeThenCompose(Action.GET_SQL_QUERY_STATE, this::sqlQueryInfos));
    }

    public CompletableFuture<SqlQueryInfo> query(UUID queryId) {
        Supplier<CompletableFuture> queryAction = () -> this.sqlQueryInfos(queryId).thenApply(queryInfo -> {
            Iterator iterator = queryInfo.iterator();
            if (iterator.hasNext()) {
                return (SqlQueryInfo)iterator.next();
            }
            throw new SqlQueryNotFoundException(queryId.toString());
        });
        return (CompletableFuture)this.secured(() -> this.authorizer.authorizeThenCompose(Action.GET_SQL_QUERY_STATE, queryAction));
    }

    public CompletableFuture<Void> killQuery(UUID queryId) {
        try {
            Supplier<CompletableFuture> cancelAction = () -> this.killHandlerRegistry.handler(CancellableOperationType.QUERY).cancelAsync(queryId.toString()).thenApply(result -> SqlQueryController.handleOperationResult(queryId, result));
            return (CompletableFuture)this.secured(() -> this.authorizer.authorizeThenCompose(Action.KILL_QUERY, cancelAction));
        }
        catch (Exception e) {
            LOG.error("Sql query {} can't be killed.", new Object[]{queryId, e});
            return CompletableFuture.failedFuture((Throwable)((Object)new SqlQueryKillException(queryId.toString())));
        }
    }

    public CompletableFuture<Void> clearCache(Optional<Set<String>> tableNames) {
        try {
            return ((QueryProcessor)Wrappers.unwrap((Object)this.igniteSql, QueryProcessor.class)).invalidatePlannerCache(tableNames.orElse(Set.of()));
        }
        catch (Exception e) {
            LOG.error("Failed to invalidate SQL planner cache.", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
    }

    private static Void handleOperationResult(UUID queryId, @Nullable Boolean result) {
        if (result != null && !result.booleanValue()) {
            throw new SqlQueryNotFoundException(queryId.toString());
        }
        return null;
    }

    public void cleanResources() {
        this.igniteSql = null;
        this.killHandlerRegistry = null;
        this.authorizer = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    private CompletableFuture<Collection<SqlQueryInfo>> sqlQueryInfos() {
        return this.sqlQueryInfos("SELECT * FROM SYSTEM.SQL_QUERIES ORDER BY START_TIME");
    }

    private CompletableFuture<Collection<SqlQueryInfo>> sqlQueryInfos(UUID queryId) {
        return this.sqlQueryInfos("SELECT * FROM SYSTEM.SQL_QUERIES WHERE ID='" + queryId.toString() + "'");
    }

    private CompletableFuture<Collection<SqlQueryInfo>> sqlQueryInfos(String query) {
        Statement sqlQueryStmt = this.igniteSql.createStatement(query);
        return this.igniteSql.executeAsync(null, sqlQueryStmt, new Object[0]).thenCompose(resultSet -> SqlQueryController.iterate((AsyncResultSet<SqlRow>)resultSet, new ArrayList<SqlQueryInfo>()));
    }

    private static CompletableFuture<Collection<SqlQueryInfo>> iterate(AsyncResultSet<SqlRow> resultSet, List<SqlQueryInfo> result) {
        for (SqlRow row : resultSet.currentPage()) {
            result.add(SqlQueryController.convert(row));
        }
        if (resultSet.hasMorePages()) {
            return resultSet.fetchNextPage().thenCompose(nextPage -> SqlQueryController.iterate((AsyncResultSet<SqlRow>)nextPage, result));
        }
        return CompletableFuture.completedFuture(result);
    }

    private static SqlQueryInfo convert(SqlRow row) {
        return new SqlQueryInfo(UUID.fromString(row.stringValue("ID")), row.stringValue("INITIATOR_NODE"), row.stringValue("PHASE"), row.stringValue("TYPE"), row.stringValue("SCHEMA"), row.stringValue("SQL"), row.timestampValue("START_TIME"));
    }
}

