/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.distribution;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.distribution.DistributionApi;
import org.apache.ignite.internal.rest.api.distribution.ResetDistributionRequest;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/distribution")
public class DistributionController
implements DistributionApi,
ResourceHolder,
SecurityContextAware {
    private DisasterRecoveryManager disasterRecoveryManager;
    private final SecurityService securityService;

    public DistributionController(DisasterRecoveryManager disasterRecoveryManager, SecurityService securityService) {
        this.disasterRecoveryManager = disasterRecoveryManager;
        this.securityService = securityService;
    }

    public CompletableFuture<Void> reset(@Body ResetDistributionRequest request) {
        return (CompletableFuture)this.secured(() -> this.disasterRecoveryManager.resetDistribution(request.zoneNames()));
    }

    public void cleanResources() {
        this.disasterRecoveryManager = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

