/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.snapshot;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.snapshot.CreateCommand;
import org.apache.ignite.internal.rest.api.snapshot.DeleteCommand;
import org.apache.ignite.internal.rest.api.snapshot.RestoreCommand;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotManagementApi;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotOperation;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotType;
import org.gridgain.internal.rest.SecurityContextAware;
import org.gridgain.internal.snapshots.SnapshotFacade;

@Controller(value="/management/v1/snapshot")
public class SnapshotManagementController
implements SnapshotManagementApi,
ResourceHolder,
SecurityContextAware {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotManagementController.class);
    private final SecurityService securityService;
    private SnapshotFacade snapshotFacade;

    public SnapshotManagementController(SnapshotFacade snapshotFacade, SecurityService securityService) {
        this.snapshotFacade = snapshotFacade;
        this.securityService = securityService;
    }

    public CompletableFuture<UUID> create(@Body CreateCommand createCommand) {
        Instant timestamp = createCommand.timestampEpochMilli() == null ? null : Instant.ofEpochMilli(createCommand.timestampEpochMilli());
        SnapshotType snapshotType = createCommand.snapshotType();
        Set tableNames = createCommand.tableNames();
        Set structureNames = createCommand.structureNames();
        String destination = createCommand.destination();
        String encryptionProvider = createCommand.encryptionProvider();
        LOG.info("Received snapshot creation command [snapshotType={}, tableNames={}, structureNames={}, timestamp={}, destination={}, encryptionProvider={}]", new Object[]{snapshotType, tableNames, structureNames, timestamp, destination, encryptionProvider});
        return (CompletableFuture)this.secured(() -> this.snapshotFacade.createSnapshot(snapshotType, tableNames, structureNames, destination, timestamp, encryptionProvider));
    }

    public CompletableFuture<List<SnapshotOperation>> getOperations() {
        return (CompletableFuture)this.secured(() -> this.snapshotFacade.getSnapshotOperationsList());
    }

    public CompletableFuture<List<SnapshotOperation>> getOperation(UUID operationId, boolean allNodes) {
        return (CompletableFuture)this.secured(() -> this.snapshotFacade.getOperationById(operationId, allNodes));
    }

    public CompletableFuture<UUID> restore(RestoreCommand restoreCommand) {
        UUID snapshotId = restoreCommand.snapshotId();
        Set tableNames = restoreCommand.tableNames();
        Set structureNames = restoreCommand.structureNames();
        String source = restoreCommand.source();
        String decryptionProvider = restoreCommand.decryptionProvider();
        boolean force = restoreCommand.force();
        LOG.info("Received snapshot restore command, snapshotId = {}, tableNames={}, structureNames={}, source={}, decryptionProvider={}, force={}", new Object[]{snapshotId, tableNames, structureNames, source, decryptionProvider, force});
        return (CompletableFuture)this.secured(() -> this.snapshotFacade.restoreSnapshot(snapshotId, tableNames, structureNames, source, decryptionProvider, force));
    }

    public CompletableFuture<UUID> delete(DeleteCommand deleteCommand) {
        LOG.info("Received snapshot delete command, snapshotId = {}", new Object[]{deleteCommand.snapshotId()});
        return (CompletableFuture)this.secured(() -> this.snapshotFacade.deleteSnapshot(deleteCommand.snapshotId()));
    }

    public void cleanResources() {
        this.snapshotFacade = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

