/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.rbac.privileges;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.rbac.assignmens.PrivilegeAssignment;
import org.apache.ignite.internal.rest.api.rbac.privileges.PrivilegesApi;
import org.apache.ignite.internal.rest.api.rbac.privileges.RolePrivileges;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.ActionAlias;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.PrivilegeAlias;
import org.gridgain.internal.rbac.privileges.PrivilegeManagement;
import org.gridgain.internal.rbac.privileges.exception.IllegalPrivilegeException;
import org.gridgain.internal.rest.SecurityContextAware;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/rbac/pg")
public class PrivilegesController
implements PrivilegesApi,
ResourceHolder,
SecurityContextAware {
    private PrivilegeManagement privilegeManagement;
    private final SecurityService securityService;

    public PrivilegesController(PrivilegeManagement privilegeManagement, SecurityService securityService) {
        this.privilegeManagement = privilegeManagement;
        this.securityService = securityService;
    }

    private static Action parseAction(String action) {
        try {
            return Action.valueOf((String)action);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalPrivilegeException("Wrong action: " + action);
        }
    }

    private static Collection<org.apache.ignite.internal.rest.api.rbac.privileges.Privilege> toDtos(Set<Privilege> privileges) {
        return privileges.stream().map(PrivilegesController::toDto).collect(Collectors.toList());
    }

    private static org.apache.ignite.internal.rest.api.rbac.privileges.Privilege toDto(Privilege privilege) {
        return new org.apache.ignite.internal.rest.api.rbac.privileges.Privilege(privilege.action().name(), privilege.selector().toRawString());
    }

    private static Set<Privilege> fromDtos(Set<org.apache.ignite.internal.rest.api.rbac.privileges.Privilege> privileges) {
        return privileges.stream().map(privilege -> PrivilegesController.fromDto(privilege.action(), privilege.on())).collect(Collectors.toSet());
    }

    private static Privilege fromDto(String action, @Nullable String selector) {
        return Privilege.builder().action(PrivilegesController.parseAction(action)).selector(selector).build();
    }

    @Nullable
    private static ActionAlias tryParseAlias(String action) {
        try {
            return ActionAlias.valueOf((String)action);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static PrivilegeAlias aliasFromDto(org.apache.ignite.internal.rest.api.rbac.privileges.Privilege privilege) {
        ActionAlias alias = PrivilegesController.tryParseAlias(privilege.action());
        if (alias == null) {
            throw new IllegalPrivilegeException("Wrong action: " + privilege.action());
        }
        return PrivilegeAlias.builder().selector(privilege.on()).alias(alias).build();
    }

    private static boolean isAlias(String action) {
        return PrivilegesController.tryParseAlias(action) != null;
    }

    public CompletableFuture<Iterable<org.apache.ignite.internal.rest.api.rbac.privileges.Privilege>> privileges(String roleName) {
        return (CompletableFuture)this.secured(() -> this.privilegeManagement.getPrivilegesAsync(roleName).thenApply(PrivilegesController::toDtos));
    }

    public CompletableFuture<Void> grant(PrivilegeAssignment privilegeAssignment) {
        org.apache.ignite.internal.rest.api.rbac.privileges.Privilege privilege;
        if (privilegeAssignment.privileges().size() == 1 && PrivilegesController.isAlias((privilege = (org.apache.ignite.internal.rest.api.rbac.privileges.Privilege)privilegeAssignment.privileges().stream().findFirst().get()).action())) {
            return (CompletableFuture)this.secured(() -> this.privilegeManagement.grantAsync(PrivilegesController.aliasFromDto(privilege), privilegeAssignment.roleNames()));
        }
        return (CompletableFuture)this.secured(() -> this.privilegeManagement.grantAsync(PrivilegesController.fromDtos(privilegeAssignment.privileges()), privilegeAssignment.roleNames()));
    }

    public CompletableFuture<Void> revoke(PrivilegeAssignment privilegeAssignment) {
        org.apache.ignite.internal.rest.api.rbac.privileges.Privilege privilege;
        if (privilegeAssignment.privileges().size() == 1 && PrivilegesController.isAlias((privilege = (org.apache.ignite.internal.rest.api.rbac.privileges.Privilege)privilegeAssignment.privileges().stream().findFirst().get()).action())) {
            return (CompletableFuture)this.secured(() -> this.privilegeManagement.revokeAsync(PrivilegesController.aliasFromDto(privilege), privilegeAssignment.roleNames()));
        }
        return (CompletableFuture)this.secured(() -> this.privilegeManagement.revokeAsync(PrivilegesController.fromDtos(privilegeAssignment.privileges()), privilegeAssignment.roleNames()));
    }

    public CompletableFuture<Iterable<RolePrivileges>> rolesWithPrivileges() {
        return (CompletableFuture)this.secured(() -> this.privilegeManagement.getRolesWithPrivilegesAsync().thenApply(rolePrivileges -> rolePrivileges.entrySet().stream().map(entry -> new RolePrivileges((String)entry.getKey(), PrivilegesController.toDtos((Set)entry.getValue()))).collect(Collectors.toList())));
    }

    public void cleanResources() {
        this.privilegeManagement = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

