/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.license;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.license.License;
import org.apache.ignite.internal.rest.api.license.LicenseApi;
import org.apache.ignite.internal.rest.api.license.LicenseFeatureSet;
import org.apache.ignite.internal.rest.api.license.LicenseId;
import org.apache.ignite.internal.rest.api.license.LicenseInfo;
import org.apache.ignite.internal.rest.api.license.LicenseLimits;
import org.gridgain.internal.license.GridLicenseManager;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/license")
public class LicenseController
implements LicenseApi,
ResourceHolder,
SecurityContextAware {
    private LicenseFeatureChecker licenseFeatureChecker;
    private final SecurityService securityService;
    private final GridLicenseManager licenseManager;
    private final ObjectMapper mapper;

    public LicenseController(LicenseFeatureChecker licenseFeatureChecker, SecurityService securityService, GridLicenseManager licenseManager) {
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.securityService = securityService;
        this.licenseManager = licenseManager;
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public CompletableFuture<LicenseFeatureSet> features() {
        Set licenseFeatures = this.licenseFeatureChecker.enabledFeatures().stream().map(LicenseController::toRestLicenseFeature).collect(Collectors.toSet());
        return CompletableFuture.completedFuture(new LicenseFeatureSet(licenseFeatures));
    }

    public CompletableFuture<LicenseLimits> limits() {
        return CompletableFuture.completedFuture(this.readCurrentLicense().getLimits());
    }

    public CompletableFuture<LicenseInfo> infos() {
        return CompletableFuture.completedFuture(this.readCurrentLicense().getInfos());
    }

    public CompletableFuture<LicenseId> id() {
        return CompletableFuture.completedFuture(new LicenseId(this.readCurrentLicense().getId()));
    }

    public CompletableFuture<License> get() {
        return CompletableFuture.completedFuture(this.readCurrentLicense());
    }

    private License readCurrentLicense() {
        try {
            return (License)this.mapper.readValue(this.licenseManager.getCurrentLicense(), License.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to read license", e);
        }
    }

    public CompletableFuture<Void> post(License licenseInfo) {
        try {
            if (licenseInfo.getFeatures() == null) {
                licenseInfo.setFeatures(List.of());
            }
            String jsonLicense = this.mapper.writeValueAsString((Object)licenseInfo);
            return this.postRaw(jsonLicense);
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Void> postRaw(String license) {
        try {
            this.validate(license);
            return this.licenseManager.applyNewLicense(license).handle((res, ex) -> {
                if (ex != null) {
                    throw new LicenseViolationException(ex.getMessage());
                }
                return null;
            });
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private static org.apache.ignite.internal.rest.api.license.LicenseFeature toRestLicenseFeature(LicenseFeature licenseFeature) {
        return org.apache.ignite.internal.rest.api.license.LicenseFeature.builder().id(licenseFeature.name()).name(licenseFeature.fullName()).build();
    }

    public void cleanResources() {
        this.licenseFeatureChecker = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    private void validate(String license) throws JsonProcessingException {
        this.mapper.readValue(license, License.class);
    }
}

