/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.upgrade;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.upgrade.RollingUpgradeApi;
import org.apache.ignite.internal.rest.api.upgrade.UpgradeStateResponse;
import org.apache.ignite.internal.util.StringUtils;
import org.gridgain.internal.rest.SecurityContextAware;
import org.gridgain.internal.rest.upgrade.exception.VersionIsNotDefinedException;
import org.gridgain.internal.upgrade.RollingUpgradeManager;

@Controller(value="/management/v1/upgrade")
public class RollingUpgradeController
implements RollingUpgradeApi,
ResourceHolder,
SecurityContextAware {
    private RollingUpgradeManager upgradeManager;
    private final SecurityService securityService;

    public RollingUpgradeController(RollingUpgradeManager upgradeManager, SecurityService securityService) {
        this.upgradeManager = upgradeManager;
        this.securityService = securityService;
    }

    public CompletableFuture<Boolean> startUpgrade(String version) {
        if (StringUtils.nullOrBlank((String)version)) {
            throw new VersionIsNotDefinedException("Version is not defined.");
        }
        return (CompletableFuture)this.secured(() -> this.upgradeManager.startUpgrade(version));
    }

    public CompletableFuture<Boolean> commitUpgrade() {
        return (CompletableFuture)this.secured(() -> this.upgradeManager.commitUpgrade());
    }

    public CompletableFuture<Boolean> cancelUpgrade() {
        return (CompletableFuture)this.secured(() -> this.upgradeManager.cancelUpgrade());
    }

    public CompletableFuture<UpgradeStateResponse> upgradeState() {
        return ((CompletableFuture)this.secured(() -> this.upgradeManager.upgradeState())).thenApply(state -> new UpgradeStateResponse(state.currentVersion(), state.nextVersion(), state.currentVersionNodes(), state.nextVersionNodes()));
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    public void cleanResources() {
        this.upgradeManager = null;
    }
}

