/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.rbac.user;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.rbac.user.CreateUserRequest;
import org.apache.ignite.internal.rest.api.rbac.user.UserDto;
import org.apache.ignite.internal.rest.api.rbac.user.UserManagementApi;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rbac.users.UserManagement;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/rbac/users")
public class UserManagementController
implements UserManagementApi,
ResourceHolder,
SecurityContextAware {
    private UserManagement userManagement;
    private final SecurityService securityService;

    public UserManagementController(UserManagement userManagement, SecurityService securityService) {
        this.userManagement = userManagement;
        this.securityService = securityService;
    }

    private static UserDto toDto(User user) {
        if (user == null) {
            return null;
        }
        return new UserDto(user.username());
    }

    private static <U> Iterable<UserDto> toDto(Iterable<User> users) {
        ArrayList<UserDto> userList = new ArrayList<UserDto>();
        for (User user : users) {
            UserDto dtoUser = UserManagementController.toDto(user);
            if (dtoUser == null) continue;
            userList.add(dtoUser);
        }
        return userList;
    }

    private static User toUser(CreateUserRequest createUserRequest) {
        return User.builder().username(createUserRequest.username()).password(createUserRequest.plainPassword()).build();
    }

    public CompletableFuture<Iterable<UserDto>> users() {
        return (CompletableFuture)this.secured(() -> this.userManagement.findAllAsync().thenApply(UserManagementController::toDto));
    }

    public CompletableFuture<UserDto> user(String username) {
        return (CompletableFuture)this.secured(() -> this.userManagement.findByUsernameAsync(username).thenApply(UserManagementController::toDto));
    }

    public CompletableFuture<Void> create(CreateUserRequest createUserRequest) {
        return (CompletableFuture)this.secured(() -> this.userManagement.createAsync(UserManagementController.toUser(createUserRequest)));
    }

    public CompletableFuture<Void> delete(String username) {
        return (CompletableFuture)this.secured(() -> this.userManagement.dropByUsernameAsync(username));
    }

    public CompletableFuture<Void> update(String username, CreateUserRequest createUserRequest) {
        return (CompletableFuture)this.secured(() -> this.userManagement.updateAsync(username, UserManagementController.toUser(createUserRequest)));
    }

    public void cleanResources() {
        this.userManagement = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

