/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.deployment;

import io.micronaut.http.multipart.CompletedFileUpload;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.deployunit.DeploymentUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.deployment.InputStreamCollector;
import org.apache.ignite.internal.rest.deployment.InputStreamCollectorImpl;
import org.apache.ignite.internal.rest.deployment.ZipInputStreamCollector;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class CompletedFileUploadSubscriber
implements Subscriber<CompletedFileUpload> {
    private static final IgniteLogger LOG = Loggers.forClass(CompletedFileUploadSubscriber.class);
    private final CompletableFuture<DeploymentUnit> result = new CompletableFuture();
    private final InputStreamCollector collector;
    private Throwable ex;

    public CompletedFileUploadSubscriber(boolean unzip) {
        this.collector = unzip ? new ZipInputStreamCollector() : new InputStreamCollectorImpl();
    }

    public void onSubscribe(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(CompletedFileUpload item) {
        try {
            this.collector.addInputStream(item.getFilename(), item.getInputStream());
        }
        catch (IOException e) {
            LOG.error("Failed to read file: " + item.getFilename(), (Throwable)e);
            this.suppressException(e);
        }
    }

    public void onError(Throwable throwable) {
        try {
            this.collector.close();
        }
        catch (Exception e) {
            this.suppressException(e);
        }
        this.suppressException(throwable);
        this.result.completeExceptionally(this.ex);
    }

    public void onComplete() {
        if (this.ex != null) {
            this.result.completeExceptionally(this.ex);
        } else {
            try {
                DeploymentUnit deploymentUnit = this.collector.toDeploymentUnit();
                this.result.complete(deploymentUnit);
            }
            catch (Exception e) {
                this.suppressException(e);
                try {
                    this.collector.close();
                }
                catch (Exception e2) {
                    this.suppressException(e2);
                }
                this.result.completeExceptionally(this.ex);
            }
        }
    }

    private void suppressException(Throwable t) {
        LOG.warn("Deployment unit subscriber error: ", t);
        if (this.ex == null) {
            this.ex = t;
        } else {
            this.ex.addSuppressed(t);
        }
    }

    public CompletableFuture<DeploymentUnit> result() {
        return this.result;
    }
}

