/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheGetValueTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheModifyTaskResult;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
@GridVisorManagementTask
public class VisorCacheGetValueTask
extends VisorOneNodeTask<VisorCacheGetValueTaskArg, VisorCacheModifyTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheGetValueJob job(VisorCacheGetValueTaskArg arg) {
        return new VisorCacheGetValueJob(arg, this.debug);
    }

    private static class VisorCacheGetValueJob
    extends VisorJob<VisorCacheGetValueTaskArg, VisorCacheModifyTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorCacheGetValueJob(VisorCacheGetValueTaskArg arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorCacheModifyTaskResult run(VisorCacheGetValueTaskArg arg) {
            assert (arg != null);
            String cacheName = arg.getCacheName();
            assert (cacheName != null);
            IgniteCache cache = this.ignite.cache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Failed to find cache with specified name: " + arg.getCacheName());
            }
            Object key = arg.getKeyValueHolder().getKey();
            assert (key != null);
            ClusterNode node = this.ignite.affinity(cacheName).mapKeyToNode(key);
            UUID nid = node != null ? node.id() : null;
            Object val = cache.withKeepBinary().get(key);
            return new VisorCacheModifyTaskResult(nid, val instanceof BinaryObject ? U.compact((String)((BinaryObject)val).type().typeName()) : VisorTaskUtils.compactClass((Object)val), val);
        }

        public String toString() {
            return S.toString(VisorCacheGetValueJob.class, (Object)((Object)this));
        }
    }
}

